/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.adt.learner;

import de.learnlib.Resumable;
import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.algorithm.adt.adt.ADT;
import de.learnlib.algorithm.adt.adt.ADTLeafNode;
import de.learnlib.algorithm.adt.adt.ADTNode;
import de.learnlib.algorithm.adt.adt.ADTResetNode;
import de.learnlib.algorithm.adt.api.ADTExtender;
import de.learnlib.algorithm.adt.api.LeafSplitter;
import de.learnlib.algorithm.adt.api.PartialTransitionAnalyzer;
import de.learnlib.algorithm.adt.api.SubtreeReplacer;
import de.learnlib.algorithm.adt.automaton.ADTHypothesis;
import de.learnlib.algorithm.adt.automaton.ADTState;
import de.learnlib.algorithm.adt.automaton.ADTTransition;
import de.learnlib.algorithm.adt.config.ADTExtenders;
import de.learnlib.algorithm.adt.config.LeafSplitters;
import de.learnlib.algorithm.adt.config.SubtreeReplacers;
import de.learnlib.algorithm.adt.learner.ADSAmbiguityQuery;
import de.learnlib.algorithm.adt.learner.ADSVerificationQuery;
import de.learnlib.algorithm.adt.learner.ADTAdaptiveQuery;
import de.learnlib.algorithm.adt.learner.ADTLearnerState;
import de.learnlib.algorithm.adt.learner.Adaptive2MembershipWrapper;
import de.learnlib.algorithm.adt.model.ExtensionResult;
import de.learnlib.algorithm.adt.model.ObservationTree;
import de.learnlib.algorithm.adt.model.ReplacementResult;
import de.learnlib.algorithm.adt.util.ADTUtil;
import de.learnlib.counterexample.LocalSuffixFinder;
import de.learnlib.counterexample.LocalSuffixFinders;
import de.learnlib.logging.Category;
import de.learnlib.oracle.AdaptiveMembershipOracle;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.DefaultQuery;
import de.learnlib.util.MQUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.SupportsGrowingAlphabet;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.common.util.HashUtil;
import net.automatalib.common.util.Pair;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ADTLearner<I, O>
implements LearningAlgorithm.MealyLearner<I, O>,
PartialTransitionAnalyzer<ADTState<I, O>, I>,
SupportsGrowingAlphabet<I>,
Resumable<ADTLearnerState<ADTState<I, O>, I, O>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ADTLearner.class);
    private final Alphabet<I> alphabet;
    private final AdaptiveMembershipOracle<I, O> oracle;
    private final MembershipOracle.MealyMembershipOracle<I, O> mqo;
    private final LeafSplitter leafSplitter;
    private final ADTExtender adtExtender;
    private final SubtreeReplacer subtreeReplacer;
    private final Queue<ADTTransition<I, O>> openTransitions;
    private final Queue<DefaultQuery<I, Word<O>>> openCounterExamples;
    private final Set<DefaultQuery<I, Word<O>>> allCounterExamples;
    private final ObservationTree<ADTState<I, O>, I, O> observationTree;
    private final LocalSuffixFinder<? super I, ? super Word<O>> suffixFinder;
    private ADTHypothesis<I, O> hypothesis;
    private ADT<ADTState<I, O>, I, O> adt;

    public ADTLearner(Alphabet<I> alphabet, AdaptiveMembershipOracle<I, O> oracle, LeafSplitter leafSplitter, ADTExtender adtExtender, SubtreeReplacer subtreeReplacer) {
        this(alphabet, oracle, leafSplitter, adtExtender, subtreeReplacer, true, LocalSuffixFinders.RIVEST_SCHAPIRE);
    }

    public ADTLearner(Alphabet<I> alphabet, AdaptiveMembershipOracle<I, O> oracle, LeafSplitter leafSplitter, ADTExtender adtExtender, SubtreeReplacer subtreeReplacer, boolean useObservationTree, LocalSuffixFinder<? super I, ? super Word<O>> suffixFinder) {
        this.alphabet = alphabet;
        this.observationTree = new ObservationTree(this.alphabet, oracle, useObservationTree);
        this.oracle = this.observationTree;
        this.mqo = new Adaptive2MembershipWrapper<I, O>(oracle);
        this.leafSplitter = leafSplitter;
        this.adtExtender = adtExtender;
        this.subtreeReplacer = subtreeReplacer;
        this.suffixFinder = suffixFinder;
        this.hypothesis = new ADTHypothesis(this.alphabet);
        this.openTransitions = new ArrayDeque<ADTTransition<I, O>>();
        this.openCounterExamples = new ArrayDeque<DefaultQuery<I, Word<O>>>();
        this.allCounterExamples = new LinkedHashSet<DefaultQuery<I, Word<O>>>();
        this.adt = new ADT();
    }

    public void startLearning() {
        ADTState initialState = (ADTState)((Object)this.hypothesis.addInitialState());
        initialState.setAccessSequence(Word.epsilon());
        this.observationTree.initialize(initialState);
        this.adt.initialize(initialState);
        for (Object i : this.alphabet) {
            this.openTransitions.add(this.hypothesis.createOpenTransition(initialState, i, this.adt.getRoot()));
        }
        this.closeTransitions();
    }

    public boolean refineHypothesis(DefaultQuery<I, Word<O>> ce) {
        if (!MQUtil.isCounterexample(ce, this.hypothesis)) {
            return false;
        }
        this.evaluateSubtreeReplacement();
        this.openCounterExamples.add(ce);
        while (!this.openCounterExamples.isEmpty()) {
            while (!this.openCounterExamples.isEmpty()) {
                @NonNull DefaultQuery<I, Word<O>> currentCE = this.openCounterExamples.poll();
                this.allCounterExamples.add(currentCE);
                while (this.refineHypothesisInternal(currentCE)) {
                }
            }
            for (DefaultQuery<I, Word<O>> oldCE : this.allCounterExamples) {
                if (!MQUtil.isCounterexample(oldCE, this.hypothesis)) continue;
                this.openCounterExamples.add(oldCE);
            }
            ADTUtil.collectLeaves(this.adt.getRoot()).forEach(this::ensureConsistency);
        }
        return true;
    }

    public boolean refineHypothesisInternal(DefaultQuery<I, Word<O>> ceQuery) {
        ADTNode<ADTState<I, O>, I, O> newNode;
        if (!MQUtil.isCounterexample(ceQuery, this.hypothesis)) {
            return false;
        }
        int suffixIdx = this.suffixFinder.findSuffixIndex(ceQuery, this.hypothesis, this.hypothesis, this.mqo);
        if (suffixIdx == -1) {
            throw new IllegalStateException();
        }
        Word ceInput = ceQuery.getInput();
        Word u = ceInput.prefix(suffixIdx - 1);
        Word ua = ceInput.prefix(suffixIdx);
        Object a = ceInput.getSymbol(suffixIdx - 1);
        Word v = ceInput.subWord(suffixIdx);
        ADTState uState = (ADTState)((Object)this.hypothesis.getState((Iterable)u));
        ADTState uaState = (ADTState)((Object)this.hypothesis.getState((Iterable)ua));
        assert (uState != null && uaState != null);
        Word uAccessSequence = uState.getAccessSequence();
        Word uaAccessSequence = uaState.getAccessSequence();
        Word uAccessSequenceWithA = uAccessSequence.append(a);
        ADTState newState = (ADTState)((Object)this.hypothesis.addState());
        newState.setAccessSequence(uAccessSequenceWithA);
        ADTTransition oldTrans = (ADTTransition)this.hypothesis.getTransition(uState, a);
        assert (oldTrans != null);
        oldTrans.setTarget(newState);
        oldTrans.setIsSpanningTreeEdge(true);
        ADTNode<ADTState<I, O>, I, O> nodeToSplit = this.findNodeForState(uaState);
        this.observationTree.addState(newState, newState.getAccessSequence(), oldTrans.getOutput());
        this.observationTree.addTrace(newState, nodeToSplit);
        Word previousTrace = (Word)ADTUtil.buildTraceForNode(nodeToSplit).getFirst();
        Word<I> extension = this.observationTree.findSeparatingWord(uaState, newState, previousTrace);
        if (extension == null) {
            this.observationTree.addTrace(uaState, v, (Word)this.mqo.answerQuery(uaAccessSequence, v));
            this.observationTree.addTrace(newState, v, (Word)this.mqo.answerQuery(uAccessSequenceWithA, v));
            Word otSepWord = this.observationTree.findSeparatingWord(uaState, newState);
            assert (otSepWord != null);
            Word splitter = otSepWord.length() < v.length() ? otSepWord : v;
            Word<O> oldOutput = this.observationTree.trace(uaState, splitter);
            Word<O> newOutput = this.observationTree.trace(newState, splitter);
            newNode = this.adt.splitLeaf(nodeToSplit, splitter, oldOutput, newOutput, this.leafSplitter);
        } else {
            Word completeSplitter = previousTrace.concat(new Word[]{extension});
            Word<O> oldOutput = this.observationTree.trace(uaState, completeSplitter);
            Word<O> newOutput = this.observationTree.trace(newState, completeSplitter);
            newNode = this.adt.extendLeaf(nodeToSplit, completeSplitter, oldOutput, newOutput, this.leafSplitter);
        }
        newNode.setState((Object)newState);
        ADTNode<ADTState<I, O>, I, O> temporarySplitter = ADTUtil.getStartOfADS(nodeToSplit);
        ArrayList<ADTTransition<Object, O>> newTransitions = new ArrayList<ADTTransition<Object, O>>(this.alphabet.size());
        for (Object i : this.alphabet) {
            newTransitions.add(this.hypothesis.createOpenTransition(newState, i, this.adt.getRoot()));
        }
        List<ADTTransition<I, O>> transitionsToRefine = this.getIncomingNonSpanningTreeTransitions(uaState);
        for (ADTTransition x : transitionsToRefine) {
            x.setTarget(null);
            x.setSiftNode(temporarySplitter);
        }
        ADTNode<ADTState<I, O>, I, O> finalizedSplitter = this.evaluateAdtExtension(temporarySplitter);
        for (ADTTransition<I, O> t : transitionsToRefine) {
            if (!t.needsSifting()) continue;
            t.setSiftNode(finalizedSplitter);
            this.openTransitions.add(t);
        }
        for (ADTTransition<I, O> t : newTransitions) {
            if (!t.needsSifting()) continue;
            this.openTransitions.add(t);
        }
        this.closeTransitions();
        return true;
    }

    private ADTNode<ADTState<I, O>, I, O> findNodeForState(ADTState<I, O> state) {
        for (ADTNode<ADTState<I, O>, I, O> leaf : ADTUtil.collectLeaves(this.adt.getRoot())) {
            if (!((Object)((Object)((ADTState)((Object)leaf.getState())))).equals(state)) continue;
            return leaf;
        }
        throw new IllegalStateException("Cannot find leaf for state " + state);
    }

    public MealyMachine<?, I, ?, O> getHypothesisModel() {
        return this.hypothesis;
    }

    private void closeTransitions() {
        while (!this.openTransitions.isEmpty()) {
            ArrayList queries = new ArrayList(this.openTransitions.size());
            for (ADTTransition aDTTransition : this.openTransitions) {
                if (!aDTTransition.needsSifting()) continue;
                queries.add(new ADTAdaptiveQuery(aDTTransition, aDTTransition.getSiftNode()));
            }
            this.openTransitions.clear();
            this.oracle.processQueries(queries);
            for (ADTAdaptiveQuery aDTAdaptiveQuery : queries) {
                this.processAnsweredQuery(aDTAdaptiveQuery);
            }
        }
    }

    @Override
    public void closeTransition(ADTState<I, O> state, I input) {
        ADTTransition transition = (ADTTransition)this.hypothesis.getTransition(state, input);
        assert (transition != null);
        if (transition.needsSifting()) {
            ADTNode ads = transition.getSiftNode();
            int oldNumberOfFinalStates = ADTUtil.collectLeaves(ads).size();
            ADTAdaptiveQuery query = new ADTAdaptiveQuery(transition, transition.getSiftNode());
            this.oracle.processQueries(Collections.singleton(query));
            this.processAnsweredQuery(query);
            int newNumberOfFinalStates = ADTUtil.collectLeaves(ads).size();
            if (oldNumberOfFinalStates < newNumberOfFinalStates) {
                throw PartialTransitionAnalyzer.HYPOTHESIS_MODIFICATION_EXCEPTION;
            }
        }
    }

    private void processAnsweredQuery(ADTAdaptiveQuery<I, O> query) {
        if (query.needsPostProcessing()) {
            Object out;
            ADTNode parent = query.getCurrentADTNode();
            ADTNode succ = parent.getChild(out = query.getTempOut());
            if (succ == null) {
                ADTState newState = (ADTState)((Object)this.hypothesis.addState());
                Word longPrefix = query.getAccessSequence().append(query.getTransition().getInput());
                newState.setAccessSequence(longPrefix);
                ADTTransition<I, O> transition = query.getTransition();
                transition.setTarget(newState);
                transition.setIsSpanningTreeEdge(true);
                ADTLeafNode result = new ADTLeafNode(parent, newState);
                parent.getChildren().put(out, result);
                O transitionOutput = query.getTransition().getOutput();
                this.observationTree.addState(newState, longPrefix, transitionOutput);
                for (Object i : this.alphabet) {
                    this.openTransitions.add(this.hypothesis.createOpenTransition(newState, i, this.adt.getRoot()));
                }
            } else {
                assert (ADTUtil.isLeafNode(succ));
                query.getTransition().setTarget((ADTState)((Object)succ.getState()));
            }
        } else {
            ADTTransition<I, O> transition = query.getTransition();
            ADTNode adtNode = query.getCurrentADTNode();
            assert (ADTUtil.isLeafNode(adtNode));
            transition.setTarget((ADTState)((Object)adtNode.getState()));
        }
    }

    @Override
    public boolean isTransitionDefined(ADTState<I, O> state, I input) {
        ADTTransition transition = (ADTTransition)this.hypothesis.getTransition(state, input);
        assert (transition != null);
        return !transition.needsSifting();
    }

    public void addAlphabetSymbol(I symbol) {
        if (!this.alphabet.containsSymbol(symbol)) {
            this.alphabet.asGrowingAlphabetOrThrowException().addSymbol(symbol);
        }
        this.hypothesis.addAlphabetSymbol(symbol);
        this.observationTree.addAlphabetSymbol(symbol);
        if (this.hypothesis.getInitialState() != null && this.hypothesis.getSuccessor((Object)((ADTState)this.hypothesis.getInitialState()), symbol) == null) {
            for (ADTState s : this.hypothesis.getStates()) {
                this.openTransitions.add(this.hypothesis.createOpenTransition(s, symbol, this.adt.getRoot()));
            }
            this.closeTransitions();
        }
    }

    public ADTLearnerState<ADTState<I, O>, I, O> suspend() {
        return new ADTLearnerState<ADTState<I, O>, I, O>(this.hypothesis, this.adt);
    }

    public void resume(ADTLearnerState<ADTState<I, O>, I, O> state) {
        this.hypothesis = state.getHypothesis();
        this.adt = state.getAdt();
        Alphabet oldAlphabet = this.hypothesis.getInputAlphabet();
        if (!oldAlphabet.equals(this.alphabet)) {
            LOGGER.warn(Category.DATASTRUCTURE, "The current alphabet '{}' differs from the resumed alphabet '{}'. Future behavior may be inconsistent", this.alphabet, (Object)oldAlphabet);
        }
        if (this.hypothesis.size() > 0) {
            this.observationTree.initialize(this.hypothesis.getStates(), ADTState::getAccessSequence, arg_0 -> this.hypothesis.computeOutput(arg_0));
        }
    }

    private void ensureConsistency(ADTNode<ADTState<I, O>, I, O> leaf) {
        ADTState state = (ADTState)((Object)leaf.getState());
        Word as = state.getAccessSequence();
        Word asOut = (Word)this.hypothesis.computeOutput((Iterable)as);
        ADTNode iter = leaf;
        while (iter != null) {
            Pair<Word<I>, Word<O>> trace = ADTUtil.buildTraceForNode(iter);
            Word input = (Word)trace.getFirst();
            Word output = (Word)trace.getSecond();
            Word hypOut = this.hypothesis.computeStateOutput((Object)state, (Iterable)input);
            if (!hypOut.equals((Object)output)) {
                this.openCounterExamples.add(new DefaultQuery(as.concat(new Word[]{input}), (Object)asOut.concat(new Word[]{output})));
            }
            iter = (ADTNode)ADTUtil.getStartOfADS(iter).getParent();
        }
    }

    private ADTNode<ADTState<I, O>, I, O> evaluateAdtExtension(ADTNode<ADTState<I, O>, I, O> ads) {
        ExtensionResult<ADTState<I, O>, I, O> potentialExtension = this.adtExtender.computeExtension(this.hypothesis, this, ads);
        if (potentialExtension.isCounterExample()) {
            this.openCounterExamples.add(potentialExtension.getCounterExample());
            return ads;
        }
        if (!potentialExtension.isReplacement()) {
            return ads;
        }
        ADTNode<ADTState<I, O>, I, O> extension = potentialExtension.getReplacement();
        ADTNode nodeToReplace = (ADTNode)ads.getParent();
        assert (extension != null && nodeToReplace != null && this.validateADS(nodeToReplace, extension, Collections.emptySet()));
        ADTNode<ADTState<I, O>, I, O> replacement = this.verifyADS(nodeToReplace, extension, ADTUtil.collectLeaves(this.adt.getRoot()), Collections.emptySet());
        int oldCosts = ADTUtil.computeEffectiveResets(nodeToReplace);
        int newCosts = ADTUtil.computeEffectiveResets(replacement);
        if (newCosts >= oldCosts) {
            return ads;
        }
        this.adt.replaceNode(nodeToReplace, replacement);
        ADTNode<ADTState<I, O>, I, O> finalizedADS = ADTUtil.getStartOfADS(replacement);
        this.resiftAffectedTransitions(ADTUtil.collectLeaves(extension), finalizedADS);
        return finalizedADS;
    }

    private void evaluateSubtreeReplacement() {
        ADTNode<ADTState<I, O>, I, O> nodeToReplace;
        if (this.hypothesis.size() == 1) {
            return;
        }
        Set<ReplacementResult<ADTState<I, O>, I, O>> potentialReplacements = this.subtreeReplacer.computeReplacements(this.hypothesis, this.alphabet, this.adt);
        ArrayList<ReplacementResult<ADTState<I, O>, I, O>> validReplacements = new ArrayList<ReplacementResult<ADTState<I, O>, I, O>>(potentialReplacements.size());
        Set<ADTNode<ADTState<I, O>, I, O>> cachedLeaves = potentialReplacements.isEmpty() ? Collections.emptySet() : ADTUtil.collectLeaves(this.adt.getRoot());
        for (ReplacementResult<ADTState<I, O>, I, O> potentialReplacement : potentialReplacements) {
            ADTNode<ADTState<I, O>, I, O> proposedReplacement = potentialReplacement.getReplacement();
            nodeToReplace = potentialReplacement.getNodeToReplace();
            assert (this.validateADS(nodeToReplace, proposedReplacement, potentialReplacement.getCutoutNodes()));
            ADTNode<ADTState<I, O>, I, O> replacement = this.verifyADS(nodeToReplace, proposedReplacement, cachedLeaves, potentialReplacement.getCutoutNodes());
            int oldCosts = ADTUtil.computeEffectiveResets(nodeToReplace);
            int newCosts = ADTUtil.computeEffectiveResets(replacement);
            if (newCosts >= oldCosts) continue;
            validReplacements.add(new ReplacementResult<ADTState<I, O>, I, O>(nodeToReplace, replacement));
        }
        for (ReplacementResult<ADTState<I, O>, I, O> potentialReplacement : validReplacements) {
            ADTNode<ADTState<I, O>, I, O> replacement = potentialReplacement.getReplacement();
            nodeToReplace = potentialReplacement.getNodeToReplace();
            this.adt.replaceNode(nodeToReplace, replacement);
            this.resiftAffectedTransitions(ADTUtil.collectLeaves(replacement), ADTUtil.getStartOfADS(replacement));
        }
        this.closeTransitions();
    }

    private boolean validateADS(ADTNode<ADTState<I, O>, I, O> oldADS, ADTNode<ADTState<I, O>, I, O> newADS, Set<ADTState<I, O>> cutout) {
        Set<ADTNode<ADTState<I, O>, I, O>> oldNodes = ADTUtil.isResetNode(oldADS) ? ADTUtil.collectResetNodes(this.adt.getRoot()) : ADTUtil.collectADSNodes(this.adt.getRoot(), true);
        if (!oldNodes.contains(oldADS)) {
            throw new IllegalArgumentException("Subtree to replace does not exist");
        }
        Set<ADTNode<ADTState<I, O>, I, O>> newFinalNodes = ADTUtil.collectLeaves(newADS);
        HashMap<ADTState, Pair<Word<I>, Word<O>>> traces = new HashMap<ADTState, Pair<Word<I>, Word<O>>>(HashUtil.capacity((int)newFinalNodes.size()));
        for (ADTNode<ADTState<I, O>, I, O> n : newFinalNodes) {
            traces.put((ADTState)((Object)n.getState()), ADTUtil.buildTraceForNode(n));
        }
        Set<ADTState<I, O>> oldFinalStates = ADTUtil.collectHypothesisStates(oldADS);
        HashSet newFinalStates = new HashSet(traces.keySet());
        newFinalStates.addAll(cutout);
        if (!oldFinalStates.equals(newFinalStates)) {
            throw new IllegalArgumentException("New ADS does not cover all old nodes");
        }
        Word parentInputTrace = (Word)ADTUtil.buildTraceForNode(oldADS).getFirst();
        for (Map.Entry entry : traces.entrySet()) {
            Word accessSequence = ((ADTState)((Object)entry.getKey())).getAccessSequence();
            Word prefix = accessSequence.concat(new Word[]{parentInputTrace});
            Word input = (Word)((Pair)entry.getValue()).getFirst();
            Word output = (Word)((Pair)entry.getValue()).getSecond();
            if (((Word)this.hypothesis.computeSuffixOutput((Iterable)prefix, (Iterable)input)).equals((Object)output)) continue;
            throw new IllegalArgumentException("Output of new ADS does not match hypothesis");
        }
        return true;
    }

    private ADTNode<ADTState<I, O>, I, O> verifyADS(ADTNode<ADTState<I, O>, I, O> nodeToReplace, ADTNode<ADTState<I, O>, I, O> replacement, Set<ADTNode<ADTState<I, O>, I, O>> cachedLeaves, Set<ADTState<I, O>> cutout) {
        Set<ADTNode<ADTState<I, O>, I, O>> leaves = ADTUtil.collectLeaves(replacement);
        LinkedHashMap<ADTState, Pair<Word<I>, Word<O>>> traces = new LinkedHashMap<ADTState, Pair<Word<I>, Word<O>>>(HashUtil.capacity((int)leaves.size()));
        for (ADTNode<ADTState<I, O>, I, O> leaf : leaves) {
            traces.put((ADTState)((Object)leaf.getState()), ADTUtil.buildTraceForNode(leaf));
        }
        Pair<Word<I>, Word<O>> parentTrace = ADTUtil.buildTraceForNode(nodeToReplace);
        ADTNode result = null;
        ArrayList queries = new ArrayList(traces.size());
        for (Map.Entry entry : traces.entrySet()) {
            ADTState state = (ADTState)((Object)entry.getKey());
            Pair ads = (Pair)entry.getValue();
            queries.add(new ADSVerificationQuery(state.getAccessSequence().concat(new Word[]{(Word)parentTrace.getFirst()}), (Word)ads.getFirst(), (Word)ads.getSecond(), state));
        }
        this.oracle.processQueries(queries);
        for (ADSVerificationQuery aDSVerificationQuery : queries) {
            ADTNode trace;
            DefaultQuery ce = aDSVerificationQuery.getCounterexample();
            if (ce != null) {
                this.openCounterExamples.add(ce);
                trace = ADTUtil.buildADSFromObservation(ce.getSuffix(), (Word)ce.getOutput(), aDSVerificationQuery.getState());
            } else {
                trace = ADTUtil.buildADSFromObservation(aDSVerificationQuery.getSuffix(), aDSVerificationQuery.getExpectedOutput(), aDSVerificationQuery.getState());
            }
            if (result == null) {
                result = trace;
                continue;
            }
            if (ADTUtil.mergeADS(result, trace)) continue;
            this.resolveAmbiguities(nodeToReplace, result, aDSVerificationQuery.getState(), cachedLeaves);
        }
        for (ADTState aDTState : cutout) {
            this.resolveAmbiguities(nodeToReplace, result, aDTState, cachedLeaves);
        }
        return result;
    }

    private void resolveAmbiguities(ADTNode<ADTState<I, O>, I, O> nodeToReplace, ADTNode<ADTState<I, O>, I, O> newADS, ADTState<I, O> state, Set<ADTNode<ADTState<I, O>, I, O>> cachedLeaves) {
        ADTNode newTrace;
        Pair<Word<I>, Word<O>> parentTrace = ADTUtil.buildTraceForNode(nodeToReplace);
        ADSAmbiguityQuery<I, O> query = new ADSAmbiguityQuery<I, O>(state.getAccessSequence(), (Word)parentTrace.getFirst(), newADS);
        this.oracle.processQuery(query);
        if (query.needsPostProcessing()) {
            ADTNode prev = query.getCurrentADTNode();
            ADTLeafNode newFinal = new ADTLeafNode(prev, state);
            prev.getChildren().put(query.getTempOut(), newFinal);
            return;
        }
        ADTNode finalNode = query.getCurrentADTNode();
        ADTNode<ADTState<I, O>, I, O> oldReference = null;
        ADTNode<ADTState<I, O>, I, O> newReference = null;
        for (ADTNode<ADTState<I, O>, I, O> leaf : cachedLeaves) {
            ADTState hypState = (ADTState)((Object)leaf.getState());
            if (((Object)((Object)hypState)).equals(finalNode.getState())) {
                oldReference = leaf;
            } else if (((Object)((Object)hypState)).equals(state)) {
                newReference = leaf;
            }
            if (oldReference == null || newReference == null) continue;
            break;
        }
        assert (oldReference != null && newReference != null);
        ADT.LCAInfo<ADTState<I, O>, I, O> lcaResult = this.adt.findLCA(oldReference, newReference);
        ADTNode lca = lcaResult.adtNode;
        Pair lcaTrace = ADTUtil.buildTraceForNode(lca);
        Word sepWord = ((Word)lcaTrace.getFirst()).append(lca.getSymbol());
        Word oldOutputTrace = ((Word)lcaTrace.getSecond()).append(lcaResult.firstOutput);
        Word newOutputTrace = ((Word)lcaTrace.getSecond()).append(lcaResult.secondOutput);
        ADTNode oldTrace = ADTUtil.buildADSFromObservation(sepWord, oldOutputTrace, (ADTState)((Object)finalNode.getState()));
        if (!ADTUtil.mergeADS(oldTrace, newTrace = ADTUtil.buildADSFromObservation(sepWord, newOutputTrace, state))) {
            throw new IllegalStateException("Should never happen");
        }
        ADTResetNode reset = new ADTResetNode(oldTrace);
        ADTNode parent = (ADTNode)finalNode.getParent();
        assert (parent != null);
        Object parentOutput = ADTUtil.getOutputForSuccessor(parent, finalNode);
        parent.getChildren().put(parentOutput, reset);
        reset.setParent(parent);
        oldTrace.setParent(reset);
    }

    private void resiftAffectedTransitions(Set<ADTNode<ADTState<I, O>, I, O>> states, ADTNode<ADTState<I, O>, I, O> finalizedADS) {
        for (ADTNode<ADTState<I, O>, I, O> state : states) {
            for (ADTTransition<I, O> trans : this.getIncomingNonSpanningTreeTransitions((ADTState)((Object)state.getState()))) {
                trans.setTarget(null);
                trans.setSiftNode(finalizedADS);
                this.openTransitions.add(trans);
            }
        }
    }

    private List<ADTTransition<I, O>> getIncomingNonSpanningTreeTransitions(ADTState<I, O> state) {
        Set<ADTTransition<I, O>> transitions = state.getIncomingTransitions();
        ArrayList<ADTTransition<I, O>> result = new ArrayList<ADTTransition<I, O>>(transitions.size());
        for (ADTTransition<I, O> t : transitions) {
            if (t.isSpanningTreeEdge()) continue;
            result.add(t);
        }
        return result;
    }

    public ADT<ADTState<I, O>, I, O> getADT() {
        return this.adt;
    }

    static final class BuilderDefaults {
        private BuilderDefaults() {
        }

        public static LeafSplitter leafSplitter() {
            return LeafSplitters.DEFAULT_SPLITTER;
        }

        public static ADTExtender adtExtender() {
            return ADTExtenders.EXTEND_BEST_EFFORT;
        }

        public static SubtreeReplacer subtreeReplacer() {
            return SubtreeReplacers.LEVELED_BEST_EFFORT;
        }

        public static boolean useObservationTree() {
            return true;
        }

        public static <I, D> LocalSuffixFinder<I, D> suffixFinder() {
            return LocalSuffixFinders.RIVEST_SCHAPIRE;
        }
    }
}

