/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.adt.learner;

import de.learnlib.algorithm.adt.adt.ADTNode;
import de.learnlib.algorithm.adt.automaton.ADTState;
import de.learnlib.algorithm.adt.automaton.ADTTransition;
import de.learnlib.algorithm.adt.learner.AbstractAdaptiveQuery;
import de.learnlib.algorithm.adt.util.ADTUtil;
import de.learnlib.query.AdaptiveQuery;
import net.automatalib.word.Word;

class ADTAdaptiveQuery<I, O>
extends AbstractAdaptiveQuery<I, O> {
    private final ADTTransition<I, O> transition;
    private final Word<I> accessSequence;
    private int asIndex;

    ADTAdaptiveQuery(ADTTransition<I, O> transition, ADTNode<ADTState<I, O>, I, O> root) {
        super(root);
        this.transition = transition;
        this.accessSequence = transition.getSource().getAccessSequence();
        this.asIndex = 0;
    }

    public I getInput() {
        if (this.asIndex <= this.accessSequence.length()) {
            if (this.asIndex == this.accessSequence.length()) {
                return this.transition.getInput();
            }
            return (I)this.accessSequence.getSymbol(this.asIndex);
        }
        return (I)this.currentADTNode.getSymbol();
    }

    @Override
    public AdaptiveQuery.Response processOutput(O out) {
        if (this.asIndex <= this.accessSequence.length()) {
            if (this.asIndex == this.accessSequence.length()) {
                this.transition.setOutput(out);
            }
            if (ADTUtil.isLeafNode(this.currentADTNode)) {
                return AdaptiveQuery.Response.FINISHED;
            }
            ++this.asIndex;
            return AdaptiveQuery.Response.SYMBOL;
        }
        return super.processOutput(out);
    }

    @Override
    protected void resetProgress() {
        this.asIndex = 0;
    }

    ADTTransition<I, O> getTransition() {
        return this.transition;
    }

    Word<I> getAccessSequence() {
        return this.accessSequence;
    }
}

