/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.adt.learner;

import de.learnlib.algorithm.adt.automaton.ADTState;
import de.learnlib.query.AdaptiveQuery;
import de.learnlib.query.DefaultQuery;
import java.util.Objects;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

class ADSVerificationQuery<I, O>
implements AdaptiveQuery<I, O> {
    private final Word<I> prefix;
    private final Word<I> suffix;
    private final Word<O> expectedOutput;
    private final WordBuilder<O> outputBuilder;
    private final ADTState<I, O> state;
    private final int prefixLength;
    private final int suffixLength;
    private int idx;
    private @Nullable DefaultQuery<I, Word<O>> counterexample;

    ADSVerificationQuery(Word<I> prefix, Word<I> suffix, Word<O> expectedSuffixOutput, ADTState<I, O> state) {
        this.prefix = prefix;
        this.suffix = suffix;
        this.expectedOutput = expectedSuffixOutput;
        this.outputBuilder = new WordBuilder(suffix.size());
        this.state = state;
        this.prefixLength = prefix.length();
        this.suffixLength = suffix.length();
        this.idx = 0;
    }

    public I getInput() {
        if (this.idx < this.prefixLength) {
            return (I)this.prefix.getSymbol(this.idx);
        }
        return (I)this.suffix.getSymbol(this.idx - this.prefixLength);
    }

    public AdaptiveQuery.Response processOutput(O out) {
        if (this.idx < this.prefixLength) {
            ++this.idx;
            return AdaptiveQuery.Response.SYMBOL;
        }
        this.outputBuilder.append(out);
        if (!Objects.equals(out, this.expectedOutput.getSymbol(this.idx - this.prefixLength))) {
            this.counterexample = new DefaultQuery(this.prefix, this.suffix.prefix(this.outputBuilder.size()), (Object)this.outputBuilder.toWord());
            return AdaptiveQuery.Response.FINISHED;
        }
        if (this.outputBuilder.size() < this.suffixLength) {
            ++this.idx;
            return AdaptiveQuery.Response.SYMBOL;
        }
        return AdaptiveQuery.Response.FINISHED;
    }

    @Nullable DefaultQuery<I, Word<O>> getCounterexample() {
        return this.counterexample;
    }

    ADTState<I, O> getState() {
        return this.state;
    }

    Word<I> getSuffix() {
        return this.suffix;
    }

    Word<O> getExpectedOutput() {
        return this.expectedOutput;
    }
}

