/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.adt.learner;

import de.learnlib.algorithm.adt.adt.ADTNode;
import de.learnlib.algorithm.adt.automaton.ADTState;
import de.learnlib.algorithm.adt.learner.AbstractAdaptiveQuery;
import de.learnlib.query.AdaptiveQuery;
import java.util.ArrayDeque;
import java.util.Deque;
import net.automatalib.word.Word;

class ADSAmbiguityQuery<I, O>
extends AbstractAdaptiveQuery<I, O> {
    private final Word<I> accessSequence;
    private final Deque<I> oneShotPrefix;
    private int asIndex;
    private boolean inOneShot;

    ADSAmbiguityQuery(Word<I> accessSequence, Word<I> oneShotPrefix, ADTNode<ADTState<I, O>, I, O> root) {
        super(root);
        this.accessSequence = accessSequence;
        this.oneShotPrefix = new ArrayDeque<I>(oneShotPrefix.asList());
        this.asIndex = 0;
        this.inOneShot = false;
    }

    public I getInput() {
        if (this.asIndex < this.accessSequence.length()) {
            return (I)this.accessSequence.getSymbol(this.asIndex);
        }
        boolean bl = this.inOneShot = !this.oneShotPrefix.isEmpty();
        if (this.inOneShot) {
            return this.oneShotPrefix.poll();
        }
        return (I)this.currentADTNode.getSymbol();
    }

    @Override
    public AdaptiveQuery.Response processOutput(O out) {
        if (this.asIndex < this.accessSequence.length()) {
            ++this.asIndex;
            return AdaptiveQuery.Response.SYMBOL;
        }
        if (this.inOneShot) {
            return AdaptiveQuery.Response.SYMBOL;
        }
        return super.processOutput(out);
    }

    @Override
    protected void resetProgress() {
        this.asIndex = 0;
    }
}

