/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.adt.config.model.replacer;

import de.learnlib.algorithm.adt.adt.ADT;
import de.learnlib.algorithm.adt.adt.ADTNode;
import de.learnlib.algorithm.adt.api.SubtreeReplacer;
import de.learnlib.algorithm.adt.config.model.ADSCalculator;
import de.learnlib.algorithm.adt.model.ReplacementResult;
import de.learnlib.algorithm.adt.util.ADTUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.common.smartcollection.ReflexiveMapView;
import net.automatalib.common.util.Pair;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SingleReplacer
implements SubtreeReplacer {
    private final ADSCalculator adsCalculator;

    public SingleReplacer(ADSCalculator adsProvider) {
        this.adsCalculator = adsProvider;
    }

    @Override
    public <S, I, O> Set<ReplacementResult<S, I, O>> computeReplacements(MealyMachine<S, I, ?, O> hypothesis, Alphabet<I> inputs, ADT<S, I, O> adt) {
        Set<ADTNode<S, I, O>> candidates = ADTUtil.collectADSNodes(adt.getRoot(), false);
        ArrayList<Pair> sortedCandidates = new ArrayList<Pair>(candidates.size());
        for (ADTNode<S, I, O> aDTNode : candidates) {
            int resets = 1 + ADTUtil.collectResetNodes(aDTNode).size();
            int leaves = ADTUtil.collectLeaves(aDTNode).size();
            sortedCandidates.add(Pair.of(aDTNode, (Object)((double)resets / (double)leaves)));
        }
        sortedCandidates.sort(Comparator.comparingDouble(Pair::getSecond));
        for (Pair pair : sortedCandidates) {
            Optional<ADTNode<S, I, O>> potentialADS;
            Set targetStates;
            ADTNode node = (ADTNode)pair.getFirst();
            ReplacementResult<S, I, O> replacementResult = SingleReplacer.computeParentExtension(hypothesis, inputs, node, targetStates = ADTUtil.collectHypothesisStates(node), this.adsCalculator);
            if (replacementResult != null) {
                return Collections.singleton(replacementResult);
            }
            if (ADTUtil.collectResetNodes(node).isEmpty() || !(potentialADS = this.adsCalculator.compute(hypothesis, inputs, targetStates)).isPresent()) continue;
            return Collections.singleton(new ReplacementResult<S, I, O>(node, potentialADS.get()));
        }
        return Collections.emptySet();
    }

    static <S, I, O> @Nullable ReplacementResult<S, I, O> computeParentExtension(MealyMachine<S, I, ?, O> hypothesis, Alphabet<I> inputs, ADTNode<S, I, O> node, Set<S> targetStates, ADSCalculator adsCalculator) {
        ADTNode parentReset = (ADTNode)node.getParent();
        assert (ADTUtil.isResetNode(parentReset)) : "should not happen";
        Word incomingTraceInput = (Word)ADTUtil.buildTraceForNode(parentReset).getFirst();
        Object currentToInitialMapping = new ReflexiveMapView(targetStates);
        for (Object i : incomingTraceInput) {
            HashMap nextMapping = new HashMap();
            for (Map.Entry entry : currentToInitialMapping.entrySet()) {
                Object successor = hypothesis.getSuccessor(entry.getKey(), i);
                if (nextMapping.containsKey(successor)) {
                    return null;
                }
                nextMapping.put(successor, entry.getValue());
            }
            currentToInitialMapping = nextMapping;
        }
        Optional<ADTNode<S, I, O>> potentialExtension = adsCalculator.compute(hypothesis, inputs, currentToInitialMapping.keySet());
        if (potentialExtension.isPresent()) {
            ADTNode<S, I, O> extension = potentialExtension.get();
            for (ADTNode<S, I, O> finalNode : ADTUtil.collectLeaves(extension)) {
                finalNode.setState(currentToInitialMapping.get(finalNode.getState()));
            }
            return new ReplacementResult<S, I, O>(parentReset, potentialExtension.get());
        }
        return null;
    }
}

