/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.adt.config.model.extender;

import de.learnlib.algorithm.adt.adt.ADTNode;
import de.learnlib.algorithm.adt.api.ADTExtender;
import de.learnlib.algorithm.adt.api.PartialTransitionAnalyzer;
import de.learnlib.algorithm.adt.automaton.ADTHypothesis;
import de.learnlib.algorithm.adt.automaton.ADTState;
import de.learnlib.algorithm.adt.config.model.DefensiveADSCalculator;
import de.learnlib.algorithm.adt.model.ExtensionResult;
import de.learnlib.algorithm.adt.util.ADTUtil;
import de.learnlib.query.DefaultQuery;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.automatalib.common.smartcollection.ReflexiveMapView;
import net.automatalib.common.util.Pair;
import net.automatalib.word.Word;

public class DefaultExtender
implements ADTExtender {
    private final DefensiveADSCalculator adsCalculator;

    public DefaultExtender(DefensiveADSCalculator adsCalculator) {
        this.adsCalculator = adsCalculator;
    }

    @Override
    public <I, O> ExtensionResult<ADTState<I, O>, I, O> computeExtension(ADTHypothesis<I, O> hypothesis, PartialTransitionAnalyzer<ADTState<I, O>, I> partialTransitionAnalyzer, ADTNode<ADTState<I, O>, I, O> ads) {
        ADTNode parent = (ADTNode)ads.getParent();
        if (parent == null) {
            return ExtensionResult.empty();
        }
        Set<ADTNode<ADTState<I, O>, I, O>> initialNodes = ADTUtil.collectLeaves(ads);
        if (initialNodes.size() > 2) {
            return ExtensionResult.empty();
        }
        Pair parentTrace = ADTUtil.buildTraceForNode(parent);
        while (true) {
            Word inputTrace = (Word)parentTrace.getFirst();
            Word outputTrace = (Word)parentTrace.getSecond();
            try {
                Object currentToInitialMapping = new ReflexiveMapView(ADTUtil.collectHypothesisStates(ads));
                for (int idx = 0; idx < inputTrace.length(); ++idx) {
                    LinkedHashMap<ADTState, ADTState> nextCurrentToInitialMapping = new LinkedHashMap<ADTState, ADTState>();
                    Object input = inputTrace.getSymbol(idx);
                    Object output = outputTrace.getSymbol(idx);
                    for (Map.Entry entry : currentToInitialMapping.entrySet()) {
                        ADTState s = (ADTState)((Object)entry.getKey());
                        if (!partialTransitionAnalyzer.isTransitionDefined(s, input)) {
                            partialTransitionAnalyzer.closeTransition(s, input);
                        }
                        if (!Objects.equals(hypothesis.getOutput((Object)s, input), output)) {
                            ADTState initial = (ADTState)((Object)entry.getValue());
                            Word as = initial.getAccessSequence();
                            Word asOut = (Word)hypothesis.computeOutput((Iterable)as);
                            Word traceIn = inputTrace.prefix(idx + 1);
                            Word traceOut = outputTrace.prefix(idx + 1);
                            DefaultQuery ce = new DefaultQuery(as.concat(new Word[]{traceIn}), (Object)asOut.concat(new Word[]{traceOut}));
                            return new ExtensionResult(ce);
                        }
                        ADTState successor = (ADTState)((Object)hypothesis.getSuccessor((Object)s, input));
                        if (nextCurrentToInitialMapping.containsKey((Object)successor)) {
                            return ExtensionResult.empty();
                        }
                        nextCurrentToInitialMapping.put(successor, (ADTState)((Object)currentToInitialMapping.get((Object)s)));
                    }
                    currentToInitialMapping = nextCurrentToInitialMapping;
                }
                Set currentSet = currentToInitialMapping.keySet();
                Optional potentialExtension = this.adsCalculator.compute(hypothesis, hypothesis.getInputAlphabet(), currentSet, partialTransitionAnalyzer);
                if (!potentialExtension.isPresent()) {
                    return ExtensionResult.empty();
                }
                ADTNode extension = potentialExtension.get();
                for (ADTNode finalNode : ADTUtil.collectLeaves(extension)) {
                    finalNode.setState((Object)((ADTState)((Object)currentToInitialMapping.get(finalNode.getState()))));
                }
                return new ExtensionResult(extension);
            }
            catch (PartialTransitionAnalyzer.HypothesisModificationException hypothesisModificationException) {
                continue;
            }
            break;
        }
    }
}

