/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.adt.adt;

import de.learnlib.algorithm.adt.adt.ADTLeafNode;
import de.learnlib.algorithm.adt.adt.ADTNode;
import de.learnlib.algorithm.adt.adt.ADTResetNode;
import de.learnlib.algorithm.adt.api.LeafSplitter;
import de.learnlib.algorithm.adt.config.LeafSplitters;
import de.learnlib.algorithm.adt.util.ADTUtil;
import java.util.HashMap;
import java.util.Set;
import net.automatalib.word.Word;

public class ADT<S, I, O> {
    private ADTNode<S, I, O> root;

    public void initialize(S state) {
        this.root = new ADTLeafNode(null, state);
    }

    public ADTNode<S, I, O> getRoot() {
        return this.root;
    }

    public void replaceNode(ADTNode<S, I, O> oldNode, ADTNode<S, I, O> newNode) {
        if (this.root.equals(oldNode)) {
            this.root = newNode;
        } else if (ADTUtil.isResetNode(oldNode)) {
            ADTNode endOfPreviousADS = (ADTNode)oldNode.getParent();
            assert (endOfPreviousADS != null);
            O outputToReset = ADTUtil.getOutputForSuccessor(endOfPreviousADS, oldNode);
            newNode.setParent(endOfPreviousADS);
            endOfPreviousADS.getChildren().put(outputToReset, newNode);
        } else {
            ADTNode oldNodeParent = (ADTNode)oldNode.getParent();
            assert (ADTUtil.isResetNode(oldNodeParent));
            ADTNode endOfPreviousADS = (ADTNode)oldNodeParent.getParent();
            assert (endOfPreviousADS != null);
            Object outputToReset = ADTUtil.getOutputForSuccessor(endOfPreviousADS, oldNodeParent);
            ADTResetNode<S, I, O> newResetNode = new ADTResetNode<S, I, O>(newNode);
            newResetNode.setParent(endOfPreviousADS);
            newNode.setParent(newResetNode);
            endOfPreviousADS.getChildren().put(outputToReset, newResetNode);
        }
    }

    public ADTNode<S, I, O> extendLeaf(ADTNode<S, I, O> nodeToSplit, Word<I> distinguishingSuffix, Word<O> oldOutput, Word<O> newOutput, LeafSplitter leafSplitter) {
        if (!ADTUtil.isLeafNode(nodeToSplit)) {
            throw new IllegalArgumentException("Node to split is not a leaf node");
        }
        if (distinguishingSuffix.length() != oldOutput.length() || oldOutput.length() != newOutput.length()) {
            throw new IllegalArgumentException("Distinguishing suffixes and outputs differ in length");
        }
        if (oldOutput.equals(newOutput)) {
            throw new IllegalArgumentException("Old and new output are equal");
        }
        if (this.root.equals(nodeToSplit)) {
            return this.splitLeaf(nodeToSplit, distinguishingSuffix, oldOutput, newOutput, leafSplitter);
        }
        return LeafSplitters.splitParent(nodeToSplit, distinguishingSuffix, oldOutput, newOutput);
    }

    public ADTNode<S, I, O> splitLeaf(ADTNode<S, I, O> nodeToSplit, Word<I> distinguishingSuffix, Word<O> oldOutput, Word<O> newOutput, LeafSplitter leafSplitter) {
        if (!ADTUtil.isLeafNode(nodeToSplit)) {
            throw new IllegalArgumentException("Node to split is not a final node");
        }
        if (distinguishingSuffix.length() != oldOutput.length() || oldOutput.length() != newOutput.length()) {
            throw new IllegalArgumentException("Distinguishing suffixes and outputs differ in length");
        }
        if (oldOutput.equals(newOutput)) {
            throw new IllegalArgumentException("Old and new output are equal");
        }
        boolean wasRoot = this.root.equals(nodeToSplit);
        ADTNode<S, I, O> result = leafSplitter.split(nodeToSplit, distinguishingSuffix, oldOutput, newOutput);
        if (wasRoot) {
            this.root = ADTUtil.getStartOfADS(nodeToSplit);
        }
        return result;
    }

    public LCAInfo<S, I, O> findLCA(ADTNode<S, I, O> s1, ADTNode<S, I, O> s2) {
        HashMap<ADTNode, ADTNode> s1ParentsToS1 = new HashMap<ADTNode, ADTNode>();
        ADTNode s1Iter = s1;
        for (ADTNode s1ParentIter = (ADTNode)s1.getParent(); s1ParentIter != null; s1ParentIter = (ADTNode)s1ParentIter.getParent()) {
            s1ParentsToS1.put(s1ParentIter, s1Iter);
            s1Iter = s1ParentIter;
        }
        Set s1Parents = s1ParentsToS1.keySet();
        ADTNode s2Iter = s2;
        for (ADTNode s2ParentIter = (ADTNode)s2.getParent(); s2ParentIter != null; s2ParentIter = (ADTNode)s2ParentIter.getParent()) {
            if (s1Parents.contains(s2ParentIter)) {
                if (!ADTUtil.isSymbolNode(s2ParentIter)) {
                    throw new IllegalStateException("Only Symbol Nodes should be LCAs");
                }
                ADTNode lca = s2ParentIter;
                Object s1Out = ADTUtil.getOutputForSuccessor(lca, (ADTNode)s1ParentsToS1.get(lca));
                Object s2Out = ADTUtil.getOutputForSuccessor(lca, s2Iter);
                return new LCAInfo(lca, s1Out, s2Out);
            }
            s2Iter = s2ParentIter;
        }
        throw new IllegalStateException("Nodes do not share a parent node");
    }

    public static class LCAInfo<S, I, O> {
        public final ADTNode<S, I, O> adtNode;
        public final O firstOutput;
        public final O secondOutput;

        LCAInfo(ADTNode<S, I, O> adtNode, O firstOutput, O secondOutput) {
            this.adtNode = adtNode;
            this.firstOutput = firstOutput;
            this.secondOutput = secondOutput;
        }
    }
}

