/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.adt.ads;

import de.learnlib.algorithm.adt.adt.ADTLeafNode;
import de.learnlib.algorithm.adt.adt.ADTNode;
import de.learnlib.algorithm.adt.api.PartialTransitionAnalyzer;
import de.learnlib.algorithm.adt.util.ADTUtil;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.concept.StateIDs;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.common.smartcollection.ReflexiveMapView;
import net.automatalib.common.util.HashUtil;
import net.automatalib.common.util.Pair;
import net.automatalib.util.automaton.ads.ADSUtil;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class DefensiveADS<S, I, O> {
    private final MealyMachine<S, I, ?, O> automaton;
    private final Alphabet<I> alphabet;
    private final Set<S> states;
    private final PartialTransitionAnalyzer<S, I> partialTransitionAnalyzer;
    private @Nullable Set<S> refinementStates;
    private @Nullable I refinementInput;

    private DefensiveADS(MealyMachine<S, I, ?, O> automaton, Alphabet<I> alphabet, Set<S> states, PartialTransitionAnalyzer<S, I> partialTransitionAnalyzer) {
        this.automaton = automaton;
        this.alphabet = alphabet;
        this.states = states;
        this.partialTransitionAnalyzer = partialTransitionAnalyzer;
    }

    public static <S, I, O> Optional<ADTNode<S, I, O>> compute(MealyMachine<S, I, ?, O> automaton, Alphabet<I> alphabet, Set<S> states, PartialTransitionAnalyzer<S, I> pta) {
        return super.compute();
    }

    private Optional<ADTNode<S, I, O>> compute() {
        ReflexiveMapView initialMapping = new ReflexiveMapView(this.states);
        Optional<ADTNode<S, I, O>> interMediateResult = this.compute((Map<S, S>)initialMapping);
        while (!interMediateResult.isPresent() && this.refinementStates != null && this.refinementInput != null) {
            for (S s : this.refinementStates) {
                this.partialTransitionAnalyzer.closeTransition(s, this.refinementInput);
            }
            this.refinementStates = null;
            this.refinementInput = null;
            interMediateResult = this.compute((Map<S, S>)initialMapping);
        }
        return interMediateResult;
    }

    private Optional<ADTNode<S, I, O>> compute(Map<S, S> mapping) {
        long maximumSplittingWordLength = ADSUtil.computeMaximumSplittingWordLength((int)this.automaton.size(), (int)mapping.size(), (int)this.states.size());
        ArrayDeque<Word> splittingWordCandidates = new ArrayDeque<Word>();
        StateIDs stateIds = this.automaton.stateIDs();
        HashSet<BitSet> cache = new HashSet<BitSet>();
        splittingWordCandidates.add(Word.epsilon());
        while (!splittingWordCandidates.isEmpty()) {
            @NonNull Word prefix = (Word)splittingWordCandidates.poll();
            LinkedHashMap<Object, S> currentToInitialMapping = new LinkedHashMap<Object, S>(HashUtil.capacity((int)mapping.size()));
            for (Map.Entry<S, S> e : mapping.entrySet()) {
                currentToInitialMapping.put(this.automaton.getSuccessor(e.getKey(), (Iterable)prefix), e.getValue());
            }
            BitSet currentSetAsBitSet = new BitSet();
            for (Object s : currentToInitialMapping.keySet()) {
                currentSetAsBitSet.set(stateIds.getStateId(s));
            }
            if (cache.contains(currentSetAsBitSet)) continue;
            block3: for (Object i : this.alphabet) {
                Object s2;
                LinkedHashSet<S> statesWithMissingTransitions = new LinkedHashSet<S>();
                for (Object s2 : currentToInitialMapping.keySet()) {
                    if (this.partialTransitionAnalyzer.isTransitionDefined(s2, i)) continue;
                    statesWithMissingTransitions.add(s2);
                }
                if (!statesWithMissingTransitions.isEmpty()) {
                    if (this.refinementStates != null && statesWithMissingTransitions.size() >= this.refinementStates.size()) continue;
                    this.refinementStates = statesWithMissingTransitions;
                    this.refinementInput = i;
                    continue;
                }
                HashMap successors = new HashMap();
                s2 = currentToInitialMapping.entrySet().iterator();
                while (s2.hasNext()) {
                    Object nextMapping;
                    Map.Entry entry = (Map.Entry)s2.next();
                    Object current = entry.getKey();
                    Object nextState = this.automaton.getSuccessor(current, i);
                    Object nextOutput = this.automaton.getOutput(current, i);
                    if (successors.containsKey(nextOutput)) {
                        nextMapping = (Map)successors.get(nextOutput);
                    } else {
                        nextMapping = new HashMap();
                        successors.put(nextOutput, nextMapping);
                    }
                    if (nextMapping.put(nextState, entry.getValue()) == null) continue;
                    continue block3;
                }
                if (successors.size() > 1) {
                    HashMap results = new HashMap();
                    for (Map.Entry entry : successors.entrySet()) {
                        Optional<ADTNode<S, I, O>> succ;
                        Map currentMapping = (Map)entry.getValue();
                        BitSet currentNodeAsBitSet = new BitSet();
                        for (Object s3 : currentMapping.keySet()) {
                            currentNodeAsBitSet.set(stateIds.getStateId(s3));
                        }
                        if (cache.contains(currentNodeAsBitSet)) continue block3;
                        if (currentMapping.size() > 1) {
                            succ = this.compute(currentMapping);
                        } else {
                            Object s3;
                            s3 = currentMapping.values().iterator().next();
                            succ = Optional.of(new ADTLeafNode(null, s3));
                        }
                        if (!succ.isPresent()) {
                            cache.add(currentNodeAsBitSet);
                            continue block3;
                        }
                        results.put(entry.getKey(), succ.get());
                    }
                    Pair<ADTNode<S, I, O>, ADTNode<S, I, O>> ads = ADTUtil.buildADSFromTrace(this.automaton, prefix.append(i), mapping.keySet().iterator().next());
                    ADTNode head = (ADTNode)ads.getFirst();
                    ADTNode tail = (ADTNode)ads.getSecond();
                    for (Map.Entry entry : results.entrySet()) {
                        ((ADTNode)entry.getValue()).setParent(tail);
                        tail.getChildren().put(entry.getKey(), (ADTNode)entry.getValue());
                    }
                    return Optional.of(head);
                }
                if ((long)prefix.length() >= maximumSplittingWordLength) continue;
                splittingWordCandidates.add(prefix.append(i));
            }
            cache.add(currentSetAsBitSet);
        }
        return Optional.empty();
    }
}

