/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.adt.config;

import de.learnlib.algorithms.adt.adt.ADTLeafNode;
import de.learnlib.algorithms.adt.adt.ADTNode;
import de.learnlib.algorithms.adt.adt.ADTResetNode;
import de.learnlib.algorithms.adt.adt.ADTSymbolNode;
import de.learnlib.algorithms.adt.api.LeafSplitter;
import de.learnlib.algorithms.adt.util.ADTUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.automatalib.commons.util.Pair;
import net.automatalib.words.Word;

public final class LeafSplitters {
    public static final LeafSplitter DEFAULT_SPLITTER = LeafSplitters::splitIntoNewADS;
    public static final LeafSplitter EXTEND_PARENT = new LeafSplitter(){

        @Override
        public <S, I, O> ADTNode<S, I, O> split(ADTNode<S, I, O> nodeToSplit, Word<I> distinguishingSuffix, Word<O> oldOutput, Word<O> newOutput) {
            if (LeafSplitters.canSplitParent(nodeToSplit, distinguishingSuffix, oldOutput, newOutput)) {
                return LeafSplitters.splitParent(nodeToSplit, distinguishingSuffix, oldOutput, newOutput);
            }
            return LeafSplitters.splitIntoNewADS(nodeToSplit, distinguishingSuffix, oldOutput, newOutput);
        }
    };

    private LeafSplitters() {
    }

    private static <S, I, O> boolean canSplitParent(ADTNode<S, I, O> nodeToSplit, Word<I> distinguishingSuffix, Word<O> hypothesisOutput, Word<O> newOutput) {
        if (nodeToSplit.getParent() == null) {
            return false;
        }
        Pair<Word<I>, Word<O>> trace = ADTUtil.buildTraceForNode(nodeToSplit);
        Word traceInput = (Word)trace.getFirst();
        Word traceOutput = (Word)trace.getSecond();
        return traceInput.isPrefixOf(distinguishingSuffix) && traceOutput.isPrefixOf(newOutput) && traceOutput.isPrefixOf(hypothesisOutput);
    }

    private static <S, I, O> ADTNode<S, I, O> splitIntoNewADS(ADTNode<S, I, O> nodeToSplit, Word<I> distinguishingSuffix, Word<O> oldOutput, Word<O> newOutput) {
        Iterator suffixIter = distinguishingSuffix.iterator();
        ADTNode parent = (ADTNode)nodeToSplit.getParent();
        ADTSymbolNode newADS = new ADTSymbolNode(null, suffixIter.next());
        if (parent != null) {
            boolean foundSuccessor = false;
            for (Map.Entry entry : parent.getChildren().entrySet()) {
                if (!((ADTNode)entry.getValue()).equals(nodeToSplit)) continue;
                ADTResetNode reset = new ADTResetNode(newADS);
                reset.setParent(parent);
                parent.getChildren().put(entry.getKey(), reset);
                newADS.setParent(reset);
                foundSuccessor = true;
                break;
            }
            if (!foundSuccessor) {
                throw new IllegalStateException();
            }
        }
        return LeafSplitters.finalizeSplit(nodeToSplit, newADS, suffixIter, oldOutput.iterator(), newOutput.iterator());
    }

    private static <S, I, O> ADTNode<S, I, O> finalizeSplit(ADTNode<S, I, O> nodeToSplit, ADTNode<S, I, O> adtRoot, Iterator<I> suffixIter, Iterator<O> oldIter, Iterator<O> newIter) {
        ADTNode<S, I, O> previous = adtRoot;
        O oldOut = oldIter.next();
        O newOut = newIter.next();
        while (Objects.equals(oldOut, newOut)) {
            ADTSymbolNode<S, I, O> next = new ADTSymbolNode<S, I, O>(previous, suffixIter.next());
            previous.getChildren().put(oldOut, next);
            oldOut = oldIter.next();
            newOut = newIter.next();
            previous = next;
        }
        ADTNode<S, I, O> oldFinalNode = nodeToSplit;
        ADTLeafNode<Object, I, O> newFinalNode = new ADTLeafNode<Object, I, O>(previous, null);
        oldFinalNode.setParent(previous);
        newFinalNode.setParent(previous);
        previous.getChildren().put(oldOut, oldFinalNode);
        previous.getChildren().put(newOut, newFinalNode);
        return newFinalNode;
    }

    public static <S, I, O> ADTNode<S, I, O> splitParent(ADTNode<S, I, O> nodeToSplit, Word<I> distinguishingSuffix, Word<O> oldOutput, Word<O> newOutput) {
        ADTNode previousADS = ADTUtil.getStartOfADS(nodeToSplit);
        Iterator suffixIter = distinguishingSuffix.iterator();
        Iterator oldIter = oldOutput.iterator();
        Iterator newIter = newOutput.iterator();
        ADTNode adsIter = previousADS;
        Object newSuffixOutput = null;
        while (!ADTUtil.isLeafNode(adsIter)) {
            suffixIter.next();
            newIter.next();
            newSuffixOutput = oldIter.next();
            adsIter = (ADTNode)adsIter.getChildren().get(newSuffixOutput);
        }
        ADTSymbolNode continuedADS = new ADTSymbolNode((ADTNode)adsIter.getParent(), suffixIter.next());
        ((ADTNode)adsIter.getParent()).getChildren().put(newSuffixOutput, continuedADS);
        return LeafSplitters.finalizeSplit(nodeToSplit, continuedADS, suffixIter, oldIter, newIter);
    }
}

