/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.adt.adt;

import de.learnlib.algorithms.adt.util.ADTUtil;
import de.learnlib.api.oracle.SymbolQueryOracle;
import java.util.Collection;
import java.util.Map;
import net.automatalib.graphs.ads.RecursiveADSNode;
import net.automatalib.visualization.VisualizationHelper;
import net.automatalib.words.Word;

public interface ADTNode<S, I, O>
extends RecursiveADSNode<S, I, O, ADTNode<S, I, O>> {
    public ADTNode<S, I, O> sift(SymbolQueryOracle<I, O> var1, Word<I> var2);

    default public Collection<ADTNode<S, I, O>> getNodes() {
        return this.getNodesForRoot(this);
    }

    default public VisualizationHelper<ADTNode<S, I, O>, ADTNode<S, I, O>> getVisualizationHelper() {
        return new VisualizationHelper<ADTNode<S, I, O>, ADTNode<S, I, O>>(){

            public boolean getNodeProperties(ADTNode<S, I, O> node, Map<String, String> properties) {
                if (ADTUtil.isResetNode(node)) {
                    properties.put("shape", "octagon");
                    properties.put("label", "reset");
                } else if (ADTUtil.isLeafNode(node)) {
                    properties.put("shape", "box");
                    properties.put("label", String.valueOf(node.getHypothesisState()));
                } else {
                    properties.put("label", node.toString());
                    properties.put("shape", "oval");
                }
                return true;
            }

            public boolean getEdgeProperties(ADTNode<S, I, O> src, ADTNode<S, I, O> edge, ADTNode<S, I, O> tgt, Map<String, String> properties) {
                for (Map.Entry e : src.getChildren().entrySet()) {
                    if (!((ADTNode)e.getValue()).equals(tgt) || ADTUtil.isResetNode(src)) continue;
                    properties.put("label", e.getKey().toString());
                    return true;
                }
                return true;
            }
        };
    }

    default public boolean isLeaf() {
        return NodeType.LEAF_NODE == this.getNodeType();
    }

    public NodeType getNodeType();

    public static enum NodeType {
        SYMBOL_NODE,
        RESET_NODE,
        LEAF_NODE;

    }
}

