/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.adt.adt;

import de.learnlib.algorithms.adt.adt.ADTLeafNode;
import de.learnlib.algorithms.adt.adt.ADTNode;
import de.learnlib.algorithms.adt.adt.ADTResetNode;
import de.learnlib.algorithms.adt.api.LeafSplitter;
import de.learnlib.algorithms.adt.config.LeafSplitters;
import de.learnlib.algorithms.adt.util.ADTUtil;
import de.learnlib.api.oracle.SymbolQueryOracle;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import net.automatalib.graphs.ads.RecursiveADSNode;
import net.automatalib.words.Word;

public class ADT<S, I, O>
implements Serializable {
    private ADTNode<S, I, O> root;
    private transient LeafSplitter leafSplitter;

    public ADT(LeafSplitter leafSplitter) {
        this.leafSplitter = leafSplitter;
    }

    public void initialize(S state) {
        this.root = new ADTLeafNode(null, state);
    }

    public ADTNode<S, I, O> getRoot() {
        return this.root;
    }

    public void replaceNode(ADTNode<S, I, O> oldNode, ADTNode<S, I, O> newNode) {
        if (this.root.equals(oldNode)) {
            this.root = newNode;
        } else if (ADTUtil.isResetNode(oldNode)) {
            ADTNode endOfPreviousADS = (ADTNode)oldNode.getParent();
            O outputToReset = ADTUtil.getOutputForSuccessor(endOfPreviousADS, oldNode);
            newNode.setParent(endOfPreviousADS);
            endOfPreviousADS.getChildren().put(outputToReset, newNode);
        } else {
            ADTNode oldNodeParent = (ADTNode)oldNode.getParent();
            assert (ADTUtil.isResetNode(oldNodeParent));
            ADTNode endOfPreviousADS = (ADTNode)oldNodeParent.getParent();
            Object outputToReset = ADTUtil.getOutputForSuccessor(endOfPreviousADS, oldNodeParent);
            ADTResetNode<S, I, O> newResetNode = new ADTResetNode<S, I, O>(newNode);
            newResetNode.setParent(endOfPreviousADS);
            newNode.setParent(newResetNode);
            endOfPreviousADS.getChildren().put(outputToReset, newResetNode);
        }
    }

    public ADTNode<S, I, O> sift(SymbolQueryOracle<I, O> oracle, Word<I> word, ADTNode<S, I, O> subtree) {
        ADTNode<S, I, O> current = subtree;
        while (!ADTUtil.isLeafNode(current)) {
            current = current.sift(oracle, word);
        }
        return current;
    }

    public ADTNode<S, I, O> extendLeaf(ADTNode<S, I, O> nodeToSplit, Word<I> distinguishingSuffix, Word<O> oldOutput, Word<O> newOutput) {
        if (!ADTUtil.isLeafNode(nodeToSplit)) {
            throw new IllegalArgumentException("Node to split is not a leaf node");
        }
        if (distinguishingSuffix.length() != oldOutput.length() || oldOutput.length() != newOutput.length()) {
            throw new IllegalArgumentException("Distinguishing suffixes and outputs differ in length");
        }
        if (oldOutput.equals(newOutput)) {
            throw new IllegalArgumentException("Old and new output are equal");
        }
        if (this.root.equals(nodeToSplit)) {
            return this.splitLeaf(nodeToSplit, distinguishingSuffix, oldOutput, newOutput);
        }
        return LeafSplitters.splitParent(nodeToSplit, distinguishingSuffix, oldOutput, newOutput);
    }

    public ADTNode<S, I, O> splitLeaf(ADTNode<S, I, O> nodeToSplit, Word<I> distinguishingSuffix, Word<O> oldOutput, Word<O> newOutput) {
        if (!ADTUtil.isLeafNode(nodeToSplit)) {
            throw new IllegalArgumentException("Node to split is not a final node");
        }
        if (distinguishingSuffix.length() != oldOutput.length() || oldOutput.length() != newOutput.length()) {
            throw new IllegalArgumentException("Distinguishing suffixes and outputs differ in length");
        }
        if (oldOutput.equals(newOutput)) {
            throw new IllegalArgumentException("Old and new output are equal");
        }
        boolean wasRoot = this.root.equals(nodeToSplit);
        ADTNode<S, I, O> result = this.leafSplitter.split(nodeToSplit, distinguishingSuffix, oldOutput, newOutput);
        if (wasRoot) {
            this.root = ADTUtil.getStartOfADS(nodeToSplit);
        }
        return result;
    }

    public LCAInfo<S, I, O> findLCA(ADTNode<S, I, O> s1, ADTNode<S, I, O> s2) {
        HashMap<RecursiveADSNode, ADTNode> s1ParentsToS1 = new HashMap<RecursiveADSNode, ADTNode>();
        ADTNode s1Iter = s1;
        ADTNode s2Iter = s2;
        while (s1Iter.getParent() != null) {
            s1ParentsToS1.put(s1Iter.getParent(), s1Iter);
            s1Iter = (ADTNode)s1Iter.getParent();
        }
        Set s1Parents = s1ParentsToS1.keySet();
        while (s2Iter.getParent() != null) {
            if (s1Parents.contains(s2Iter.getParent())) {
                if (!ADTUtil.isSymbolNode((ADTNode)s2Iter.getParent())) {
                    throw new IllegalStateException("Only Symbol Nodes should be LCAs");
                }
                ADTNode lca = (ADTNode)s2Iter.getParent();
                Object s1Out = ADTUtil.getOutputForSuccessor(lca, (ADTNode)s1ParentsToS1.get(lca));
                Object s2Out = ADTUtil.getOutputForSuccessor(lca, s2Iter);
                return new LCAInfo(lca, s1Out, s2Out);
            }
            s2Iter = (ADTNode)s2Iter.getParent();
        }
        throw new IllegalStateException("Nodes do not share a parent node");
    }

    public void setLeafSplitter(LeafSplitter leafSplitter) {
        this.leafSplitter = leafSplitter;
    }

    public static class LCAInfo<S, I, O> {
        public final ADTNode<S, I, O> adtNode;
        public final O firstOutput;
        public final O secondOutput;

        LCAInfo(ADTNode<S, I, O> adtNode, O firstOutput, O secondOutput) {
            this.adtNode = adtNode;
            this.firstOutput = firstOutput;
            this.secondOutput = secondOutput;
        }
    }
}

