/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.adt.util;

import de.learnlib.algorithms.adt.model.ObservationTree;
import de.learnlib.api.oracle.SymbolQueryOracle;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.automata.transducers.impl.FastMealy;
import net.automatalib.automata.transducers.impl.FastMealyState;

@ParametersAreNonnullByDefault
public class SQOOTBridge<I, O>
implements SymbolQueryOracle<I, O> {
    private final FastMealy<I, O> observationTree;
    private final SymbolQueryOracle<I, O> delegate;
    private final boolean enableCache;
    private final List<I> currentTrace;
    private FastMealyState<O> currentState;
    private boolean currentTraceValid;

    public SQOOTBridge(ObservationTree<?, I, O> observationTree, SymbolQueryOracle<I, O> delegate, boolean enableCache) {
        this.observationTree = observationTree.getObservationTree();
        this.delegate = delegate;
        this.enableCache = enableCache;
        this.currentTrace = enableCache ? new ArrayList() : null;
    }

    public void initialize() {
        this.currentState = (FastMealyState)this.observationTree.getInitialState();
        this.currentTraceValid = this.enableCache;
    }

    public O query(I i) {
        FastMealyState nextState;
        if (this.currentTraceValid) {
            FastMealyState succ = (FastMealyState)this.observationTree.getSuccessor(this.currentState, i);
            if (succ != null) {
                Object output = this.observationTree.getOutput(this.currentState, i);
                this.currentTrace.add(i);
                this.currentState = succ;
                return (O)output;
            }
            this.currentTraceValid = false;
            this.delegate.reset();
            for (I trace : this.currentTrace) {
                this.delegate.query(trace);
            }
        }
        Object output = this.delegate.query(i);
        FastMealyState succ = (FastMealyState)this.observationTree.getSuccessor(this.currentState, i);
        if (succ == null) {
            FastMealyState newState;
            nextState = newState = (FastMealyState)this.observationTree.addState();
            if (this.enableCache) {
                this.observationTree.addTransition(this.currentState, i, (Object)newState, output);
            }
        } else {
            assert (this.observationTree.getOutput(this.currentState, i).equals(output)) : "Inconsistent observations";
            nextState = succ;
        }
        this.currentState = nextState;
        return (O)output;
    }

    public void reset() {
        this.currentState = (FastMealyState)this.observationTree.getInitialState();
        if (this.enableCache) {
            this.currentTrace.clear();
            this.currentTraceValid = true;
        } else {
            this.delegate.reset();
        }
    }
}

