/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.adt.learner;

import de.learnlib.algorithms.adt.adt.ADT;
import de.learnlib.algorithms.adt.adt.ADTLeafNode;
import de.learnlib.algorithms.adt.adt.ADTNode;
import de.learnlib.algorithms.adt.adt.ADTResetNode;
import de.learnlib.algorithms.adt.api.ADTExtender;
import de.learnlib.algorithms.adt.api.LeafSplitter;
import de.learnlib.algorithms.adt.api.PartialTransitionAnalyzer;
import de.learnlib.algorithms.adt.api.SubtreeReplacer;
import de.learnlib.algorithms.adt.automaton.ADTHypothesis;
import de.learnlib.algorithms.adt.automaton.ADTState;
import de.learnlib.algorithms.adt.automaton.ADTTransition;
import de.learnlib.algorithms.adt.config.ADTExtenders;
import de.learnlib.algorithms.adt.config.LeafSplitters;
import de.learnlib.algorithms.adt.config.SubtreeReplacers;
import de.learnlib.algorithms.adt.learner.ADTLearnerState;
import de.learnlib.algorithms.adt.model.ExtensionResult;
import de.learnlib.algorithms.adt.model.ObservationTree;
import de.learnlib.algorithms.adt.model.ReplacementResult;
import de.learnlib.algorithms.adt.util.ADTUtil;
import de.learnlib.algorithms.adt.util.SQOOTBridge;
import de.learnlib.api.Resumable;
import de.learnlib.api.algorithm.LearningAlgorithm;
import de.learnlib.api.oracle.SymbolQueryOracle;
import de.learnlib.api.query.DefaultQuery;
import de.learnlib.counterexamples.LocalSuffixFinders;
import de.learnlib.util.MQUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.SupportsGrowingAlphabet;
import net.automatalib.automata.transducers.MealyMachine;
import net.automatalib.commons.util.Pair;
import net.automatalib.exception.GrowingAlphabetNotSupportedException;
import net.automatalib.graphs.ads.RecursiveADSNode;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;
import net.automatalib.words.impl.Alphabets;

@ParametersAreNonnullByDefault
public class ADTLearner<I, O>
implements LearningAlgorithm.MealyLearner<I, O>,
PartialTransitionAnalyzer<ADTState<I, O>, I>,
SupportsGrowingAlphabet<I>,
Resumable<ADTLearnerState<ADTState<I, O>, I, O>> {
    private final Alphabet<I> alphabet;
    private final SQOOTBridge<I, O> oracle;
    private final LeafSplitter leafSplitter;
    private final ADTExtender adtExtender;
    private final SubtreeReplacer subtreeReplacer;
    private final Queue<ADTTransition<I, O>> openTransitions;
    private final Queue<DefaultQuery<I, Word<O>>> openCounterExamples;
    private final Set<DefaultQuery<I, Word<O>>> allCounterExamples;
    private final ObservationTree<ADTState<I, O>, I, O> observationTree;
    private ADTHypothesis<I, O> hypothesis;
    private ADT<ADTState<I, O>, I, O> adt;

    public ADTLearner(Alphabet<I> alphabet, SymbolQueryOracle<I, O> oracle, LeafSplitter leafSplitter, ADTExtender adtExtender, SubtreeReplacer subtreeReplacer) {
        this(alphabet, oracle, leafSplitter, adtExtender, subtreeReplacer, true);
    }

    public ADTLearner(Alphabet<I> alphabet, SymbolQueryOracle<I, O> oracle, LeafSplitter leafSplitter, ADTExtender adtExtender, SubtreeReplacer subtreeReplacer, boolean useObservationTree) {
        this.alphabet = alphabet;
        this.observationTree = new ObservationTree(this.alphabet);
        this.oracle = new SQOOTBridge<I, O>(this.observationTree, oracle, useObservationTree);
        this.leafSplitter = leafSplitter;
        this.adtExtender = adtExtender;
        this.subtreeReplacer = subtreeReplacer;
        this.hypothesis = new ADTHypothesis(this.alphabet);
        this.openTransitions = new ArrayDeque<ADTTransition<I, O>>();
        this.openCounterExamples = new ArrayDeque<DefaultQuery<I, Word<O>>>();
        this.allCounterExamples = new LinkedHashSet<DefaultQuery<I, Word<O>>>();
        this.adt = new ADT(leafSplitter);
    }

    public void startLearning() {
        ADTState initialState = (ADTState)((Object)this.hypothesis.addInitialState());
        initialState.setAccessSequence(Word.epsilon());
        this.observationTree.initialize(initialState);
        this.oracle.initialize();
        this.adt.initialize(initialState);
        for (Object i : this.alphabet) {
            this.openTransitions.add(this.hypothesis.createOpenTransition(initialState, i, this.adt.getRoot()));
        }
        this.closeTransitions();
    }

    public boolean refineHypothesis(DefaultQuery<I, Word<O>> ce) {
        if (!MQUtil.isCounterexample(ce, this.hypothesis)) {
            return false;
        }
        this.evaluateSubtreeReplacement();
        this.openCounterExamples.add(ce);
        while (!this.openCounterExamples.isEmpty()) {
            while (!this.openCounterExamples.isEmpty()) {
                DefaultQuery<I, Word<O>> currentCE = this.openCounterExamples.poll();
                this.allCounterExamples.add(currentCE);
                while (this.refineHypothesisInternal(currentCE)) {
                }
            }
            for (DefaultQuery<I, Word<O>> oldCE : this.allCounterExamples) {
                if (((Word)this.hypothesis.computeOutput((Iterable)oldCE.getInput())).equals(oldCE.getOutput())) continue;
                this.openCounterExamples.add(oldCE);
            }
            ADTUtil.collectLeaves(this.adt.getRoot()).forEach(this::ensureConsistency);
        }
        return true;
    }

    public boolean refineHypothesisInternal(DefaultQuery<I, Word<O>> ceQuery) {
        ADTNode<ADTState<I, O>, I, O> newNode;
        if (!MQUtil.isCounterexample(ceQuery, this.hypothesis)) {
            return false;
        }
        int suffixIdx = LocalSuffixFinders.RIVEST_SCHAPIRE.findSuffixIndex(ceQuery, this.hypothesis, this.hypothesis, this.oracle);
        if (suffixIdx == -1) {
            throw new IllegalStateException();
        }
        Word ceInput = ceQuery.getInput();
        Word u = ceInput.prefix(suffixIdx - 1);
        Word ua = ceInput.prefix(suffixIdx);
        Object a = ceInput.getSymbol(suffixIdx - 1);
        Word v = ceInput.subWord(suffixIdx);
        ADTState uState = (ADTState)((Object)this.hypothesis.getState((Iterable)u));
        ADTState uaState = (ADTState)((Object)this.hypothesis.getState((Iterable)ua));
        Word uAccessSequence = uState.getAccessSequence();
        Word uaAccessSequence = uaState.getAccessSequence();
        Word uAccessSequenceWithA = uAccessSequence.append(a);
        ADTState newState = (ADTState)((Object)this.hypothesis.addState());
        newState.setAccessSequence(uAccessSequenceWithA);
        ADTTransition oldTrans = (ADTTransition)this.hypothesis.getTransition(uState, a);
        oldTrans.setTarget(newState);
        oldTrans.setIsSpanningTreeEdge(true);
        Set<ADTNode<ADTState<I, O>, I, O>> finalNodes = ADTUtil.collectLeaves(this.adt.getRoot());
        ADTNode nodeToSplit = finalNodes.stream().filter(n -> ((Object)((Object)((ADTState)((Object)((Object)n.getHypothesisState()))))).equals((Object)uaState)).findFirst().orElseThrow(IllegalStateException::new);
        this.observationTree.addState(newState, newState.getAccessSequence(), oldTrans.getOutput());
        this.observationTree.addTrace(newState, nodeToSplit);
        Word previousTrace = (Word)ADTUtil.buildTraceForNode(nodeToSplit).getFirst();
        Optional<Word<I>> extension = this.observationTree.findSeparatingWord(uaState, newState, previousTrace);
        if (extension.isPresent()) {
            Word completeSplitter = previousTrace.concat(new Word[]{extension.get()});
            Word<O> oldOutput = this.observationTree.trace(uaState, completeSplitter);
            Word<O> newOutput = this.observationTree.trace(newState, completeSplitter);
            newNode = this.adt.extendLeaf(nodeToSplit, completeSplitter, oldOutput, newOutput);
        } else {
            this.observationTree.addTrace(uaState, v, (Word)this.oracle.answerQuery(uaAccessSequence, v));
            this.observationTree.addTrace(newState, v, (Word)this.oracle.answerQuery(uAccessSequenceWithA, v));
            Word otSepWord = this.observationTree.findSeparatingWord(uaState, newState);
            Word splitter = otSepWord.length() < v.length() ? otSepWord : v;
            Word<O> oldOutput = this.observationTree.trace(uaState, splitter);
            Word<O> newOutput = this.observationTree.trace(newState, splitter);
            newNode = this.adt.splitLeaf(nodeToSplit, splitter, oldOutput, newOutput);
        }
        newNode.setHypothesisState((Object)newState);
        ADTNode temporarySplitter = ADTUtil.getStartOfADS(nodeToSplit);
        List newTransitions = this.alphabet.stream().map(i -> this.hypothesis.createOpenTransition(newState, i, this.adt.getRoot())).collect(Collectors.toList());
        List<ADTTransition> transitionsToRefine = ((ADTState)((Object)nodeToSplit.getHypothesisState())).getIncomingTransitions().stream().filter(x -> !x.isSpanningTreeEdge()).collect(Collectors.toList());
        transitionsToRefine.forEach(x -> {
            x.setTarget(null);
            x.setSiftNode(temporarySplitter);
        });
        ADTNode finalizedSplitter = this.evaluateAdtExtension(temporarySplitter);
        transitionsToRefine.stream().filter(ADTTransition::needsSifting).forEach(x -> {
            x.setSiftNode(finalizedSplitter);
            this.openTransitions.add((ADTTransition<I, O>)x);
        });
        newTransitions.stream().filter(ADTTransition::needsSifting).forEach(this.openTransitions::add);
        this.closeTransitions();
        return true;
    }

    @Nonnull
    public MealyMachine<?, I, ?, O> getHypothesisModel() {
        return this.hypothesis;
    }

    private void closeTransitions() {
        while (!this.openTransitions.isEmpty()) {
            this.closeTransition(this.openTransitions.poll());
        }
    }

    private void closeTransition(ADTTransition<I, O> transition) {
        ADTState targetState;
        if (!transition.needsSifting()) {
            return;
        }
        Word<I> accessSequence = transition.getSource().getAccessSequence();
        I symbol = transition.getInput();
        this.oracle.reset();
        for (Object i : accessSequence) {
            this.oracle.query(i);
        }
        transition.setOutput(this.oracle.query(symbol));
        Word longPrefix = accessSequence.append(symbol);
        ADTNode<ADTState<I, O>, I, O> finalNode = this.adt.sift(this.oracle, longPrefix, transition.getSiftNode());
        assert (ADTUtil.isLeafNode(finalNode));
        if (finalNode.getHypothesisState() == null) {
            targetState = (ADTState)((Object)this.hypothesis.addState());
            targetState.setAccessSequence(longPrefix);
            finalNode.setHypothesisState((Object)targetState);
            transition.setIsSpanningTreeEdge(true);
            this.observationTree.addState(targetState, longPrefix, transition.getOutput());
            for (Object i : this.alphabet) {
                this.openTransitions.add(this.hypothesis.createOpenTransition(targetState, i, this.adt.getRoot()));
            }
        } else {
            targetState = (ADTState)((Object)finalNode.getHypothesisState());
        }
        transition.setTarget(targetState);
    }

    @Override
    public void closeTransition(ADTState<I, O> state, I input) throws PartialTransitionAnalyzer.HypothesisModificationException {
        ADTTransition transition = (ADTTransition)this.hypothesis.getTransition(state, input);
        if (transition.needsSifting()) {
            ADTNode ads = transition.getSiftNode();
            int oldNumberOfFinalStates = ADTUtil.collectLeaves(ads).size();
            this.closeTransition(transition);
            int newNumberOfFinalStates = ADTUtil.collectLeaves(ads).size();
            if (oldNumberOfFinalStates < newNumberOfFinalStates) {
                throw PartialTransitionAnalyzer.HYPOTHESIS_MODIFICATION_EXCEPTION;
            }
        }
    }

    @Override
    public boolean isTransitionDefined(ADTState<I, O> state, I input) {
        return !((ADTTransition)this.hypothesis.getTransition(state, input)).needsSifting();
    }

    public void addAlphabetSymbol(I symbol) throws GrowingAlphabetNotSupportedException {
        if (!this.alphabet.containsSymbol(symbol)) {
            Alphabets.toGrowingAlphabetOrThrowException(this.alphabet).addSymbol(symbol);
        }
        this.hypothesis.addAlphabetSymbol(symbol);
        this.observationTree.getObservationTree().addAlphabetSymbol(symbol);
        if (this.hypothesis.getInitialState() != null && this.hypothesis.getSuccessor(this.hypothesis.getInitialState(), symbol) == null) {
            for (ADTState s : this.hypothesis.getStates()) {
                this.openTransitions.add(this.hypothesis.createOpenTransition(s, symbol, this.adt.getRoot()));
            }
            this.closeTransitions();
        }
    }

    public ADTLearnerState<ADTState<I, O>, I, O> suspend() {
        return new ADTLearnerState<ADTState<I, O>, I, O>(this.hypothesis, this.adt);
    }

    public void resume(ADTLearnerState<ADTState<I, O>, I, O> state) {
        this.hypothesis = state.getHypothesis();
        this.adt = state.getAdt();
        this.adt.setLeafSplitter(this.leafSplitter);
        if (this.hypothesis.size() > 0) {
            this.observationTree.initialize(this.hypothesis.getStates(), ADTState::getAccessSequence, arg_0 -> this.hypothesis.computeOutput(arg_0));
            this.oracle.initialize();
        }
    }

    private void ensureConsistency(ADTNode<ADTState<I, O>, I, O> leaf) {
        ADTState state = (ADTState)((Object)leaf.getHypothesisState());
        Word as = state.getAccessSequence();
        Word asOut = (Word)this.hypothesis.computeOutput((Iterable)as);
        ADTNode iter = leaf;
        while (iter != null) {
            Pair<Word<I>, Word<O>> trace = ADTUtil.buildTraceForNode(iter);
            Word input = (Word)trace.getFirst();
            Word output = (Word)trace.getSecond();
            Word hypOut = this.hypothesis.computeStateOutput((Object)state, (Iterable)input);
            if (!hypOut.equals((Object)output)) {
                this.openCounterExamples.add(new DefaultQuery(as.concat(new Word[]{input}), (Object)asOut.concat(new Word[]{output})));
            }
            iter = (ADTNode)ADTUtil.getStartOfADS(iter).getParent();
        }
    }

    private ADTNode<ADTState<I, O>, I, O> evaluateAdtExtension(ADTNode<ADTState<I, O>, I, O> ads) {
        ExtensionResult<ADTState<I, O>, I, O> potentialExtension = this.adtExtender.computeExtension(this.hypothesis, this, ads);
        if (potentialExtension.isCounterExample()) {
            this.openCounterExamples.add(potentialExtension.getCounterExample());
            return ads;
        }
        if (!potentialExtension.isReplacement()) {
            return ads;
        }
        ADTNode<ADTState<I, O>, I, O> extension = potentialExtension.getReplacement();
        ADTNode nodeToReplace = (ADTNode)ads.getParent();
        assert (this.validateADS(nodeToReplace, extension, Collections.emptySet()));
        ADTNode<ADTState<I, O>, I, O> replacement = this.verifyADS(nodeToReplace, extension, ADTUtil.collectLeaves(this.adt.getRoot()), Collections.emptySet());
        int oldCosts = ADTUtil.computeEffectiveResets(nodeToReplace);
        int newCosts = ADTUtil.computeEffectiveResets(replacement);
        if (newCosts >= oldCosts) {
            return ads;
        }
        this.adt.replaceNode(nodeToReplace, replacement);
        ADTNode<ADTState<I, O>, I, O> finalizedADS = ADTUtil.getStartOfADS(replacement);
        this.resiftAffectedTransitions(ADTUtil.collectLeaves(extension), finalizedADS);
        return finalizedADS;
    }

    private void evaluateSubtreeReplacement() {
        ADTNode<ADTState<I, O>, I, O> nodeToReplace;
        if (this.hypothesis.size() == 1) {
            return;
        }
        Set<ReplacementResult<ADTState<I, O>, I, O>> potentialReplacements = this.subtreeReplacer.computeReplacements(this.hypothesis, this.alphabet, this.adt);
        ArrayList<ReplacementResult<ADTState<I, O>, I, O>> validReplacements = new ArrayList<ReplacementResult<ADTState<I, O>, I, O>>(potentialReplacements.size());
        Set<ADTNode<ADTState<I, O>, I, O>> cachedLeaves = potentialReplacements.isEmpty() ? Collections.emptySet() : ADTUtil.collectLeaves(this.adt.getRoot());
        for (ReplacementResult<ADTState<I, O>, I, O> potentialReplacement : potentialReplacements) {
            ADTNode<ADTState<I, O>, I, O> proposedReplacement = potentialReplacement.getReplacement();
            nodeToReplace = potentialReplacement.getNodeToReplace();
            assert (this.validateADS(nodeToReplace, proposedReplacement, potentialReplacement.getCutoutNodes()));
            ADTNode<ADTState<I, O>, I, O> replacement = this.verifyADS(nodeToReplace, proposedReplacement, cachedLeaves, potentialReplacement.getCutoutNodes());
            int oldCosts = ADTUtil.computeEffectiveResets(nodeToReplace);
            int newCosts = ADTUtil.computeEffectiveResets(replacement);
            if (newCosts >= oldCosts) continue;
            validReplacements.add(new ReplacementResult<ADTState<I, O>, I, O>(nodeToReplace, replacement));
        }
        for (ReplacementResult<ADTState<I, O>, I, O> potentialReplacement : validReplacements) {
            ADTNode<ADTState<I, O>, I, O> replacement = potentialReplacement.getReplacement();
            nodeToReplace = potentialReplacement.getNodeToReplace();
            this.adt.replaceNode(nodeToReplace, replacement);
            this.resiftAffectedTransitions(ADTUtil.collectLeaves(replacement), ADTUtil.getStartOfADS(replacement));
        }
        this.closeTransitions();
    }

    private boolean validateADS(ADTNode<ADTState<I, O>, I, O> oldADS, ADTNode<ADTState<I, O>, I, O> newADS, Set<ADTState<I, O>> cutout) {
        Set<ADTNode<ADTState<I, O>, I, O>> oldNodes = ADTUtil.isResetNode(oldADS) ? ADTUtil.collectResetNodes(this.adt.getRoot()) : ADTUtil.collectADSNodes(this.adt.getRoot());
        if (!oldNodes.contains(oldADS)) {
            throw new IllegalArgumentException("Subtree to replace does not exist");
        }
        Set<ADTNode<ADTState<I, O>, I, O>> oldFinalNodes = ADTUtil.collectLeaves(oldADS);
        Set<ADTNode<ADTState<I, O>, I, O>> newFinalNodes = ADTUtil.collectLeaves(newADS);
        Set oldFinalStates = oldFinalNodes.stream().map(RecursiveADSNode::getHypothesisState).collect(Collectors.toSet());
        Set newFinalStates = newFinalNodes.stream().map(RecursiveADSNode::getHypothesisState).collect(Collectors.toSet());
        newFinalStates.addAll(cutout);
        if (!oldFinalStates.equals(newFinalStates)) {
            throw new IllegalArgumentException("New ADS does not cover all old nodes");
        }
        Word parentInputTrace = (Word)ADTUtil.buildTraceForNode(oldADS).getFirst();
        Map<ADTState, Pair> traces = newFinalNodes.stream().collect(Collectors.toMap(RecursiveADSNode::getHypothesisState, ADTUtil::buildTraceForNode));
        for (Map.Entry<ADTState, Pair> entry : traces.entrySet()) {
            Word accessSequence = entry.getKey().getAccessSequence();
            Word prefix = accessSequence.concat(new Word[]{parentInputTrace});
            Word input = (Word)entry.getValue().getFirst();
            Word output = (Word)entry.getValue().getSecond();
            if (((Word)this.hypothesis.computeSuffixOutput((Iterable)prefix, (Iterable)input)).equals((Object)output)) continue;
            throw new IllegalArgumentException("Output of new ADS does not match hypothesis");
        }
        return true;
    }

    private ADTNode<ADTState<I, O>, I, O> verifyADS(ADTNode<ADTState<I, O>, I, O> nodeToReplace, ADTNode<ADTState<I, O>, I, O> replacement, Set<ADTNode<ADTState<I, O>, I, O>> cachedLeaves, Set<ADTState<I, O>> cutout) {
        LinkedHashMap traces = new LinkedHashMap();
        ADTUtil.collectLeaves(replacement).forEach(x -> traces.put(x.getHypothesisState(), ADTUtil.buildTraceForNode(x)));
        Pair<Word<I>, Word<O>> parentTrace = ADTUtil.buildTraceForNode(nodeToReplace);
        Word parentInput = (Word)parentTrace.getFirst();
        Word parentOutput = (Word)parentTrace.getSecond();
        ADTNode result = null;
        for (Map.Entry entry : traces.entrySet()) {
            ADTState state = (ADTState)((Object)entry.getKey());
            Word accessSequence = state.getAccessSequence();
            this.oracle.reset();
            accessSequence.forEach(this.oracle::query);
            parentInput.forEach(this.oracle::query);
            Word adsInput = (Word)((Pair)entry.getValue()).getFirst();
            Word adsOutput = (Word)((Pair)entry.getValue()).getSecond();
            WordBuilder inputWb = new WordBuilder(adsInput.size());
            WordBuilder outputWb = new WordBuilder(adsInput.size());
            Iterator inputIter = adsInput.iterator();
            Iterator outputIter = adsOutput.iterator();
            boolean equal = true;
            while (equal && inputIter.hasNext()) {
                Object in = inputIter.next();
                O realOut = this.oracle.query(in);
                Object expectedOut = outputIter.next();
                inputWb.append(in);
                outputWb.append(realOut);
                if (expectedOut.equals(realOut)) continue;
                equal = false;
            }
            Word traceInput = inputWb.toWord();
            Word traceOutput = outputWb.toWord();
            if (!equal) {
                this.openCounterExamples.add(new DefaultQuery(accessSequence.concat(new Word[]{parentInput, traceInput}), (Object)((Word)this.hypothesis.computeOutput((Iterable)state.getAccessSequence())).concat(new Word[]{parentOutput, traceOutput})));
            }
            ADTNode trace = ADTUtil.buildADSFromObservation(traceInput, traceOutput, state);
            if (result == null) {
                result = trace;
                continue;
            }
            if (ADTUtil.mergeADS(result, trace)) continue;
            this.resolveAmbiguities(nodeToReplace, result, state, cachedLeaves);
        }
        for (ADTState aDTState : cutout) {
            this.resolveAmbiguities(nodeToReplace, result, aDTState, cachedLeaves);
        }
        return result;
    }

    private void resolveAmbiguities(ADTNode<ADTState<I, O>, I, O> nodeToReplace, ADTNode<ADTState<I, O>, I, O> newADS, ADTState<I, O> state, Set<ADTNode<ADTState<I, O>, I, O>> cachedLeaves) {
        ADTNode newTrace;
        Pair<Word<I>, Word<O>> parentTrace = ADTUtil.buildTraceForNode(nodeToReplace);
        Word parentInput = (Word)parentTrace.getFirst();
        Word effectiveAccessSequence = state.getAccessSequence().concat(new Word[]{parentInput});
        this.oracle.reset();
        effectiveAccessSequence.forEach(this.oracle::query);
        ADTNode iter = newADS;
        while (!ADTUtil.isLeafNode(iter)) {
            if (ADTUtil.isResetNode(iter)) {
                this.oracle.reset();
                state.getAccessSequence().forEach(this.oracle::query);
                iter = (ADTNode)iter.getChildren().values().iterator().next();
                continue;
            }
            O output = this.oracle.query(iter.getSymbol());
            ADTNode succ = (ADTNode)iter.getChildren().get(output);
            if (succ == null) {
                ADTLeafNode newFinal = new ADTLeafNode(iter, state);
                iter.getChildren().put(output, newFinal);
                return;
            }
            iter = succ;
        }
        ADTNode<ADTState<I, O>, I, O> oldReference = null;
        ADTNode<ADTState<I, O>, I, O> newReference = null;
        for (ADTNode<ADTState<I, O>, I, O> leaf : cachedLeaves) {
            ADTState hypState = (ADTState)((Object)leaf.getHypothesisState());
            if (((Object)((Object)hypState)).equals(iter.getHypothesisState())) {
                oldReference = leaf;
            } else if (((Object)((Object)hypState)).equals(state)) {
                newReference = leaf;
            }
            if (oldReference == null || newReference == null) continue;
            break;
        }
        ADT.LCAInfo<ADTState<I, O>, I, O> lcaResult = this.adt.findLCA(oldReference, newReference);
        ADTNode lca = lcaResult.adtNode;
        Pair lcaTrace = ADTUtil.buildTraceForNode(lca);
        Word sepWord = ((Word)lcaTrace.getFirst()).append(lca.getSymbol());
        Word oldOutputTrace = ((Word)lcaTrace.getSecond()).append(lcaResult.firstOutput);
        Word newOutputTrace = ((Word)lcaTrace.getSecond()).append(lcaResult.secondOutput);
        ADTNode oldTrace = ADTUtil.buildADSFromObservation(sepWord, oldOutputTrace, iter.getHypothesisState());
        if (!ADTUtil.mergeADS(oldTrace, newTrace = ADTUtil.buildADSFromObservation(sepWord, newOutputTrace, state))) {
            throw new IllegalStateException("Should never happen");
        }
        ADTResetNode reset = new ADTResetNode(oldTrace);
        Object parentOutput = ADTUtil.getOutputForSuccessor((ADTNode)iter.getParent(), iter);
        ((ADTNode)iter.getParent()).getChildren().put(parentOutput, reset);
        reset.setParent(iter.getParent());
        oldTrace.setParent(reset);
    }

    private void resiftAffectedTransitions(Set<ADTNode<ADTState<I, O>, I, O>> states, ADTNode<ADTState<I, O>, I, O> finalizedADS) {
        for (ADTNode<ADTState<I, O>, I, O> state : states) {
            List transitionsToRefine = ((ADTState)((Object)state.getHypothesisState())).getIncomingTransitions().stream().filter(x -> !x.isSpanningTreeEdge()).collect(Collectors.toList());
            for (ADTTransition trans : transitionsToRefine) {
                trans.setTarget(null);
                trans.setSiftNode(finalizedADS);
                this.openTransitions.add(trans);
            }
        }
    }

    public static final class BuilderDefaults {
        private BuilderDefaults() {
        }

        public static LeafSplitter leafSplitter() {
            return LeafSplitters.DEFAULT_SPLITTER;
        }

        public static ADTExtender adtExtender() {
            return ADTExtenders.EXTEND_BEST_EFFORT;
        }

        public static SubtreeReplacer subtreeReplacer() {
            return SubtreeReplacers.LEVELED_BEST_EFFORT;
        }

        public static boolean useObservationTree() {
            return true;
        }
    }
}

