/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.adt.config.model.replacer;

import de.learnlib.algorithms.adt.adt.ADT;
import de.learnlib.algorithms.adt.adt.ADTNode;
import de.learnlib.algorithms.adt.api.SubtreeReplacer;
import de.learnlib.algorithms.adt.config.model.ADSCalculator;
import de.learnlib.algorithms.adt.model.ReplacementResult;
import de.learnlib.algorithms.adt.util.ADTUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.automata.transducers.MealyMachine;
import net.automatalib.graphs.ads.RecursiveADSNode;
import net.automatalib.words.Alphabet;

@ParametersAreNonnullByDefault
public class ExhaustiveReplacer
implements SubtreeReplacer {
    private final ADSCalculator adsCalculator;

    public ExhaustiveReplacer(ADSCalculator adsProvider) {
        this.adsCalculator = adsProvider;
    }

    @Override
    public <S, I, O> Set<ReplacementResult<S, I, O>> computeReplacements(MealyMachine<S, I, ?, O> hypothesis, Alphabet<I> inputs, ADT<S, I, O> adt) {
        if (ADTUtil.collectResetNodes(adt.getRoot()).isEmpty()) {
            return Collections.emptySet();
        }
        HashSet statesAsSet = new HashSet(hypothesis.getStates());
        Optional<ADTNode<S, I, O>> potentialResult = this.adsCalculator.compute(hypothesis, inputs, statesAsSet);
        if (potentialResult.isPresent()) {
            return Collections.singleton(new ReplacementResult<S, I, O>(adt.getRoot(), potentialResult.get()));
        }
        Set<ADTNode<S, I, O>> candidates = ADTUtil.collectADSNodes(adt.getRoot());
        candidates.remove(adt.getRoot());
        Map subtreesToFinalNodes = candidates.stream().collect(Collectors.toMap(Function.identity(), node -> ADTUtil.collectLeaves(node).stream().map(RecursiveADSNode::getHypothesisState).collect(Collectors.toSet())));
        ArrayList<ADTNode<S, I, O>> sortedCandidates = new ArrayList<ADTNode<S, I, O>>(candidates);
        sortedCandidates.sort(Comparator.comparingInt(n -> ((Set)subtreesToFinalNodes.get(n)).size()));
        for (ADTNode aDTNode : sortedCandidates) {
            Optional<ADTNode<S, I, O>> alt;
            Set finalNodes = subtreesToFinalNodes.get(aDTNode);
            HashSet targets = new HashSet(statesAsSet);
            targets.removeAll(finalNodes);
            if (targets.size() < 2 || !(alt = this.adsCalculator.compute(hypothesis, inputs, targets)).isPresent()) continue;
            return Collections.singleton(new ReplacementResult<S, I, O>(adt.getRoot(), alt.get(), finalNodes));
        }
        return Collections.emptySet();
    }
}

