/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.adt.automaton;

import de.learnlib.algorithms.adt.adt.ADTNode;
import de.learnlib.algorithms.adt.automaton.ADTState;
import de.learnlib.algorithms.adt.automaton.ADTTransition;
import de.learnlib.api.AccessSequenceTransformer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.automatalib.automata.base.fast.AbstractFastMutableDet;
import net.automatalib.automata.transducers.MutableMealyMachine;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

public class ADTHypothesis<I, O>
extends AbstractFastMutableDet<ADTState<I, O>, I, ADTTransition<I, O>, Void, O>
implements MutableMealyMachine<ADTState<I, O>, I, ADTTransition<I, O>, O>,
AccessSequenceTransformer<I> {
    public ADTHypothesis(Alphabet<I> alphabet) {
        super(alphabet);
    }

    @Nonnull
    public ADTState<I, O> getSuccessor(ADTTransition<I, O> transition) {
        return transition.getTarget();
    }

    @Nonnull
    public ADTTransition<I, O> createOpenTransition(ADTState<I, O> source, I input, ADTNode<ADTState<I, O>, I, O> siftTarget) {
        ADTTransition<I, O> result = new ADTTransition<I, O>();
        result.setSource(source);
        result.setInput(input);
        result.setSiftNode(siftTarget);
        this.setTransition(source, input, result);
        return result;
    }

    public void setTransition(ADTState<I, O> state, I input, ADTTransition<I, O> transition) {
        ADTTransition oldTrans = (ADTTransition)this.getTransition(state, input);
        if (oldTrans != null) {
            oldTrans.getTarget().getIncomingTransitions().remove(oldTrans);
        }
        super.setTransition(state, input, transition);
        if (transition != null) {
            transition.setSource(state);
            transition.setInput(input);
        }
    }

    protected ADTState<I, O> createState(Void property) {
        return new ADTState(this.inputAlphabet.size());
    }

    @Nonnull
    public ADTTransition<I, O> createTransition(ADTState<I, O> successor, @Nullable O properties) {
        ADTTransition<I, O> result = new ADTTransition<I, O>();
        result.setTarget(successor);
        result.setOutput(properties);
        return result;
    }

    public void setTransitionOutput(ADTTransition<I, O> transition, @Nullable O output) {
        transition.setOutput(output);
    }

    @Nullable
    public O getTransitionOutput(ADTTransition<I, O> transition) {
        return transition.getOutput();
    }

    public Word<I> transformAccessSequence(Word<I> word) {
        return ((ADTState)((Object)this.getState((Iterable)word))).getAccessSequence();
    }

    public boolean isAccessSequence(Word<I> word) {
        return ((ADTState)((Object)this.getState((Iterable)word))).getAccessSequence().equals(word);
    }
}

