/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.adt.model;

import de.learnlib.algorithms.adt.adt.ADTNode;
import de.learnlib.algorithms.adt.util.ADTUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.automata.transout.impl.FastMealy;
import net.automatalib.automata.transout.impl.FastMealyState;
import net.automatalib.commons.util.Pair;
import net.automatalib.util.automata.equivalence.NearLinearEquivalenceTest;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

@ParametersAreNonnullByDefault
public class ObservationTree<S, I, O> {
    private final Alphabet<I> alphabet;
    private final FastMealy<I, O> observationTree;
    private final Map<S, FastMealyState<O>> nodeToObservationMap;

    public ObservationTree(Alphabet<I> alphabet) {
        this.alphabet = alphabet;
        this.observationTree = new FastMealy(alphabet);
        this.nodeToObservationMap = new HashMap<S, FastMealyState<O>>();
    }

    public FastMealy<I, O> getObservationTree() {
        return this.observationTree;
    }

    public void initialize(S state) {
        FastMealyState init = (FastMealyState)this.observationTree.addInitialState();
        this.nodeToObservationMap.put(state, init);
    }

    public void initialize(Collection<S> states, Function<S, Word<I>> asFunction, Function<Word<I>, Word<O>> outputFunction) {
        FastMealyState init = (FastMealyState)this.observationTree.addInitialState();
        for (S s : states) {
            Word<I> as = asFunction.apply(s);
            FastMealyState<O> treeNode = this.addTrace(init, as, outputFunction.apply(as));
            this.nodeToObservationMap.put(s, treeNode);
        }
    }

    public void addTrace(S state, Word<I> input, Word<O> output) {
        this.addTrace(this.nodeToObservationMap.get(state), input, output);
    }

    private FastMealyState<O> addTrace(FastMealyState<O> state, Word<I> input, Word<O> output) {
        assert (input.length() == output.length()) : "Traces differ in length";
        Iterator inputIter = input.iterator();
        Iterator outputIter = output.iterator();
        FastMealyState iter = state;
        while (inputIter.hasNext()) {
            FastMealyState nextState;
            Object nextInput = inputIter.next();
            Object nextOuput = outputIter.next();
            if (this.observationTree.getTransition(iter, nextInput) == null) {
                nextState = (FastMealyState)this.observationTree.addState();
                this.observationTree.addTransition((Object)iter, nextInput, (Object)nextState, nextOuput);
            } else {
                assert (this.observationTree.getOutput(iter, nextInput).equals(nextOuput)) : "Inconsistent observations";
                nextState = (FastMealyState)this.observationTree.getSuccessor(iter, nextInput);
            }
            iter = nextState;
        }
        return iter;
    }

    public void addTrace(S state, ADTNode<S, I, O> adtNode) {
        FastMealyState<O> internalState = this.nodeToObservationMap.get(state);
        ADTNode adsIter = adtNode;
        while (adsIter != null) {
            Pair<Word<I>, Word<O>> trace = ADTUtil.buildTraceForNode(adsIter);
            this.addTrace(internalState, (Word)trace.getFirst(), (Word)trace.getSecond());
            adsIter = (ADTNode)ADTUtil.getStartOfADS(adsIter).getParent();
        }
    }

    public void addState(S newState, Word<I> accessSequence, O output) {
        FastMealyState target;
        Word prefix = accessSequence.prefix(accessSequence.length() - 1);
        Object sym = accessSequence.lastSymbol();
        FastMealyState pred = (FastMealyState)this.observationTree.getSuccessor((Object)this.observationTree.getInitialState(), (Iterable)prefix);
        if (pred.getTransition(this.alphabet.getSymbolIndex(sym)) == null) {
            target = (FastMealyState)this.observationTree.addState();
            this.observationTree.addTransition((Object)pred, sym, (Object)target, output);
        } else {
            target = (FastMealyState)this.observationTree.getSuccessor((Object)pred, sym);
        }
        this.nodeToObservationMap.put(newState, target);
    }

    public Optional<Word<I>> findSeparatingWord(S s1, S s2, Word<I> prefix) {
        Word sepWord;
        FastMealyState<O> n1 = this.nodeToObservationMap.get(s1);
        FastMealyState<O> n2 = this.nodeToObservationMap.get(s2);
        FastMealyState s1Succ = (FastMealyState)this.observationTree.getSuccessor(n1, prefix);
        FastMealyState s2Succ = (FastMealyState)this.observationTree.getSuccessor(n2, prefix);
        if (s1Succ != null && s2Succ != null && (sepWord = NearLinearEquivalenceTest.findSeparatingWord(this.observationTree, (Object)s1Succ, (Object)s2Succ, this.alphabet, (boolean)true)) != null) {
            return Optional.of(sepWord);
        }
        return Optional.empty();
    }

    public Word<I> findSeparatingWord(S s1, S s2) {
        FastMealyState<O> n1 = this.nodeToObservationMap.get(s1);
        FastMealyState<O> n2 = this.nodeToObservationMap.get(s2);
        return NearLinearEquivalenceTest.findSeparatingWord(this.observationTree, n1, n2, this.alphabet, (boolean)true);
    }

    public Word<O> trace(S s, Word<I> input) {
        FastMealyState<O> q = this.nodeToObservationMap.get(s);
        return this.observationTree.computeStateOutput(q, input);
    }
}

