/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.adt.config.model.replacer;

import de.learnlib.algorithms.adt.adt.ADT;
import de.learnlib.algorithms.adt.adt.ADTNode;
import de.learnlib.algorithms.adt.api.SubtreeReplacer;
import de.learnlib.algorithms.adt.config.model.ADSCalculator;
import de.learnlib.algorithms.adt.model.ReplacementResult;
import de.learnlib.algorithms.adt.util.ADTUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.graphs.ads.RecursiveADSNode;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

@ParametersAreNonnullByDefault
public class SingleReplacer
implements SubtreeReplacer {
    private final ADSCalculator adsCalculator;

    public SingleReplacer(ADSCalculator adsProvider) {
        this.adsCalculator = adsProvider;
    }

    @Override
    public <S, I, O> Set<ReplacementResult<S, I, O>> computeReplacements(MealyMachine<S, I, ?, O> hypothesis, Alphabet<I> inputs, ADT<S, I, O> adt) {
        Set<ADTNode<S, I, O>> candidates = ADTUtil.collectADSNodes(adt.getRoot());
        candidates.remove(adt.getRoot());
        Map candidatesScore = candidates.stream().collect(Collectors.toMap(Function.identity(), node -> {
            int resets = 1 + ADTUtil.collectResetNodes(node).size();
            int finals = ADTUtil.collectLeaves(node).size();
            return (double)resets / (double)finals;
        }));
        ArrayList<ADTNode<S, I, O>> sortedCandidates = new ArrayList<ADTNode<S, I, O>>(candidates);
        Collections.sort(sortedCandidates, Comparator.comparingDouble(candidatesScore::get));
        for (ADTNode aDTNode : sortedCandidates) {
            Optional<ADTNode<S, I, O>> potentialADS;
            Set targetStates;
            ReplacementResult<S, I, O> replacementResult = SingleReplacer.computeParentExtension(hypothesis, inputs, aDTNode, targetStates = ADTUtil.collectLeaves(aDTNode).stream().map(RecursiveADSNode::getHypothesisState).collect(Collectors.toSet()), this.adsCalculator);
            if (replacementResult != null) {
                return Collections.singleton(replacementResult);
            }
            if (ADTUtil.collectResetNodes(aDTNode).isEmpty() || !(potentialADS = this.adsCalculator.compute(hypothesis, inputs, targetStates)).isPresent()) continue;
            return Collections.singleton(new ReplacementResult<S, I, O>(aDTNode, potentialADS.get()));
        }
        return Collections.emptySet();
    }

    @Nullable
    static <S, I, O> ReplacementResult<S, I, O> computeParentExtension(MealyMachine<S, I, ?, O> hypothesis, Alphabet<I> inputs, ADTNode<S, I, O> node, Set<S> targetStates, ADSCalculator adsCalculator) {
        ADTNode parentReset = (ADTNode)node.getParent();
        assert (ADTUtil.isResetNode(parentReset)) : "should not happen";
        Word incomingTraceInput = (Word)ADTUtil.buildTraceForNode(parentReset).getFirst();
        Map currentToInitialMapping = targetStates.stream().collect(Collectors.toMap(Function.identity(), Function.identity()));
        for (Object i : incomingTraceInput) {
            HashMap nextMapping = new HashMap();
            for (Map.Entry entry : currentToInitialMapping.entrySet()) {
                Object successor = hypothesis.getSuccessor(entry.getKey(), i);
                if (nextMapping.containsKey(successor)) {
                    return null;
                }
                nextMapping.put(successor, entry.getValue());
            }
            currentToInitialMapping = nextMapping;
        }
        Optional<ADTNode<S, I, O>> potentialExtension = adsCalculator.compute(hypothesis, inputs, currentToInitialMapping.keySet());
        if (potentialExtension.isPresent()) {
            ADTNode<S, I, O> extension = potentialExtension.get();
            for (ADTNode<S, I, O> finalNode : ADTUtil.collectLeaves(extension)) {
                finalNode.setHypothesisState(currentToInitialMapping.get(finalNode.getHypothesisState()));
            }
            return new ReplacementResult<S, I, O>(parentReset, potentialExtension.get());
        }
        return null;
    }
}

