/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.adt.config.model.extender;

import de.learnlib.algorithms.adt.adt.ADTNode;
import de.learnlib.algorithms.adt.api.ADTExtender;
import de.learnlib.algorithms.adt.api.PartialTransitionAnalyzer;
import de.learnlib.algorithms.adt.automaton.ADTHypothesis;
import de.learnlib.algorithms.adt.automaton.ADTState;
import de.learnlib.algorithms.adt.config.model.DefensiveADSCalculator;
import de.learnlib.algorithms.adt.model.ExtensionResult;
import de.learnlib.algorithms.adt.util.ADTUtil;
import de.learnlib.api.query.DefaultQuery;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.commons.util.Pair;
import net.automatalib.graphs.ads.RecursiveADSNode;
import net.automatalib.words.Word;

@ParametersAreNonnullByDefault
public class DefaultExtender
implements ADTExtender {
    private final DefensiveADSCalculator adsCalculator;

    public DefaultExtender(DefensiveADSCalculator adsCalculator) {
        this.adsCalculator = adsCalculator;
    }

    @Override
    public <I, O> ExtensionResult<ADTState<I, O>, I, O> computeExtension(ADTHypothesis<I, O> hypothesis, PartialTransitionAnalyzer<ADTState<I, O>, I> partialTransitionAnalyzer, ADTNode<ADTState<I, O>, I, O> ads) {
        if (ads.getParent() == null) {
            return ExtensionResult.empty();
        }
        Set<ADTNode<ADTState<I, O>, I, O>> initialNodes = ADTUtil.collectLeaves(ads);
        if (initialNodes.size() > 2) {
            return ExtensionResult.empty();
        }
        Pair parentTrace = ADTUtil.buildTraceForNode((ADTNode)ads.getParent());
        while (true) {
            Word inputTrace = (Word)parentTrace.getFirst();
            Word outputTrace = (Word)parentTrace.getSecond();
            try {
                Map currentToInitialMapping = ADTUtil.collectLeaves(ads).stream().map(RecursiveADSNode::getHypothesisState).collect(Collectors.toMap(Function.identity(), Function.identity()));
                for (int idx = 0; idx < inputTrace.length(); ++idx) {
                    HashMap nextCurrentToInitialMapping = new HashMap();
                    Object input = inputTrace.getSymbol(idx);
                    Object output = outputTrace.getSymbol(idx);
                    for (Map.Entry entry : currentToInitialMapping.entrySet()) {
                        ADTState s = (ADTState)((Object)entry.getKey());
                        if (!partialTransitionAnalyzer.isTransitionDefined(s, input)) {
                            partialTransitionAnalyzer.closeTransition(s, input);
                        }
                        if (!hypothesis.getOutput((Object)s, input).equals(output)) {
                            ADTState initial = (ADTState)((Object)entry.getValue());
                            Word as = initial.getAccessSequence();
                            Word asOut = (Word)hypothesis.computeOutput((Iterable)as);
                            Word traceIn = inputTrace.prefix(idx + 1);
                            Word traceOut = outputTrace.prefix(idx + 1);
                            DefaultQuery ce = new DefaultQuery(as.concat(new Word[]{traceIn}), (Object)asOut.concat(new Word[]{traceOut}));
                            return new ExtensionResult(ce);
                        }
                        ADTState successor = (ADTState)((Object)hypothesis.getSuccessor((Object)s, input));
                        if (nextCurrentToInitialMapping.containsKey((Object)successor)) {
                            return ExtensionResult.empty();
                        }
                        nextCurrentToInitialMapping.put(successor, currentToInitialMapping.get((Object)s));
                    }
                    currentToInitialMapping = nextCurrentToInitialMapping;
                }
                Set currentSet = currentToInitialMapping.keySet();
                Optional potentialExtension = this.adsCalculator.compute(hypothesis, hypothesis.getInputAlphabet(), currentSet, partialTransitionAnalyzer);
                if (!potentialExtension.isPresent()) {
                    return ExtensionResult.empty();
                }
                ADTNode extension = potentialExtension.get();
                for (ADTNode finalNode : ADTUtil.collectLeaves(extension)) {
                    finalNode.setHypothesisState(currentToInitialMapping.get(finalNode.getHypothesisState()));
                }
                return new ExtensionResult(extension);
            }
            catch (PartialTransitionAnalyzer.HypothesisModificationException hypothesisModificationException) {
                continue;
            }
            break;
        }
    }
}

