/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.adt.config;

import de.learnlib.algorithms.adt.adt.ADT;
import de.learnlib.algorithms.adt.api.SubtreeReplacer;
import de.learnlib.algorithms.adt.config.model.calculator.BestEffortCalculator;
import de.learnlib.algorithms.adt.config.model.calculator.MinLengthCalculator;
import de.learnlib.algorithms.adt.config.model.calculator.MinSizeCalculator;
import de.learnlib.algorithms.adt.config.model.replacer.ExhaustiveReplacer;
import de.learnlib.algorithms.adt.config.model.replacer.LevelOrderReplacer;
import de.learnlib.algorithms.adt.config.model.replacer.SingleReplacer;
import de.learnlib.algorithms.adt.model.ReplacementResult;
import java.util.Collections;
import java.util.Set;
import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.words.Alphabet;

public final class SubtreeReplacers {
    public static final SubtreeReplacer NEVER_REPLACE = new SubtreeReplacer(){

        @Override
        public <S, I, O> Set<ReplacementResult<S, I, O>> computeReplacements(MealyMachine<S, I, ?, O> hypothesis, Alphabet<I> inputs, ADT<S, I, O> adt) {
            return Collections.emptySet();
        }
    };
    public static final SubtreeReplacer LEVELED_BEST_EFFORT = new LevelOrderReplacer(new BestEffortCalculator());
    public static final SubtreeReplacer LEVELED_MIN_LENGTH = new LevelOrderReplacer(new MinLengthCalculator());
    public static final SubtreeReplacer LEVELED_MIN_SIZE = new LevelOrderReplacer(new MinSizeCalculator());
    public static final SubtreeReplacer EXHAUSTIVE_BEST_EFFORT = new ExhaustiveReplacer(new BestEffortCalculator());
    public static final SubtreeReplacer EXHAUSTIVE_MIN_LENGTH = new ExhaustiveReplacer(new MinLengthCalculator());
    public static final SubtreeReplacer EXHAUSTIVE_MIN_SIZE = new ExhaustiveReplacer(new MinSizeCalculator());
    public static final SubtreeReplacer SINGLE_BEST_EFFORT = new SingleReplacer(new BestEffortCalculator());
    public static final SubtreeReplacer SINGLE_MIN_LENGTH = new SingleReplacer(new MinLengthCalculator());
    public static final SubtreeReplacer SINGLE_MIN_SIZE = new SingleReplacer(new MinSizeCalculator());

    private SubtreeReplacers() {
    }
}

