/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.adt.adt;

import de.learnlib.algorithms.adt.adt.ADTNode;
import de.learnlib.api.oracle.SymbolQueryOracle;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.words.Word;

@ParametersAreNonnullByDefault
public class ADTResetNode<S, I, O>
implements ADTNode<S, I, O>,
Serializable {
    final ADTNode<S, I, O> successor;
    ADTNode<S, I, O> parent;

    public ADTResetNode(ADTNode<S, I, O> successor) {
        this.successor = successor;
    }

    public I getSymbol() {
        return null;
    }

    public void setSymbol(I symbol) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Reset nodes do not have a symbol");
    }

    public ADTNode<S, I, O> getParent() {
        return this.parent;
    }

    public void setParent(ADTNode<S, I, O> parent) {
        this.parent = parent;
    }

    public Map<O, ADTNode<S, I, O>> getChildren() {
        return Collections.singletonMap(null, this.successor);
    }

    public S getHypothesisState() {
        return null;
    }

    public void setHypothesisState(S state) {
        throw new UnsupportedOperationException("Reset nodes cannot reference a hypothesis state");
    }

    @Override
    public ADTNode<S, I, O> sift(SymbolQueryOracle<I, O> oracle, Word<I> prefix) {
        oracle.reset();
        for (Object i : prefix) {
            oracle.query(i);
        }
        return this.successor;
    }

    @Override
    public ADTNode.NodeType getNodeType() {
        return ADTNode.NodeType.RESET_NODE;
    }

    public String toString() {
        return "reset";
    }
}

