/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.adt.ads;

import de.learnlib.algorithms.adt.adt.ADTLeafNode;
import de.learnlib.algorithms.adt.adt.ADTNode;
import de.learnlib.algorithms.adt.api.PartialTransitionAnalyzer;
import de.learnlib.algorithms.adt.util.ADTUtil;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.commons.util.Pair;
import net.automatalib.util.automata.ads.ADSUtil;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

@ParametersAreNonnullByDefault
public final class DefensiveADS<S, I, O> {
    private final MealyMachine<S, I, ?, O> automaton;
    private final Alphabet<I> alphabet;
    private final Set<S> states;
    private final PartialTransitionAnalyzer<S, I> partialTransitionAnalyzer;
    private Set<S> refinementStates;
    private I refinementInput;

    private DefensiveADS(MealyMachine<S, I, ?, O> automaton, Alphabet<I> alphabet, Set<S> states, PartialTransitionAnalyzer<S, I> partialTransitionAnalyzer) {
        this.automaton = automaton;
        this.alphabet = alphabet;
        this.states = states;
        this.partialTransitionAnalyzer = partialTransitionAnalyzer;
    }

    public static <S, I, O> Optional<ADTNode<S, I, O>> compute(MealyMachine<S, I, ?, O> automaton, Alphabet<I> alphabet, Set<S> states, PartialTransitionAnalyzer<S, I> pta) {
        return super.compute();
    }

    private Optional<ADTNode<S, I, O>> compute() {
        Map initialMapping = this.states.stream().collect(Collectors.toMap(Function.identity(), Function.identity()));
        Optional<ADTNode<Object, I, O>> interMediateResult = this.compute(initialMapping);
        while (!interMediateResult.isPresent() && this.refinementStates != null && this.refinementInput != null) {
            for (S s : this.refinementStates) {
                this.partialTransitionAnalyzer.closeTransition(s, this.refinementInput);
            }
            this.refinementStates = null;
            this.refinementInput = null;
            interMediateResult = this.compute(initialMapping);
        }
        return interMediateResult;
    }

    private Optional<ADTNode<S, I, O>> compute(Map<S, S> mapping) {
        long maximumSplittingWordLength = ADSUtil.computeMaximumSplittingWordLength((int)this.automaton.size(), (int)mapping.size(), (int)this.states.size());
        LinkedList<Word> splittingWordCandidates = new LinkedList<Word>();
        StateIDs stateIds = this.automaton.stateIDs();
        HashSet<BitSet> cache = new HashSet<BitSet>();
        splittingWordCandidates.add(Word.epsilon());
        while (!splittingWordCandidates.isEmpty()) {
            Word prefix = (Word)splittingWordCandidates.poll();
            Map<Object, Object> currentToInitialMapping = mapping.keySet().stream().collect(Collectors.toMap(x -> this.automaton.getSuccessor(x, (Iterable)prefix), mapping::get));
            BitSet currentSetAsBitSet = new BitSet();
            for (Object s : currentToInitialMapping.keySet()) {
                currentSetAsBitSet.set(stateIds.getStateId(s));
            }
            if (cache.contains(currentSetAsBitSet)) continue;
            block2: for (Object i : this.alphabet) {
                Iterator<Map.Entry<Object, Object>> s2;
                HashSet<S> statesWithMissingTransitions = new HashSet<S>();
                for (Iterator<Map.Entry<Object, Object>> s2 : currentToInitialMapping.keySet()) {
                    if (this.partialTransitionAnalyzer.isTransitionDefined(s2, i)) continue;
                    statesWithMissingTransitions.add(s2);
                }
                if (!statesWithMissingTransitions.isEmpty()) {
                    if (this.refinementStates != null && statesWithMissingTransitions.size() >= this.refinementStates.size()) continue;
                    this.refinementStates = statesWithMissingTransitions;
                    this.refinementInput = i;
                    continue;
                }
                HashMap successors = new HashMap();
                s2 = currentToInitialMapping.entrySet().iterator();
                while (s2.hasNext()) {
                    Object nextMapping;
                    Map.Entry<Object, Object> entry = s2.next();
                    Object current = entry.getKey();
                    Object nextState = this.automaton.getSuccessor(current, i);
                    Object nextOutput = this.automaton.getOutput(current, i);
                    if (!successors.containsKey(nextOutput)) {
                        nextMapping = new HashMap();
                        successors.put(nextOutput, nextMapping);
                    } else {
                        nextMapping = (Map)successors.get(nextOutput);
                    }
                    if (nextMapping.put(nextState, entry.getValue()) == null) continue;
                    continue block2;
                }
                if (successors.size() > 1) {
                    HashMap results = new HashMap();
                    for (Map.Entry entry : successors.entrySet()) {
                        Optional<ADTNode<S, I, O>> succ;
                        Map currentMapping = (Map)entry.getValue();
                        BitSet currentNodeAsBitSet = new BitSet();
                        for (Object s3 : currentMapping.keySet()) {
                            currentNodeAsBitSet.set(stateIds.getStateId(s3));
                        }
                        if (cache.contains(currentNodeAsBitSet)) continue block2;
                        if (currentMapping.size() > 1) {
                            succ = this.compute(currentMapping);
                        } else {
                            Object s3;
                            s3 = currentMapping.values().iterator().next();
                            succ = Optional.of(new ADTLeafNode(null, s3));
                        }
                        if (!succ.isPresent()) {
                            cache.add(currentNodeAsBitSet);
                            continue block2;
                        }
                        results.put(entry.getKey(), succ.get());
                    }
                    Pair<ADTNode<S, I, O>, ADTNode<S, I, O>> ads = ADTUtil.buildADSFromTrace(this.automaton, prefix.append(i), mapping.keySet().iterator().next());
                    ADTNode head = (ADTNode)ads.getFirst();
                    ADTNode tail = (ADTNode)ads.getSecond();
                    for (Map.Entry entry : results.entrySet()) {
                        ((ADTNode)entry.getValue()).setParent(tail);
                        tail.getChildren().put(entry.getKey(), entry.getValue());
                    }
                    return Optional.of(head);
                }
                if ((long)prefix.length() >= maximumSplittingWordLength) continue;
                splittingWordCandidates.add(prefix.append(i));
            }
            cache.add(currentSetAsBitSet);
        }
        return Optional.empty();
    }
}

