/*
 * Decompiled with CFR 0.152.
 */
package de.leanovate.cucumber.rest;

import de.leanovate.cucumber.rest.JsonHelper;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.stream.Stream;
import org.apache.commons.codec.Charsets;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

public class Utils {
    public static String formatRequest(HttpRequest request) {
        StringBuilder sb = new StringBuilder();
        sb.append(request.getRequestLine()).append("\n");
        Stream.of(request.getAllHeaders()).map(Utils::formatHeader).forEach(sb::append);
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            sb.append("\n");
            if (entity != null) {
                try {
                    String body = EntityUtils.toString((HttpEntity)entity, (Charset)Charsets.UTF_8);
                    ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)new StringEntity(body, Charsets.UTF_8));
                    sb.append(JsonHelper.tryFormatJson(body));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return sb.toString();
    }

    public static String formatResponse(HttpResponse response) {
        StringBuilder sb = new StringBuilder();
        sb.append(response.getStatusLine().toString()).append("\n");
        Stream.of(response.getAllHeaders()).map(Utils::formatHeader).forEach(sb::append);
        if (response.getEntity() != null) {
            sb.append("\n");
            try {
                String body = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charsets.UTF_8);
                EntityUtils.updateEntity((HttpResponse)response, (HttpEntity)new StringEntity(body, Charsets.UTF_8));
                sb.append(JsonHelper.tryFormatJson(body));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return sb.toString();
    }

    public static String formatHeader(Header header) {
        String name = header.getName();
        String value = header.getValue();
        if ("Authorization".equalsIgnoreCase(name)) {
            int half = value.length() / 2;
            value = value.substring(0, value.length() - half) + Utils.repeatChar('*', half);
        }
        return String.format("%s: %s\n", name, value);
    }

    public static String repeatChar(char ch, int count) {
        StringBuilder builder = new StringBuilder(count);
        for (int i = 0; i < count; ++i) {
            builder.append(ch);
        }
        return builder.toString();
    }
}

