/*
 * Decompiled with CFR 0.152.
 */
package de.leanovate.cucumber.rest;

import com.fasterxml.jackson.databind.JsonNode;
import cucumber.api.Scenario;
import cucumber.api.java.Before;
import de.leanovate.cucumber.rest.JsonHelper;
import de.leanovate.cucumber.rest.RestAssertions;
import de.leanovate.cucumber.rest.Utils;
import de.leanovate.cucumber.rest.WithEtag;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class TestHttpClient {
    public final Executor http;
    public final Executor noReportHttp;
    private Optional<Scenario> scenario = Optional.empty();

    public TestHttpClient() {
        try {
            SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial((chain, authType) -> true).build();
            CloseableHttpClient httpClient = HttpClientBuilder.create().setMaxConnTotal(100).setMaxConnPerRoute(100).setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).setSSLContext(sslContext).addInterceptorLast((HttpRequestInterceptor)new RequestReporter()).addInterceptorLast((HttpResponseInterceptor)new ResponseReporter()).disableRedirectHandling().build();
            CloseableHttpClient noReportHttpClient = HttpClientBuilder.create().setMaxConnTotal(100).setMaxConnPerRoute(100).setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).setSSLContext(sslContext).disableRedirectHandling().build();
            this.http = Executor.newInstance((HttpClient)httpClient);
            this.noReportHttp = Executor.newInstance((HttpClient)noReportHttpClient);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Before
    public void setScenario(Scenario scenario) {
        this.scenario = Optional.of(scenario);
    }

    public HttpResponse execute(Request request) {
        return (HttpResponse)this.execute(request, response -> response, true);
    }

    public <T> T execute(Request request, ResponseHandler<T> responseHandler, boolean report) {
        try {
            if (report) {
                return (T)this.http.execute(request).handleResponse(responseHandler);
            }
            return (T)this.noReportHttp.execute(request).handleResponse(responseHandler);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T executeJson(Request request, Class<T> expected) {
        return this.executeJson(request, expected, true);
    }

    public <T> T executeJson(Request request, Class<T> expected, boolean report) {
        return this.execute(request, response -> {
            RestAssertions.assertThat(response).isNotFailure();
            Object result = JsonHelper.entityToValue(response.getEntity(), expected);
            Header etagHeader = response.getFirstHeader("ETag");
            if (etagHeader != null && result instanceof WithEtag) {
                ((WithEtag)result).updateEtag(etagHeader.getValue());
            }
            return result;
        }, report);
    }

    public JsonNode executeJsonTree(Request request) {
        return this.executeJsonTree(request, true);
    }

    public JsonNode executeJsonTree(Request request, boolean report) {
        return (JsonNode)this.execute(request, response -> {
            RestAssertions.assertThat(response).isNotFailure();
            return JsonHelper.entityToTree(response.getEntity());
        }, report);
    }

    public Document executeHtml(Request request) {
        return this.executeHtml(request, true);
    }

    public Document executeHtml(Request request, boolean report) {
        return (Document)this.execute(request, response -> {
            RestAssertions.assertThat(response).isNotFailure();
            return Jsoup.parse((InputStream)response.getEntity().getContent(), (String)"UTF-8", (String)"");
        }, report);
    }

    class ResponseReporter
    implements HttpResponseInterceptor {
        ResponseReporter() {
        }

        public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            TestHttpClient.this.scenario.ifPresent(scenario -> scenario.write(Utils.formatResponse(response)));
        }
    }

    class RequestReporter
    implements HttpRequestInterceptor {
        RequestReporter() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            TestHttpClient.this.scenario.ifPresent(scenario -> scenario.write(Utils.formatRequest(request)));
        }
    }
}

