/*
 * Decompiled with CFR 0.152.
 */
package de.leanovate.cucumber.rest;

import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;

public class HttpResponseAssert
extends AbstractAssert<HttpResponseAssert, HttpResponse> {
    protected HttpResponseAssert(HttpResponse actual) {
        super((Object)actual, HttpResponseAssert.class);
    }

    public HttpResponseAssert isNotFailure() {
        this.isNotNull();
        Assertions.assertThat((int)((HttpResponse)this.actual).getStatusLine().getStatusCode()).isGreaterThanOrEqualTo(200).isLessThan(300);
        return (HttpResponseAssert)this.myself;
    }

    public HttpResponseAssert isClientError() {
        this.isNotNull();
        Assertions.assertThat((int)((HttpResponse)this.actual).getStatusLine().getStatusCode()).isGreaterThanOrEqualTo(400).isLessThan(500);
        return (HttpResponseAssert)this.myself;
    }

    public HttpResponseAssert hasStatus(int status) {
        this.isNotNull();
        Assertions.assertThat((int)((HttpResponse)this.actual).getStatusLine().getStatusCode()).isEqualTo(status);
        return (HttpResponseAssert)this.myself;
    }

    public HttpResponseAssert isOk() {
        return this.hasStatus(200);
    }

    public HttpResponseAssert isCreated() {
        return this.hasStatus(201);
    }

    public HttpResponseAssert isNoContent() {
        return this.hasStatus(204);
    }

    public HttpResponseAssert isBadRequest() {
        return this.hasStatus(400);
    }

    public HttpResponseAssert isNotFound() {
        return this.hasStatus(404);
    }

    public HttpResponseAssert hasHeader(String name) {
        this.isNotNull();
        Header header = ((HttpResponse)this.actual).getFirstHeader(name);
        Assertions.assertThat((Object)header).isNotNull();
        Assertions.assertThat((String)header.getValue()).isNotEmpty();
        return (HttpResponseAssert)this.myself;
    }
}

