/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.spring;

import com.sass_lang.embedded_protocol.InboundMessage;
import com.sass_lang.embedded_protocol.OutputStyle;
import com.sass_lang.embedded_protocol.Syntax;
import de.larsgrefer.sass.embedded.CompileSuccess;
import de.larsgrefer.sass.embedded.SassCompiler;
import de.larsgrefer.sass.embedded.spring.CompiledResource;
import de.larsgrefer.sass.embedded.spring.SassResourceUtil;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.resource.ResourceTransformer;
import org.springframework.web.servlet.resource.ResourceTransformerChain;

public class SassResourceTransformer
implements ResourceTransformer {
    private final SassCompiler sassCompiler;
    private OutputStyle outputStyle;

    public Resource transform(HttpServletRequest request, Resource resource, ResourceTransformerChain transformerChain) throws IOException {
        if ((resource = transformerChain.transform(request, resource)) instanceof CompiledResource && ((CompiledResource)resource).getOutputStyle() == this.outputStyle) {
            return resource;
        }
        String filename = resource.getFilename();
        if (!"css".equals(StringUtils.getFilenameExtension((String)filename))) {
            return resource;
        }
        InboundMessage.CompileRequest.StringInput stringInput = SassResourceUtil.toStringInput((Resource)resource, (Syntax)Syntax.CSS);
        try {
            CompileSuccess compileSuccess = this.sassCompiler.compileString(stringInput, this.outputStyle);
            return new CompiledResource(resource, compileSuccess, resource.getFilename(), this.outputStyle);
        }
        catch (Exception e) {
            return resource;
        }
    }

    @Generated
    public SassResourceTransformer(SassCompiler sassCompiler, OutputStyle outputStyle) {
        this.sassCompiler = sassCompiler;
        this.outputStyle = outputStyle;
    }

    @Generated
    public SassResourceTransformer(SassCompiler sassCompiler) {
        this.sassCompiler = sassCompiler;
    }

    @Generated
    public OutputStyle getOutputStyle() {
        return this.outputStyle;
    }

    @Generated
    public void setOutputStyle(OutputStyle outputStyle) {
        this.outputStyle = outputStyle;
    }
}

