/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.spring;

import com.sass_lang.embedded_protocol.InboundMessage;
import com.sass_lang.embedded_protocol.OutputStyle;
import de.larsgrefer.sass.embedded.CompileSuccess;
import de.larsgrefer.sass.embedded.SassCompilationFailedException;
import de.larsgrefer.sass.embedded.SassCompiler;
import de.larsgrefer.sass.embedded.spring.CompiledResource;
import de.larsgrefer.sass.embedded.spring.SassResourceUtil;
import de.larsgrefer.sass.embedded.spring.SourceMapResource;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.resource.AbstractResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolverChain;

public class SassResourceResolver
extends AbstractResourceResolver {
    private static final Logger log = LoggerFactory.getLogger(SassResourceResolver.class);
    private final SassCompiler sassCompiler;
    private OutputStyle outputStyle = OutputStyle.COMPRESSED;

    protected Resource resolveResourceInternal(HttpServletRequest request, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        Resource resource = chain.resolveResource(request, requestPath, locations);
        if (resource != null && resource.exists()) {
            return resource;
        }
        String filename = StringUtils.getFilename((String)requestPath);
        if (filename.endsWith(".css") || filename.endsWith(".css.map") && this.sassCompiler.isGenerateSourceMaps()) {
            boolean sourcemap = filename.endsWith(".css.map");
            String basePath = requestPath.substring(0, requestPath.length() - (sourcemap ? 8 : 4));
            for (String extension : Arrays.asList(".scss", ".sass")) {
                String scssPath = basePath + extension;
                Resource scssResource = chain.resolveResource(request, scssPath, locations);
                if (scssResource == null || !scssResource.exists()) continue;
                try {
                    InboundMessage.CompileRequest.StringInput si = SassResourceUtil.toStringInput((Resource)scssResource);
                    CompileSuccess compileSuccess = this.sassCompiler.compileString(si, this.outputStyle);
                    if (sourcemap) {
                        return new SourceMapResource(scssResource, compileSuccess, filename, this.outputStyle);
                    }
                    return new CompiledResource(scssResource, compileSuccess, filename, this.outputStyle);
                }
                catch (SassCompilationFailedException | IOException e) {
                    log.info(e.getLocalizedMessage(), e);
                }
            }
        }
        return null;
    }

    protected String resolveUrlPathInternal(String resourcePath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return chain.resolveUrlPath(resourcePath, locations);
    }

    public SassResourceResolver(SassCompiler sassCompiler) {
        this.sassCompiler = sassCompiler;
    }

    public SassResourceResolver(SassCompiler sassCompiler, OutputStyle outputStyle) {
        this.sassCompiler = sassCompiler;
        this.outputStyle = outputStyle;
    }

    public void setOutputStyle(OutputStyle outputStyle) {
        this.outputStyle = outputStyle;
    }
}

