/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.util;

import com.sass_lang.embedded_protocol.Syntax;
import java.io.File;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import javax.annotation.Nonnull;
import lombok.Generated;
import lombok.NonNull;

public final class SyntaxUtil {
    public static Syntax guessSyntax(@NonNull URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url is marked non-null but is null");
        }
        return SyntaxUtil.guessSyntax(url.getPath());
    }

    public static Syntax guessSyntax(@NonNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("file is marked non-null but is null");
        }
        return SyntaxUtil.guessSyntax(file.getName());
    }

    public static Syntax guessSyntax(@NonNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("path is marked non-null but is null");
        }
        String lowerPath = path.toLowerCase();
        if (lowerPath.endsWith(".css")) {
            return Syntax.CSS;
        }
        if (lowerPath.endsWith(".scss")) {
            return Syntax.SCSS;
        }
        if (lowerPath.endsWith(".sass")) {
            return Syntax.INDENTED;
        }
        return Syntax.UNRECOGNIZED;
    }

    @Nonnull
    public static Syntax guessSyntax(URLConnection urlConnection) {
        String contentType = urlConnection.getContentType();
        if (contentType != null) {
            if ((contentType = contentType.toLowerCase(Locale.ROOT)).startsWith("text/css")) {
                return Syntax.CSS;
            }
            if (contentType.startsWith("text/x-scss")) {
                return Syntax.SCSS;
            }
            if (contentType.startsWith("text/x-sass")) {
                return Syntax.INDENTED;
            }
        }
        return SyntaxUtil.guessSyntax(urlConnection.getURL());
    }

    @Generated
    private SyntaxUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

