/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.util;

import com.sass_lang.embedded_protocol.Value;
import lombok.Generated;
import lombok.NonNull;

final class ColorValidator {
    static void assertValid(@NonNull Value.ColorOrBuilder color) {
        if (color == null) {
            throw new IllegalArgumentException("color is marked non-null but is null");
        }
        if ("rgb".equals(color.getSpace())) {
            ColorValidator.assertValidRgb(color);
        } else if ("hsl".equals(color.getSpace())) {
            ColorValidator.assertValidHsl(color);
        } else if ("hwb".equals(color.getSpace())) {
            ColorValidator.assertValidHwb(color);
        } else {
            throw new IllegalArgumentException("Unsupported color space: " + color.getSpace());
        }
    }

    static void assertValidRgb(@NonNull Value.ColorOrBuilder rgbColor) {
        if (rgbColor == null) {
            throw new IllegalArgumentException("rgbColor is marked non-null but is null");
        }
        int red = (int)rgbColor.getChannel1();
        if (red < 0 || red > 255) {
            throw new IllegalArgumentException("Red must be between 0 and 255.");
        }
        int green = (int)rgbColor.getChannel2();
        if (green < 0 || green > 255) {
            throw new IllegalArgumentException("Green must be between 0 and 255.");
        }
        int blue = (int)rgbColor.getChannel3();
        if (blue < 0 || blue > 255) {
            throw new IllegalArgumentException("Blue must be between 0 and 255.");
        }
        double alpha = rgbColor.getAlpha();
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("Alpha must be between 0 and 1.");
        }
    }

    static void assertValidHsl(@NonNull Value.ColorOrBuilder hslColor) {
        if (hslColor == null) {
            throw new IllegalArgumentException("hslColor is marked non-null but is null");
        }
        double saturation = hslColor.getChannel2();
        if (saturation < 0.0 || saturation > 100.0) {
            throw new IllegalArgumentException("Saturation must be between 0 and 100.");
        }
        double lightness = hslColor.getChannel3();
        if (lightness < 0.0 || lightness > 100.0) {
            throw new IllegalArgumentException("Lightness must be between 0 and 100.");
        }
        double alpha = hslColor.getAlpha();
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("Alpha must be between 0 and 1.");
        }
    }

    static void assertValidHwb(@NonNull Value.ColorOrBuilder hwbColor) {
        if (hwbColor == null) {
            throw new IllegalArgumentException("hwbColor is marked non-null but is null");
        }
        double whiteness = hwbColor.getChannel2();
        if (whiteness < 0.0 || whiteness > 100.0) {
            throw new IllegalArgumentException("Whiteness must be between 0 and 100.");
        }
        double blackness = hwbColor.getChannel3();
        if (blackness < 0.0 || blackness > 100.0) {
            throw new IllegalArgumentException("Whiteness must be between 0 and 100.");
        }
        if (whiteness + blackness > 100.0) {
            throw new IllegalArgumentException("The sum of `whiteness` and `blackness` must not exceed 100.");
        }
        double alpha = hwbColor.getAlpha();
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("Alpha must be between 0 and 1.");
        }
    }

    @Generated
    private ColorValidator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

