/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.functions;

import com.sass_lang.embedded_protocol.Value;
import de.larsgrefer.sass.embedded.util.ColorUtil;
import java.util.Locale;
import lombok.Generated;

public final class SassColor {
    public static Value.Color adjustHue(Value.Color color, double hue) {
        if ("hsl".equals(color.getSpace()) || "hwb".equals(color.getSpace())) {
            double newHue = color.getChannel1() + hue;
            return color.toBuilder().setChannel1(SassColor.normalizeHue(newHue)).build();
        }
        return SassColor.adjustHue(ColorUtil.toHslColor(color), hue);
    }

    public static double alpha(Value.ColorOrBuilder color) {
        return color.getAlpha();
    }

    public static double blackness(Value.Color color) {
        return ColorUtil.toHwbColor(color).getChannel3();
    }

    public static int blue(Value.Color color) {
        return (int)ColorUtil.toRgbColor(color).getChannel3();
    }

    public static Value.Color complement(Value.Color color) {
        return SassColor.adjustHue(color, 180.0);
    }

    public static Value.Color darken(Value.Color color, double amount) {
        color = ColorUtil.toHslColor(color);
        double newLightness = color.getChannel3() - amount;
        return color.toBuilder().setChannel3(SassColor.normalize100(newLightness)).build();
    }

    public static Value.Color desaturate(Value.Color color, double amount) {
        color = ColorUtil.toHslColor(color);
        double newSaturation = color.getChannel2() - amount;
        return color.toBuilder().setChannel2(SassColor.normalize100(newSaturation)).build();
    }

    public static Value.Color grayscale(Value.Color color) {
        color = ColorUtil.toHslColor(color);
        return color.toBuilder().setChannel2(0.0).build();
    }

    public static int green(Value.Color color) {
        return (int)ColorUtil.toRgbColor(color).getChannel2();
    }

    public static double hue(Value.Color color) {
        if (color.getSpace().equals("hsl") || color.getSpace().equals("hwb")) {
            return color.getChannel1();
        }
        return ColorUtil.toHslColor(color).getChannel1();
    }

    public static Value.Color hwb(double hue, double whiteness, double blackness) {
        return SassColor.hwb(hue, whiteness, blackness, 1.0);
    }

    public static Value.Color hwb(double hue, double whiteness, double blackness, double alpha) {
        return Value.Color.newBuilder().setSpace("hwb").setChannel1(hue).setChannel2(whiteness).setChannel3(blackness).setAlpha(alpha).build();
    }

    public static Value.String ieHexStr(Value.Color color) {
        Value.Color rgbColor = ColorUtil.toRgbColor(color);
        int a = (int)Math.round(rgbColor.getAlpha() * 255.0);
        int red = (int)rgbColor.getChannel1();
        int green = (int)rgbColor.getChannel2();
        int blue = (int)rgbColor.getChannel3();
        int value = (a & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | (blue & 0xFF) << 0;
        return Value.String.newBuilder().setText("#" + Integer.toHexString(value).toUpperCase(Locale.ROOT)).setQuoted(false).build();
    }

    public static Value.Color invert(Value.Color color) {
        return SassColor.invert(color, 1.0);
    }

    public static Value.Color invert(Value.Color color, double weight) {
        if (weight < 0.0 || weight > 1.0) {
            throw new IllegalArgumentException("weight must be between 0 and 1");
        }
        color = ColorUtil.toRgbColor(color);
        Value.Color inverse = color.toBuilder().setChannel1(255.0 - color.getChannel1()).setChannel2(255.0 - color.getChannel2()).setChannel3(255.0 - color.getChannel3()).build();
        return SassColor.mix(inverse, color, weight);
    }

    public static Value.Color lighten(Value.Color color, double amount) {
        if (amount < 0.0 || amount > 100.0) {
            throw new IllegalArgumentException("amount");
        }
        color = ColorUtil.toHslColor(color);
        return color.toBuilder().setChannel3(SassColor.normalize100(color.getChannel3() + amount)).build();
    }

    public static double lightness(Value.Color color) {
        return ColorUtil.toHslColor(color).getChannel3();
    }

    public static Value.Color mix(Value.Color color1, Value.Color color2) {
        return SassColor.mix(color1, color2, 0.5);
    }

    public static Value.Color mix(Value.Color color1, Value.Color color2, double weight) {
        if (weight <= 0.0) {
            return color2;
        }
        if (weight > 1.0) {
            return color1;
        }
        double normalizedWeight = weight * 2.0 - 1.0;
        double alphaDistance = color1.getAlpha() - color2.getAlpha();
        double combinedWeight1 = normalizedWeight * alphaDistance == -1.0 ? normalizedWeight : (normalizedWeight + alphaDistance) / (1.0 + normalizedWeight * alphaDistance);
        double weight1 = (combinedWeight1 + 1.0) / 2.0;
        double weight2 = 1.0 - weight1;
        int r = (int)Math.round((double)SassColor.red(color1) * weight1 + (double)SassColor.red(color2) * weight2);
        int g = (int)Math.round((double)SassColor.green(color1) * weight1 + (double)SassColor.green(color2) * weight2);
        int b = (int)Math.round((double)SassColor.blue(color1) * weight1 + (double)SassColor.blue(color2) * weight2);
        double a = color1.getAlpha() * weight + color2.getAlpha() * (1.0 - weight);
        return Value.Color.newBuilder().setSpace("rgb").setChannel1((double)r).setChannel2((double)g).setChannel3((double)b).setAlpha(a).build();
    }

    public static Value.Color opacify(Value.Color color, double amount) {
        if (amount < 0.0 || amount > 1.0) {
            throw new IllegalArgumentException("amount");
        }
        return color.toBuilder().setAlpha(SassColor.normalize1(color.getAlpha() + amount)).build();
    }

    public static int red(Value.Color color) {
        return (int)ColorUtil.toRgbColor(color).getChannel1();
    }

    public static Value.Color saturate(Value.Color color, double amount) {
        color = ColorUtil.toHslColor(color);
        if (amount < 0.0 || amount > 100.0) {
            throw new IllegalArgumentException("amount");
        }
        return color.toBuilder().setChannel2(SassColor.normalize100(color.getChannel2() + amount)).build();
    }

    public static double saturation(Value.Color color) {
        return ColorUtil.toHslColor(color).getChannel2();
    }

    public static Value.Color transparentize(Value.Color color, double amount) {
        if (amount < 0.0 || amount > 1.0) {
            throw new IllegalArgumentException("amount");
        }
        return color.toBuilder().setAlpha(SassColor.normalize1(color.getAlpha() - amount)).build();
    }

    public static double whiteness(Value.Color color) {
        return ColorUtil.toHwbColor(color).getChannel2();
    }

    static double normalizeHue(double hue) {
        if ((hue %= 360.0) < 0.0) {
            hue += 360.0;
        }
        return hue;
    }

    static double normalize1(double number) {
        if (number < 0.0) {
            return 0.0;
        }
        if (number > 1.0) {
            return 1.0;
        }
        return number;
    }

    static double normalize100(double number) {
        if (number < 0.0) {
            return 0.0;
        }
        if (number > 100.0) {
            return 100.0;
        }
        return number;
    }

    @Generated
    private SassColor() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

