/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.functions;

import com.sass_lang.embedded_protocol.Value;
import de.larsgrefer.sass.embedded.functions.ConversionService;
import de.larsgrefer.sass.embedded.functions.HostFunction;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;

class FunctionHostFunction<T>
extends HostFunction {
    private static final List<HostFunction.Argument> args = Collections.singletonList(new HostFunction.Argument("arg0", null));
    private final Function<T, ?> lambda;
    private final Class<T> argType;

    protected FunctionHostFunction(String name, Class<T> argType, Function<T, ?> lambda) {
        super(name, args);
        this.lambda = lambda;
        this.argType = argType;
    }

    @Override
    @Nonnull
    public Value invoke(List<Value> arguments) {
        if (arguments.size() != 1) {
            throw new IllegalArgumentException("Invalid argument count: Expected 1 instead of " + arguments.size());
        }
        T arg0 = ConversionService.toJavaValue(arguments.get(0), this.argType, this.argType);
        Object call = this.lambda.apply(arg0);
        return ConversionService.toSassValue(call);
    }
}

