/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.functions;

import com.sass_lang.embedded_protocol.SingletonValue;
import com.sass_lang.embedded_protocol.Value;
import de.larsgrefer.sass.embedded.util.ProtocolUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;

final class ConversionService {
    @Nonnull
    static Value toSassValue(@Nullable Object object) {
        if (object == null) {
            return ProtocolUtil.value(SingletonValue.NULL);
        }
        if (object instanceof Boolean) {
            return ProtocolUtil.value((Boolean)object != false ? SingletonValue.TRUE : SingletonValue.FALSE);
        }
        if (object instanceof CharSequence) {
            Value.String sassString = Value.String.newBuilder().setQuoted(true).setText(object.toString()).build();
            return ProtocolUtil.value(sassString);
        }
        if (object instanceof Number) {
            Value.Number sassNumber = Value.Number.newBuilder().setValue(((Number)object).doubleValue()).build();
            return ProtocolUtil.value(sassNumber);
        }
        if (object instanceof Collection) {
            List<Value> sassValues = ((Collection)object).stream().map(ConversionService::toSassValue).collect(Collectors.toList());
            return ProtocolUtil.value(ProtocolUtil.list(sassValues));
        }
        if (object instanceof Map) {
            List<Value.Map.Entry> sassEntries = ((Map)object).entrySet().stream().map(entry -> Value.Map.Entry.newBuilder().setKey(ConversionService.toSassValue(entry.getKey())).setValue(ConversionService.toSassValue(entry.getValue())).build()).collect(Collectors.toList());
            return ProtocolUtil.value(ProtocolUtil.map(sassEntries));
        }
        if (object instanceof Value) {
            return (Value)object;
        }
        if (object instanceof Value.String) {
            return ProtocolUtil.value((Value.String)object);
        }
        if (object instanceof Value.Number) {
            return ProtocolUtil.value((Value.Number)object);
        }
        if (object instanceof Value.Color) {
            return ProtocolUtil.value((Value.Color)object);
        }
        if (object instanceof Value.List) {
            return ProtocolUtil.value((Value.List)object);
        }
        if (object instanceof Value.Map) {
            return ProtocolUtil.value((Value.Map)object);
        }
        if (object instanceof SingletonValue) {
            return ProtocolUtil.value((SingletonValue)object);
        }
        if (object instanceof Value.CompilerFunction) {
            return ProtocolUtil.value((Value.CompilerFunction)object);
        }
        if (object instanceof Value.HostFunction) {
            return ProtocolUtil.value((Value.HostFunction)object);
        }
        if (object instanceof Value.ArgumentList) {
            return ProtocolUtil.value((Value.ArgumentList)object);
        }
        if (object instanceof Value.Calculation) {
            return ProtocolUtil.value((Value.Calculation)object);
        }
        throw new RuntimeException("Cant convert to Sass value");
    }

    @Nullable
    static <T> T toJavaValue(@NonNull Value value, Class<T> targetType, Type parameterizedType) {
        if (value == null) {
            throw new IllegalArgumentException("value is marked non-null but is null");
        }
        if (targetType.equals(Value.class)) {
            return (T)value;
        }
        switch (value.getValueCase()) {
            case STRING: {
                Value.String sassString = value.getString();
                if (targetType.isAssignableFrom(Value.String.class)) {
                    return (T)sassString;
                }
                if (targetType.isAssignableFrom(String.class)) {
                    return (T)sassString.getText();
                }
                throw new IllegalArgumentException("Cant convert sass String to " + targetType);
            }
            case NUMBER: {
                Value.Number sassNumber = value.getNumber();
                double javaNumber = sassNumber.getValue();
                if (targetType.isAssignableFrom(Value.Number.class)) {
                    return (T)sassNumber;
                }
                if (targetType.isAssignableFrom(Double.class) || targetType.isAssignableFrom(Double.TYPE)) {
                    return (T)Double.valueOf(javaNumber);
                }
                if (targetType.isAssignableFrom(Float.class) || targetType.isAssignableFrom(Float.TYPE)) {
                    return (T)Float.valueOf((float)javaNumber);
                }
                if (targetType.isAssignableFrom(Long.class) || targetType.isAssignableFrom(Long.TYPE)) {
                    return (T)Long.valueOf((long)javaNumber);
                }
                if (targetType.isAssignableFrom(Integer.class) || targetType.isAssignableFrom(Integer.TYPE)) {
                    return (T)Integer.valueOf((int)javaNumber);
                }
                if (targetType.isAssignableFrom(Short.class) || targetType.isAssignableFrom(Short.TYPE)) {
                    return (T)Short.valueOf((short)javaNumber);
                }
                if (targetType.isAssignableFrom(Byte.class) || targetType.isAssignableFrom(Byte.TYPE)) {
                    return (T)Byte.valueOf((byte)javaNumber);
                }
                if (targetType.isAssignableFrom(BigInteger.class)) {
                    return (T)BigInteger.valueOf((long)javaNumber);
                }
                if (targetType.isAssignableFrom(BigDecimal.class)) {
                    return (T)BigDecimal.valueOf(javaNumber);
                }
                if (targetType.isAssignableFrom(String.class)) {
                    return (T)Double.toString(javaNumber);
                }
                throw new IllegalArgumentException("Cant convert sass Number to " + targetType);
            }
            case COLOR: {
                Value.Color color = value.getColor();
                if (targetType.isAssignableFrom(Value.Color.class)) {
                    return (T)color;
                }
                throw new IllegalArgumentException("Cant convert sass RgbColor to " + targetType);
            }
            case LIST: {
                Value.List sassList = value.getList();
                if (targetType.isAssignableFrom(Value.List.class)) {
                    return (T)sassList;
                }
                if (targetType.isAssignableFrom(List.class)) {
                    Type elementType = ((ParameterizedType)parameterizedType).getActualTypeArguments()[0];
                    Class elementClass = elementType instanceof Class ? (Class)elementType : (Class)((ParameterizedType)elementType).getRawType();
                    List collect = sassList.getContentsList().stream().map(elementValue -> ConversionService.toJavaValue(elementValue, elementClass, elementType)).collect(Collectors.toList());
                    return (T)Collections.unmodifiableList(collect);
                }
                throw new IllegalArgumentException("Cant convert sass List to " + targetType);
            }
            case MAP: {
                Value.Map sassMap = value.getMap();
                if (targetType.isAssignableFrom(Value.Map.class)) {
                    return (T)sassMap;
                }
                if (targetType.isAssignableFrom(Map.class)) {
                    Type keyType = ((ParameterizedType)parameterizedType).getActualTypeArguments()[0];
                    Type valueType = ((ParameterizedType)parameterizedType).getActualTypeArguments()[1];
                    Class keyClass = keyType instanceof Class ? (Class)keyType : (Class)((ParameterizedType)keyType).getRawType();
                    Class valueClass = valueType instanceof Class ? (Class)valueType : (Class)((ParameterizedType)valueType).getRawType();
                    Map<Object, Object> collect = sassMap.getEntriesList().stream().collect(Collectors.toMap(sassEntry -> ConversionService.toJavaValue(sassEntry.getKey(), keyClass, keyType), sassEntry -> ConversionService.toJavaValue(sassEntry.getValue(), valueClass, valueType)));
                    return (T)Collections.unmodifiableMap(collect);
                }
                throw new IllegalArgumentException("Cant convert sass Map to " + targetType);
            }
            case SINGLETON: {
                SingletonValue singleton = value.getSingleton();
                switch (value.getSingleton()) {
                    case TRUE: 
                    case FALSE: {
                        Boolean boolValue = singleton == SingletonValue.TRUE;
                        if (targetType.equals(Boolean.class) || targetType.equals(Boolean.TYPE)) {
                            return (T)boolValue;
                        }
                        if (targetType.equals(String.class)) {
                            return (T)Boolean.toString(boolValue);
                        }
                        throw new IllegalArgumentException("Cant convert sass boolean to " + targetType);
                    }
                    case NULL: {
                        if (targetType.equals(SingletonValue.class)) {
                            return (T)SingletonValue.NULL;
                        }
                        return null;
                    }
                    case UNRECOGNIZED: {
                        throw new IllegalArgumentException("Unknown sass singleton: " + value.getSingleton());
                    }
                }
                throw new IllegalStateException("Unknown sass singleton: " + value.getSingleton());
            }
            case CALCULATION: {
                Value.Calculation calculation = value.getCalculation();
                if (targetType.isAssignableFrom(Value.Calculation.class)) {
                    return (T)calculation;
                }
                throw new IllegalArgumentException("Cant convert sass Calculation to " + targetType);
            }
            case COMPILER_FUNCTION: {
                Value.CompilerFunction compilerFunction = value.getCompilerFunction();
                if (targetType.isAssignableFrom(Value.CompilerFunction.class)) {
                    return (T)compilerFunction;
                }
                throw new IllegalArgumentException("Cant convert sass CompilerFunction to " + targetType);
            }
            case HOST_FUNCTION: {
                Value.HostFunction hostFunction = value.getHostFunction();
                if (targetType.isAssignableFrom(Value.HostFunction.class)) {
                    return (T)hostFunction;
                }
                throw new IllegalArgumentException("Cant convert sass HostFunction to " + targetType);
            }
            case VALUE_NOT_SET: {
                return null;
            }
        }
        throw new IllegalStateException("Unknown value: " + value.getValueCase());
    }

    @Generated
    private ConversionService() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

