/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded;

import com.google.protobuf.ByteString;
import com.sass_lang.embedded_protocol.InboundMessage;
import com.sass_lang.embedded_protocol.OutboundMessage;
import com.sass_lang.embedded_protocol.OutputStyle;
import com.sass_lang.embedded_protocol.Syntax;
import com.sass_lang.embedded_protocol.Value;
import de.larsgrefer.sass.embedded.CompileSuccess;
import de.larsgrefer.sass.embedded.SassCompilationFailedException;
import de.larsgrefer.sass.embedded.SassProtocolErrorException;
import de.larsgrefer.sass.embedded.connection.CompilerConnection;
import de.larsgrefer.sass.embedded.connection.Packet;
import de.larsgrefer.sass.embedded.functions.HostFunction;
import de.larsgrefer.sass.embedded.importer.CustomImporter;
import de.larsgrefer.sass.embedded.importer.FileImporter;
import de.larsgrefer.sass.embedded.importer.Importer;
import de.larsgrefer.sass.embedded.importer.RelativeUrlImporter;
import de.larsgrefer.sass.embedded.logging.LoggingHandler;
import de.larsgrefer.sass.embedded.logging.Slf4jLoggingHandler;
import de.larsgrefer.sass.embedded.util.ProtocolUtil;
import de.larsgrefer.sass.embedded.util.SyntaxUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import lombok.Generated;
import lombok.NonNull;
import org.intellij.lang.annotations.Language;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SassCompiler
implements Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SassCompiler.class);
    private OutputStyle outputStyle = OutputStyle.EXPANDED;
    private boolean generateSourceMaps = false;
    private boolean alertColor = false;
    private boolean alertAscii = false;
    private boolean verbose = false;
    private boolean quietDeps = false;
    private boolean sourceMapIncludeSources = false;
    private boolean emitCharset = false;
    private boolean silent = false;
    private final List<String> fatalDeprecations = new ArrayList<String>();
    private final List<String> futureDeprecations = new ArrayList<String>();
    private final List<String> silenceDeprecations = new ArrayList<String>();
    private final CompilerConnection connection;
    private final Random compileRequestIds = new Random();
    private final Map<String, HostFunction> globalFunctions = new HashMap<String, HostFunction>();
    private final Map<Integer, FileImporter> fileImporters = new HashMap<Integer, FileImporter>();
    private final Map<Integer, CustomImporter> customImporters = new HashMap<Integer, CustomImporter>();
    private LoggingHandler loggingHandler = new Slf4jLoggingHandler(log);
    private List<File> loadPaths = new LinkedList<File>();

    public SassCompiler(CompilerConnection connection) {
        this.connection = connection;
    }

    public OutboundMessage.VersionResponse getVersion() throws IOException {
        return this.exec(ProtocolUtil.inboundMessage(InboundMessage.VersionRequest.getDefaultInstance())).getVersionResponse();
    }

    public void addFatalDeprecation(@NonNull String deprecationId) {
        if (deprecationId == null) {
            throw new IllegalArgumentException("deprecationId is marked non-null but is null");
        }
        this.fatalDeprecations.add(deprecationId);
    }

    public void addFutureDeprecation(@NonNull String deprecationId) {
        if (deprecationId == null) {
            throw new IllegalArgumentException("deprecationId is marked non-null but is null");
        }
        this.futureDeprecations.add(deprecationId);
    }

    public void addSilenceDeprecation(@NonNull String deprecationId) {
        if (deprecationId == null) {
            throw new IllegalArgumentException("deprecationId is marked non-null but is null");
        }
        this.silenceDeprecations.add(deprecationId);
    }

    public void registerFunction(@NonNull HostFunction sassFunction) {
        if (sassFunction == null) {
            throw new IllegalArgumentException("sassFunction is marked non-null but is null");
        }
        this.globalFunctions.put(sassFunction.getName(), sassFunction);
    }

    public void registerImporter(@NonNull FileImporter fileImporter) {
        if (fileImporter == null) {
            throw new IllegalArgumentException("fileImporter is marked non-null but is null");
        }
        this.fileImporters.put(fileImporter.getId(), fileImporter);
    }

    public void registerImporter(@NonNull CustomImporter customImporter) {
        if (customImporter == null) {
            throw new IllegalArgumentException("customImporter is marked non-null but is null");
        }
        this.customImporters.put(customImporter.getId(), customImporter);
    }

    protected InboundMessage.CompileRequest.Builder compileRequestBuilder() {
        InboundMessage.CompileRequest.Importer importer;
        InboundMessage.CompileRequest.Builder builder = InboundMessage.CompileRequest.newBuilder();
        builder.setStyle(this.outputStyle);
        builder.setSourceMap(this.generateSourceMaps);
        for (File file : this.loadPaths) {
            importer = InboundMessage.CompileRequest.Importer.newBuilder().setPath(file.getAbsolutePath()).build();
            builder.addImporters(importer);
        }
        for (Importer importer2 : this.customImporters.values()) {
            importer = InboundMessage.CompileRequest.Importer.newBuilder().setImporterId(importer2.getId()).build();
            builder.addImporters(importer);
        }
        for (Importer importer3 : this.fileImporters.values()) {
            importer = InboundMessage.CompileRequest.Importer.newBuilder().setFileImporterId(importer3.getId()).build();
            builder.addImporters(importer);
        }
        for (HostFunction hostFunction : this.globalFunctions.values()) {
            builder.addGlobalFunctions(hostFunction.getSignature());
        }
        builder.setAlertColor(this.alertColor);
        builder.setAlertAscii(this.alertAscii);
        builder.setVerbose(this.verbose);
        builder.setQuietDeps(this.quietDeps);
        builder.setSourceMapIncludeSources(this.sourceMapIncludeSources);
        builder.setCharset(this.emitCharset);
        builder.setSilent(this.silent);
        builder.addAllFatalDeprecation(this.fatalDeprecations);
        builder.addAllFutureDeprecation(this.futureDeprecations);
        builder.addAllSilenceDeprecation(this.silenceDeprecations);
        return builder;
    }

    public CompileSuccess compile(@NonNull URL source) throws SassCompilationFailedException, IOException {
        if (source == null) {
            throw new IllegalArgumentException("source is marked non-null but is null");
        }
        return this.compile(source, this.getOutputStyle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompileSuccess compile(@NonNull URL source, OutputStyle outputStyle) throws SassCompilationFailedException, IOException {
        Syntax syntax;
        ByteString content;
        if (source == null) {
            throw new IllegalArgumentException("source is marked non-null but is null");
        }
        if (source.getProtocol().equals("file")) {
            File file = new File(source.getPath());
            return this.compileFile(file);
        }
        URLConnection urlConnection = source.openConnection();
        try (InputStream in = urlConnection.getInputStream();){
            content = ByteString.readFrom((InputStream)in);
            syntax = SyntaxUtil.guessSyntax(urlConnection);
        }
        CustomImporter importer = new RelativeUrlImporter(source).autoCanonicalize();
        this.customImporters.put(importer.getId(), importer);
        InboundMessage.CompileRequest.StringInput build = InboundMessage.CompileRequest.StringInput.newBuilder().setUrl(source.toString()).setSourceBytes(content).setImporter(InboundMessage.CompileRequest.Importer.newBuilder().setImporterId(importer.getId()).build()).setSyntax(syntax).build();
        try {
            CompileSuccess compileSuccess = this.compileString(build, outputStyle);
            return compileSuccess;
        }
        finally {
            this.customImporters.remove(importer.getId());
        }
    }

    public CompileSuccess compileScssString(@NonNull @Language(value="SCSS") String source) throws IOException, SassCompilationFailedException {
        if (source == null) {
            throw new IllegalArgumentException("source is marked non-null but is null");
        }
        return this.compileString(source, Syntax.SCSS);
    }

    public CompileSuccess compileSassString(@NonNull @Language(value="SASS") String source) throws IOException, SassCompilationFailedException {
        if (source == null) {
            throw new IllegalArgumentException("source is marked non-null but is null");
        }
        return this.compileString(source, Syntax.INDENTED);
    }

    public CompileSuccess compileCssString(@NonNull @Language(value="CSS") String source) throws IOException, SassCompilationFailedException {
        if (source == null) {
            throw new IllegalArgumentException("source is marked non-null but is null");
        }
        return this.compileString(source, Syntax.CSS);
    }

    public CompileSuccess compileString(String source, Syntax syntax) throws SassCompilationFailedException, IOException {
        return this.compileString(source, syntax, this.getOutputStyle());
    }

    public CompileSuccess compileString(@NonNull String source, Syntax syntax, OutputStyle outputStyle) throws IOException, SassCompilationFailedException {
        if (source == null) {
            throw new IllegalArgumentException("source is marked non-null but is null");
        }
        InboundMessage.CompileRequest.StringInput stringInput = InboundMessage.CompileRequest.StringInput.newBuilder().setSource(source).setSyntax(syntax).build();
        return this.compileString(stringInput, outputStyle);
    }

    @Nonnull
    public CompileSuccess compileString(InboundMessage.CompileRequest.StringInput string, @NonNull OutputStyle outputStyle) throws IOException, SassCompilationFailedException {
        if (outputStyle == null) {
            throw new IllegalArgumentException("outputStyle is marked non-null but is null");
        }
        InboundMessage.CompileRequest compileRequest = this.compileRequestBuilder().setString(string).setStyle(outputStyle).build();
        return this.execCompileRequest(compileRequest);
    }

    public CompileSuccess compileFile(@NonNull File inputFile) throws IOException, SassCompilationFailedException {
        if (inputFile == null) {
            throw new IllegalArgumentException("inputFile is marked non-null but is null");
        }
        return this.compileFile(inputFile, this.getOutputStyle());
    }

    public CompileSuccess compileFile(@NonNull File file, @NonNull OutputStyle outputStyle) throws IOException, SassCompilationFailedException {
        if (file == null) {
            throw new IllegalArgumentException("file is marked non-null but is null");
        }
        if (outputStyle == null) {
            throw new IllegalArgumentException("outputStyle is marked non-null but is null");
        }
        InboundMessage.CompileRequest compileRequest = this.compileRequestBuilder().setPath(file.getPath()).setStyle(outputStyle).build();
        return this.execCompileRequest(compileRequest);
    }

    private CompileSuccess execCompileRequest(InboundMessage.CompileRequest compileRequest) throws IOException, SassCompilationFailedException {
        OutboundMessage outboundMessage = this.exec(ProtocolUtil.inboundMessage(compileRequest));
        if (!outboundMessage.hasCompileResponse()) {
            throw new IllegalStateException("No compile response");
        }
        OutboundMessage.CompileResponse compileResponse = outboundMessage.getCompileResponse();
        if (compileResponse.hasSuccess()) {
            return new CompileSuccess(compileResponse);
        }
        if (compileResponse.hasFailure()) {
            throw new SassCompilationFailedException(compileResponse);
        }
        throw new IllegalStateException("Neither success nor failure");
    }

    private OutboundMessage exec(InboundMessage inboundMessage) throws IOException {
        int compilationId;
        if (inboundMessage.hasVersionRequest()) {
            compilationId = 0;
        } else if (inboundMessage.hasCompileRequest()) {
            compilationId = Math.abs(this.compileRequestIds.nextInt());
        } else {
            throw new IllegalArgumentException("Invalid message type: " + inboundMessage.getMessageCase());
        }
        Packet<InboundMessage> request = new Packet<InboundMessage>(compilationId, inboundMessage);
        CompilerConnection compilerConnection = this.connection;
        synchronized (compilerConnection) {
            OutboundMessage outboundMessage;
            this.connection.sendMessage(request);
            block13: while (true) {
                Packet<OutboundMessage> response;
                if ((response = this.connection.readResponse()).getCompilationId() != compilationId) {
                    throw new IllegalStateException(String.format("Compilation ID mismatch: expected %d, but got %d", compilationId, response.getCompilationId()));
                }
                outboundMessage = response.getMessage();
                switch (outboundMessage.getMessageCase()) {
                    case ERROR: {
                        throw new SassProtocolErrorException(outboundMessage.getError());
                    }
                    case COMPILE_RESPONSE: 
                    case VERSION_RESPONSE: {
                        return outboundMessage;
                    }
                    case LOG_EVENT: {
                        this.loggingHandler.handle((OutboundMessage.LogEventOrBuilder)outboundMessage.getLogEvent());
                        continue block13;
                    }
                    case CANONICALIZE_REQUEST: {
                        this.handleCanonicalizeRequest(compilationId, outboundMessage.getCanonicalizeRequest());
                        continue block13;
                    }
                    case IMPORT_REQUEST: {
                        this.handleImportRequest(compilationId, outboundMessage.getImportRequest());
                        continue block13;
                    }
                    case FILE_IMPORT_REQUEST: {
                        this.handleFileImportRequest(compilationId, outboundMessage.getFileImportRequest());
                        continue block13;
                    }
                    case FUNCTION_CALL_REQUEST: {
                        this.handleFunctionCallRequest(compilationId, outboundMessage.getFunctionCallRequest());
                        continue block13;
                    }
                    case MESSAGE_NOT_SET: {
                        throw new IllegalStateException("No message set");
                    }
                }
                break;
            }
            throw new IllegalStateException("Unknown OutboundMessage: " + outboundMessage.getMessageCase());
        }
    }

    private void handleFileImportRequest(int compilationId, OutboundMessage.FileImportRequest fileImportRequest) throws IOException {
        InboundMessage.FileImportResponse.Builder fileImportResponse = InboundMessage.FileImportResponse.newBuilder().setId(fileImportRequest.getId());
        FileImporter fileImporter = this.fileImporters.get(fileImportRequest.getImporterId());
        try {
            File file = fileImporter.handleImport(fileImportRequest.getUrl(), fileImportRequest.getFromImport());
            if (file != null) {
                fileImportResponse.setFileUrl(file.toURI().toURL().toString());
            }
        }
        catch (Throwable t) {
            log.debug("Failed to execute FileImportRequest {}", (Object)fileImportRequest, (Object)t);
            fileImportResponse.setError(this.getErrorMessage(t));
        }
        this.connection.sendMessage(compilationId, ProtocolUtil.inboundMessage(fileImportResponse.build()));
    }

    private void handleImportRequest(int compilationId, OutboundMessage.ImportRequest importRequest) throws IOException {
        InboundMessage.ImportResponse.Builder importResponse = InboundMessage.ImportResponse.newBuilder().setId(importRequest.getId());
        CustomImporter customImporter = this.customImporters.get(importRequest.getImporterId());
        try {
            InboundMessage.ImportResponse.ImportSuccess success = customImporter.handleImport(importRequest.getUrl());
            if (success != null) {
                importResponse.setSuccess(success);
            }
        }
        catch (Throwable t) {
            log.debug("Failed to handle ImportRequest {}", (Object)importRequest, (Object)t);
            importResponse.setError(this.getErrorMessage(t));
        }
        this.connection.sendMessage(compilationId, ProtocolUtil.inboundMessage(importResponse.build()));
    }

    private void handleCanonicalizeRequest(int compilationId, OutboundMessage.CanonicalizeRequest canonicalizeRequest) throws IOException {
        InboundMessage.CanonicalizeResponse.Builder canonicalizeResponse = InboundMessage.CanonicalizeResponse.newBuilder().setId(canonicalizeRequest.getId());
        CustomImporter customImporter = this.customImporters.get(canonicalizeRequest.getImporterId());
        try {
            String canonicalize = customImporter.canonicalize(canonicalizeRequest.getUrl(), canonicalizeRequest.getFromImport());
            if (canonicalize != null) {
                log.debug("{} canonicalized to {}", (Object)canonicalizeRequest.getUrl(), (Object)canonicalize);
                canonicalizeResponse.setUrl(canonicalize);
            }
        }
        catch (Throwable e) {
            log.debug("Failed to handle CanonicalizeRequest {}", (Object)canonicalizeRequest, (Object)e);
            canonicalizeResponse.setError(this.getErrorMessage(e));
        }
        this.connection.sendMessage(compilationId, ProtocolUtil.inboundMessage(canonicalizeResponse.build()));
    }

    private void handleFunctionCallRequest(int compilationId, OutboundMessage.FunctionCallRequest functionCallRequest) throws IOException {
        InboundMessage.FunctionCallResponse.Builder response = InboundMessage.FunctionCallResponse.newBuilder().setId(functionCallRequest.getId());
        HostFunction sassFunction = null;
        try {
            switch (functionCallRequest.getIdentifierCase()) {
                case NAME: {
                    sassFunction = this.globalFunctions.get(functionCallRequest.getName());
                    break;
                }
                case FUNCTION_ID: {
                    throw new UnsupportedOperationException("Calling functions by ID is not supported");
                }
                case IDENTIFIER_NOT_SET: {
                    throw new IllegalArgumentException("FunctionCallRequest has no identifier");
                }
            }
            List argumentsList = functionCallRequest.getArgumentsList();
            Value result = sassFunction.invoke(argumentsList);
            response.setSuccess(result);
        }
        catch (Throwable e) {
            log.debug("Failed to handle FunctionCallRequest for function {}", sassFunction, (Object)e);
            response.setError(this.getErrorMessage(e));
        }
        this.connection.sendMessage(compilationId, ProtocolUtil.inboundMessage(response.build()));
    }

    private String getErrorMessage(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    @Override
    public void close() throws IOException {
        this.connection.close();
    }

    @Generated
    public OutputStyle getOutputStyle() {
        return this.outputStyle;
    }

    @Generated
    public void setOutputStyle(OutputStyle outputStyle) {
        this.outputStyle = outputStyle;
    }

    @Generated
    public boolean isGenerateSourceMaps() {
        return this.generateSourceMaps;
    }

    @Generated
    public void setGenerateSourceMaps(boolean generateSourceMaps) {
        this.generateSourceMaps = generateSourceMaps;
    }

    @Generated
    public boolean isAlertColor() {
        return this.alertColor;
    }

    @Generated
    public void setAlertColor(boolean alertColor) {
        this.alertColor = alertColor;
    }

    @Generated
    public boolean isAlertAscii() {
        return this.alertAscii;
    }

    @Generated
    public void setAlertAscii(boolean alertAscii) {
        this.alertAscii = alertAscii;
    }

    @Generated
    public boolean isVerbose() {
        return this.verbose;
    }

    @Generated
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Generated
    public boolean isQuietDeps() {
        return this.quietDeps;
    }

    @Generated
    public void setQuietDeps(boolean quietDeps) {
        this.quietDeps = quietDeps;
    }

    @Generated
    public boolean isSourceMapIncludeSources() {
        return this.sourceMapIncludeSources;
    }

    @Generated
    public void setSourceMapIncludeSources(boolean sourceMapIncludeSources) {
        this.sourceMapIncludeSources = sourceMapIncludeSources;
    }

    @Generated
    public boolean isEmitCharset() {
        return this.emitCharset;
    }

    @Generated
    public void setEmitCharset(boolean emitCharset) {
        this.emitCharset = emitCharset;
    }

    @Generated
    public boolean isSilent() {
        return this.silent;
    }

    @Generated
    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    @Generated
    public void setLoggingHandler(LoggingHandler loggingHandler) {
        this.loggingHandler = loggingHandler;
    }

    @Generated
    public LoggingHandler getLoggingHandler() {
        return this.loggingHandler;
    }

    @Generated
    public List<File> getLoadPaths() {
        return this.loadPaths;
    }

    @Generated
    public void setLoadPaths(List<File> loadPaths) {
        this.loadPaths = loadPaths;
    }
}

