/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.util;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PlatformUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlatformUtils.class);

    public static boolean isAndroid() {
        return "Dalvik".equalsIgnoreCase(System.getProperty("java.vm.name"));
    }

    public static String getDartSassPackageSuffix() {
        String classifier;
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("os.arch").toLowerCase();
        String archiveExtension = "tar.gz";
        if (osName.contains("mac")) {
            classifier = osArch.equals("aarch64") || osArch.contains("arm") || PlatformUtils.isRunningOnRosetta2() ? "macos-arm64" : "macos-x64";
        } else if (osName.contains("win")) {
            archiveExtension = "zip";
            classifier = osArch.contains("64") ? "windows-x64" : "windows-ia32";
        } else {
            classifier = osArch.equals("aarch64") || osArch.equals("arm64") ? "linux-arm64" : (osArch.contains("arm") ? "linux-arm" : (osArch.contains("risc") ? "linux-riscv64" : (osArch.contains("64") ? "linux-x64" : "linux-ia32")));
            if (PlatformUtils.isMuslLibC()) {
                classifier = classifier + "-musl";
            }
        }
        return classifier + '.' + archiveExtension;
    }

    public static boolean isRunningOnRosetta2() {
        try {
            String stdOut;
            Process sysctl = Runtime.getRuntime().exec("sysctl -in sysctl.proc_translated");
            try (InputStream in = sysctl.getInputStream();){
                byte[] buffer = new byte[16];
                int read = in.read(buffer);
                stdOut = read > 0 ? new String(buffer, 0, read, StandardCharsets.UTF_8) : "";
            }
            int exitValue = sysctl.waitFor();
            if (exitValue == 0 && stdOut.equals("1\n")) {
                return true;
            }
        }
        catch (Exception e) {
            log.info("Unable to check for rosetta", (Throwable)e);
        }
        return false;
    }

    public static boolean isMuslLibC() {
        try {
            String stdErr;
            String stdOut;
            Process sysctl = Runtime.getRuntime().exec("ldd --version");
            try (InputStream in = sysctl.getInputStream();){
                byte[] buffer = new byte[255];
                int read = in.read(buffer);
                stdOut = read > 0 ? new String(buffer, 0, read, StandardCharsets.UTF_8) : "";
            }
            try (InputStream in = sysctl.getErrorStream();){
                byte[] buffer = new byte[255];
                int read = in.read(buffer);
                stdErr = read > 0 ? new String(buffer, 0, read, StandardCharsets.UTF_8) : "";
            }
            int exitValue = sysctl.waitFor();
            if (stdOut.toLowerCase().contains("musl") || stdErr.toLowerCase().contains("musl")) {
                return true;
            }
        }
        catch (Exception e) {
            log.info("Unable to check for musl", (Throwable)e);
        }
        return false;
    }

    @Generated
    private PlatformUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

