/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.util;

import java.util.function.Function;
import lombok.Generated;

public final class CssColorSpecUtil {
    public static double[] hslToRgb(double hue, double sat, double light) {
        if ((hue %= 360.0) < 0.0) {
            hue += 360.0;
        }
        double normalizedHue = hue;
        double scaledSaturation = sat / 100.0;
        double scaledLightness = light / 100.0;
        Function<Integer, Double> f = n -> {
            double k = ((double)n.intValue() + normalizedHue / 30.0) % 12.0;
            double a = scaledSaturation * Math.min(scaledLightness, 1.0 - scaledLightness);
            return scaledLightness - a * Math.max(-1.0, CssColorSpecUtil.min(k - 3.0, 9.0 - k, 1.0));
        };
        return new double[]{f.apply(0), f.apply(8), f.apply(4)};
    }

    public static double[] rgbToHsl(double red, double green, double blue) {
        double max = CssColorSpecUtil.max(red, green, blue);
        double min = CssColorSpecUtil.min(red, green, blue);
        double hue = 0.0;
        double sat = 0.0;
        double light = (min + max) / 2.0;
        double d = max - min;
        if (d != 0.0) {
            double d2 = sat = light == 0.0 || light == 1.0 ? 0.0 : (max - light) / Math.min(light, 1.0 - light);
            if (max == red) {
                hue = (green - blue) / d + (double)(green < blue ? 6 : 0);
            } else if (max == green) {
                hue = (blue - red) / d + 2.0;
            } else if (max == blue) {
                hue = (red - green) / d + 4.0;
            }
            hue *= 60.0;
        }
        return new double[]{hue, sat * 100.0, light * 100.0};
    }

    public static double[] hwbToRgb(double hue, double white, double black) {
        if ((white /= 100.0) + (black /= 100.0) >= 1.0) {
            double gray = white / (white + black);
            return new double[]{gray, gray, gray};
        }
        double[] rgb = CssColorSpecUtil.hslToRgb(hue, 100.0, 50.0);
        int i = 0;
        while (i < 3) {
            int n = i;
            rgb[n] = rgb[n] * (1.0 - white - black);
            int n2 = i++;
            rgb[n2] = rgb[n2] + white;
        }
        return rgb;
    }

    public static double[] rgbToHwb(double red, double green, double blue) {
        double[] hsl = CssColorSpecUtil.rgbToHsl(red, green, blue);
        double white = CssColorSpecUtil.min(red, green, blue);
        double black = 1.0 - CssColorSpecUtil.max(red, green, blue);
        return new double[]{hsl[0], white * 100.0, black * 100.0};
    }

    private static double max(double d1, double d2, double d3) {
        return Math.max(Math.max(d1, d2), d3);
    }

    private static double min(double d1, double d2, double d3) {
        return Math.min(Math.min(d1, d2), d3);
    }

    @Generated
    private CssColorSpecUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

