/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.util;

import com.sass_lang.embedded_protocol.Value;
import de.larsgrefer.sass.embedded.util.ColorValidator;
import de.larsgrefer.sass.embedded.util.CssColorSpecUtil;
import javax.annotation.Nonnull;
import lombok.Generated;

@Nonnull
public final class ColorUtil {
    public static final Value.Color white = ColorUtil.rgba(255, 255, 255, 1.0);
    public static final Value.Color black = ColorUtil.rgba(0, 0, 0, 1.0);

    public static Value.Color toRgbColor(Value.Color color) {
        if ("rgb".equals(color.getSpace())) {
            return color;
        }
        if ("hwb".equals(color.getSpace())) {
            return ColorUtil.toRgbColorFromHwb((Value.ColorOrBuilder)color);
        }
        if ("hsl".equals(color.getSpace())) {
            return ColorUtil.toRgbColorFromHsl((Value.ColorOrBuilder)color);
        }
        throw new IllegalArgumentException("Unsupported color space: " + color.getSpace());
    }

    public static Value.Color toRgbColorFromHwb(Value.ColorOrBuilder hwbColor) {
        if (!"hwb".equals(hwbColor.getSpace())) {
            throw new IllegalArgumentException("HWB color should be hwb");
        }
        ColorValidator.assertValid(hwbColor);
        double[] rgb = CssColorSpecUtil.hwbToRgb(hwbColor.getChannel1(), hwbColor.getChannel2(), hwbColor.getChannel3());
        return Value.Color.newBuilder().setSpace("rgb").setChannel1((double)((int)Math.round(rgb[0] * 255.0))).setChannel2((double)((int)Math.round(rgb[1] * 255.0))).setChannel3((double)((int)Math.round(rgb[2] * 255.0))).setAlpha(hwbColor.getAlpha()).build();
    }

    public static Value.Color toRgbColorFromHsl(Value.ColorOrBuilder hslColor) {
        if (!"hsl".equals(hslColor.getSpace())) {
            throw new IllegalArgumentException("HSL color should be hsl");
        }
        ColorValidator.assertValid(hslColor);
        double[] rgb = CssColorSpecUtil.hslToRgb((int)hslColor.getChannel1(), hslColor.getChannel2(), hslColor.getChannel3());
        return Value.Color.newBuilder().setSpace("rgb").setChannel1((double)((int)Math.round(rgb[0] * 255.0))).setChannel2((double)((int)Math.round(rgb[1] * 255.0))).setChannel3((double)((int)Math.round(rgb[2] * 255.0))).setAlpha(hslColor.getAlpha()).build();
    }

    public static Value.Color toHslColor(Value.Color color) {
        if ("hsl".equals(color.getSpace())) {
            return color;
        }
        if ("hwb".equals(color.getSpace())) {
            color = ColorUtil.toRgbColor(color);
        }
        if (!"rgb".equals(color.getSpace())) {
            throw new IllegalArgumentException("color space is not supported: " + color.getSpace());
        }
        ColorValidator.assertValid((Value.ColorOrBuilder)color);
        double red = color.getChannel1() / 255.0;
        double green = color.getChannel2() / 255.0;
        double blue = color.getChannel3() / 255.0;
        double[] hsl = CssColorSpecUtil.rgbToHsl(red, green, blue);
        return Value.Color.newBuilder().setSpace("hsl").setChannel1(hsl[0]).setChannel2(hsl[1]).setChannel3(hsl[2]).setAlpha(color.getAlpha()).build();
    }

    public static Value.Color toHwbColor(Value.Color color) {
        if ("hwb".equals(color.getSpace())) {
            return color;
        }
        if ("hsl".equals(color.getSpace())) {
            color = ColorUtil.toRgbColorFromHsl((Value.ColorOrBuilder)color);
        }
        if (!"rgb".equals(color.getSpace())) {
            throw new IllegalArgumentException("color space is not supported: " + color.getSpace());
        }
        ColorValidator.assertValid((Value.ColorOrBuilder)color);
        double red = color.getChannel1() / 255.0;
        double green = color.getChannel2() / 255.0;
        double blue = color.getChannel3() / 255.0;
        double[] hwb = CssColorSpecUtil.rgbToHwb(red, green, blue);
        return Value.Color.newBuilder().setSpace("hwb").setChannel1(hwb[0]).setChannel2(hwb[1]).setChannel3(hwb[2]).setAlpha(color.getAlpha()).build();
    }

    public static Value.Color rgb(int rgb) {
        return ColorUtil.rgba(rgb, 1.0);
    }

    public static Value.Color rgba(int rgb, double alpha) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb >> 0 & 0xFF;
        return ColorUtil.rgba(r, g, b, alpha);
    }

    public static Value.Color rgba(int red, int green, int blue, double alpha) {
        return Value.Color.newBuilder().setSpace("rgb").setChannel1((double)red).setChannel2((double)green).setChannel3((double)blue).setAlpha(alpha).build();
    }

    @Generated
    private ColorUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

