/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.importer;

import de.larsgrefer.sass.embedded.importer.ClasspathImporter;
import java.io.IOException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webjars.NotFoundException;
import org.webjars.WebJarAssetLocator;

public class WebjarsImporter
extends ClasspathImporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebjarsImporter.class);
    private static final Pattern fullPathPattern = Pattern.compile("META-INF/resources/webjars/(.*?)/(.*)");
    private final WebJarAssetLocator webJarAssetLocator;

    public WebjarsImporter() {
        this(new WebJarAssetLocator());
    }

    public WebjarsImporter(WebJarAssetLocator webJarAssetLocator) {
        this(webJarAssetLocator.getClass().getClassLoader(), webJarAssetLocator);
    }

    public WebjarsImporter(ClassLoader webjarsLoader) {
        this(webjarsLoader, new WebJarAssetLocator(webjarsLoader));
    }

    public WebjarsImporter(ClassLoader webjarsLoader, WebJarAssetLocator webJarAssetLocator) {
        super(webjarsLoader);
        this.webJarAssetLocator = webJarAssetLocator;
    }

    @Override
    @Nullable
    public URL canonicalizeUrl(String url) throws IOException {
        String fullPath = null;
        Matcher matcher = fullPathPattern.matcher(url);
        if (matcher.find()) {
            String webjar = matcher.group(1);
            String subPath = matcher.group(2);
            try {
                fullPath = this.webJarAssetLocator.getFullPath(webjar, subPath);
            }
            catch (NotFoundException e) {
                log.debug("Path {} not found in webjar {}", (Object)subPath, (Object)webjar);
                log.trace(e.getLocalizedMessage(), (Throwable)e);
            }
        } else {
            try {
                fullPath = this.webJarAssetLocator.getFullPath(url);
            }
            catch (NotFoundException e) {
                log.debug("Path {} not found in webjars", (Object)url);
                log.trace(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (fullPath == null) {
            return null;
        }
        return super.canonicalizeUrl(fullPath);
    }
}

