/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.connection;

import androidx.annotation.RequiresApi;
import de.larsgrefer.sass.embedded.connection.StreamConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public class ProcessConnection
extends StreamConnection {
    private final Process process;

    @RequiresApi(value=26)
    public ProcessConnection(ProcessBuilder processBuilder) throws IOException {
        this(processBuilder.redirectInput(ProcessBuilder.Redirect.PIPE).redirectOutput(ProcessBuilder.Redirect.PIPE).redirectError(ProcessBuilder.Redirect.INHERIT).start());
    }

    @Override
    public void close() {
        this.process.destroy();
        try {
            if (!this.process.waitFor(2L, TimeUnit.SECONDS)) {
                this.process.destroyForcibly();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        this.assertAlive();
        return this.process.getInputStream();
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        this.assertAlive();
        return this.process.getOutputStream();
    }

    private void assertAlive() throws IOException {
        try {
            int exitValue = this.process.exitValue();
            throw new IOException("Process is dead. Exit code was: " + exitValue);
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return;
        }
    }

    @Generated
    public ProcessConnection(Process process) {
        this.process = process;
    }
}

