/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.connection;

import androidx.annotation.RequiresApi;
import com.google.protobuf.ByteString;
import de.larsgrefer.sass.embedded.connection.BundledPackageProvider;
import de.larsgrefer.sass.embedded.connection.DartSassPackageProvider;
import de.larsgrefer.sass.embedded.connection.DownloadingPackageProvider;
import de.larsgrefer.sass.embedded.connection.ProcessConnection;
import de.larsgrefer.sass.embedded.util.PropertyUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresApi(value=1000)
public final class ConnectionFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConnectionFactory.class);
    private static BundledPackageProvider bundledPackageProvider = new BundledPackageProvider();
    private static DownloadingPackageProvider downloadingPackageProvider = new DownloadingPackageProvider();
    private static final Pattern protocolVersionPattern = Pattern.compile("\"protocolVersion\": \"(.*?)\"");

    public static ProcessConnection bundled() throws IOException {
        return ConnectionFactory.fromPackageProvider(bundledPackageProvider);
    }

    public static ProcessConnection downloaded() throws IOException {
        return ConnectionFactory.fromPackageProvider(downloadingPackageProvider);
    }

    public static ProcessConnection fromPackageProvider(DartSassPackageProvider dartSassPackageProvider) throws IOException {
        File executable;
        try {
            executable = dartSassPackageProvider.getDartSassExecutable();
        }
        catch (IOException | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return ConnectionFactory.ofExecutable(executable);
    }

    public static ProcessConnection ofExecutable(File executable) throws IOException {
        if (executable == null) {
            throw new IllegalArgumentException("executable must not be null");
        }
        if (!executable.isFile()) {
            throw new IllegalArgumentException(executable + " is not a file");
        }
        ArrayList<String> cmd = new ArrayList<String>();
        if (executable.getName().equals("sass.bat") && System.getProperty("os.name").toLowerCase().contains("win")) {
            File dir = executable.getParentFile();
            File dartExe = new File(dir, "src/dart.exe");
            File sassSnapshot = new File(dir, "src/sass.snapshot");
            if (dartExe.isFile() && dartExe.canExecute() && sassSnapshot.isFile()) {
                cmd.add(dartExe.getAbsolutePath());
                cmd.add(sassSnapshot.getAbsolutePath());
            }
        } else if (executable.length() < 1024L) {
            File dir = executable.getParentFile();
            File dart = new File(dir, "src/dart");
            File sassSnapshot = new File(dir, "src/sass.snapshot");
            if (dart.isFile() && dart.canExecute() && sassSnapshot.isFile()) {
                cmd.add(dart.getAbsolutePath());
                cmd.add(sassSnapshot.getAbsolutePath());
            }
        }
        if (cmd.isEmpty()) {
            if (!executable.canExecute()) {
                throw new IllegalArgumentException(executable + " can not be executed");
            }
            cmd.add(executable.getAbsolutePath());
        }
        cmd.add("--embedded");
        return ConnectionFactory.ofExecutable(cmd);
    }

    public static ProcessConnection ofExecutable(List<String> executable) throws IOException {
        String protocolVersion;
        String expectedProtocolVersion = ConnectionFactory.getExpectedProtocolVersion();
        if (!expectedProtocolVersion.equalsIgnoreCase(protocolVersion = ConnectionFactory.findProtocolVersion(executable))) {
            log.warn("This Host uses protocolVersion {} but {} provides {}", new Object[]{expectedProtocolVersion, executable, protocolVersion});
        }
        ProcessBuilder processBuilder = new ProcessBuilder(executable);
        return new ProcessConnection(processBuilder);
    }

    public static String getExpectedProtocolVersion() {
        return PropertyUtils.getEmbeddedProtocolVersion();
    }

    static String findProtocolVersion(List<String> executable) throws IOException {
        String stdOut;
        ArrayList<String> command = new ArrayList<String>(executable);
        command.add("--version");
        Process testProcess = new ProcessBuilder(command).redirectOutput(ProcessBuilder.Redirect.PIPE).start();
        try (InputStream in = testProcess.getInputStream();){
            stdOut = ByteString.readFrom((InputStream)in).toStringUtf8();
        }
        int exitCode = testProcess.waitFor();
        if (exitCode != 0) {
            throw new IllegalStateException(executable + " exited with " + exitCode);
        }
        Matcher matcher = protocolVersionPattern.matcher(stdOut);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new IllegalStateException("Can't find protocolVersion in " + stdOut);
    }

    @Generated
    private ConnectionFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

