/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.connection;

import com.google.protobuf.ByteString;
import com.sass_lang.embedded_protocol.OutboundMessage;
import de.larsgrefer.sass.embedded.connection.ProcessConnection;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectionFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConnectionFactory.class);
    private static final Pattern protocolVersionPattern = Pattern.compile("\"protocolVersion\": \"(.*?)\"");

    public static ProcessConnection bundled() throws IOException {
        File bundledExecutable;
        Callable bundledExecCallable;
        try {
            Class<?> bundledFactoryClass = Class.forName("de.larsgrefer.sass.embedded.bundled.BundledCompilerFactory");
            bundledExecCallable = (Callable)bundledFactoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Embedded Compilers are not available", e);
        }
        catch (ReflectiveOperationException e) {
            throw new IOException(e);
        }
        try {
            bundledExecutable = ((File)bundledExecCallable.call()).getAbsoluteFile();
        }
        catch (IOException | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return ConnectionFactory.ofExecutable(bundledExecutable);
    }

    public static ProcessConnection ofExecutable(File executable) throws IOException {
        String protocolVersion;
        if (executable == null || !executable.isFile()) {
            throw new IllegalArgumentException("executable is not a file");
        }
        if (!executable.canExecute()) {
            throw new IllegalArgumentException(executable + " can not be executed");
        }
        String expectedProtocolVersion = ConnectionFactory.getExpectedProtocolVersion();
        if (!expectedProtocolVersion.equalsIgnoreCase(protocolVersion = ConnectionFactory.findProtocolVersion(executable))) {
            log.warn("This Host uses protocolVersion {} but {} provides {}", new Object[]{expectedProtocolVersion, executable, protocolVersion});
        }
        ProcessBuilder processBuilder = new ProcessBuilder(executable.getAbsolutePath(), "--embedded");
        return new ProcessConnection(processBuilder);
    }

    public static String getExpectedProtocolVersion() {
        return OutboundMessage.VersionResponse.class.getPackage().getSpecificationVersion();
    }

    static String findProtocolVersion(File executable) throws IOException {
        String stdOut;
        Process testProcess = new ProcessBuilder(executable.getAbsolutePath(), "--embedded", "--version").redirectOutput(ProcessBuilder.Redirect.PIPE).start();
        try (InputStream in = testProcess.getInputStream();){
            stdOut = ByteString.readFrom((InputStream)in).toStringUtf8();
        }
        int exitCode = testProcess.waitFor();
        if (exitCode != 0) {
            throw new IllegalStateException(executable + " exited with " + exitCode);
        }
        Matcher matcher = protocolVersionPattern.matcher(stdOut);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new IllegalStateException("Can't find protocolVersion in " + stdOut);
    }

    @Generated
    private ConnectionFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

