/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.connection;

import com.google.protobuf.ByteString;
import de.larsgrefer.sass.embedded.SassCompilerFactory;
import de.larsgrefer.sass.embedded.connection.ProcessConnection;
import de.larsgrefer.sass.embedded.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectionFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConnectionFactory.class);
    private static File bundledDartExec;

    public static ProcessConnection bundled() throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(ConnectionFactory.getBundledDartExec().getAbsolutePath(), "--embedded");
        return new ProcessConnection(processBuilder);
    }

    static File getBundledDartExec() throws IOException {
        if (bundledDartExec == null) {
            ConnectionFactory.extractBundled();
        }
        return bundledDartExec;
    }

    static synchronized void extractBundled() throws IOException {
        String resourcePath = ConnectionFactory.getBundledCompilerDistPath();
        URL dist = SassCompilerFactory.class.getResource(resourcePath);
        if (dist == null) {
            throw new IllegalStateException("Resource not found: " + resourcePath);
        }
        Path tempDirectory = Files.createTempDirectory("dart-sass", new FileAttribute[0]);
        try {
            IOUtils.extract(dist, tempDirectory);
        }
        catch (IOException e) {
            throw new IOException(String.format("Failed to extract %s into %s", dist, tempDirectory), e);
        }
        File execDir = tempDirectory.resolve("dart-sass").toFile();
        File[] execFile = execDir.listFiles(pathname -> pathname.isFile() && pathname.getName().startsWith("sass"));
        if (execFile == null || execFile.length != 1) {
            throw new IllegalStateException("No (unique) executable file found in " + execDir);
        }
        bundledDartExec = execFile[0];
        bundledDartExec.setWritable(false);
        bundledDartExec.setExecutable(true, true);
    }

    private static String getBundledCompilerDistPath() {
        String classifier;
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("os.arch").toLowerCase();
        String archiveExtension = "tar.gz";
        if (osName.contains("mac")) {
            classifier = osArch.equals("aarch64") || osArch.contains("arm") || ConnectionFactory.isRunningOnRosetta2() ? "macos-arm64" : "macos-x64";
        } else if (osName.contains("win")) {
            archiveExtension = "zip";
            classifier = osArch.contains("64") ? "windows-x64" : "windows-ia32";
        } else {
            classifier = osArch.equals("aarch64") || osArch.equals("arm64") ? "linux-arm64" : (osArch.contains("arm") ? "linux-arm" : (osArch.contains("64") ? "linux-x64" : "linux-ia32"));
        }
        return String.format("/de/larsgrefer/sass/embedded/dart-sass-%s.%s", classifier, archiveExtension);
    }

    private static boolean isRunningOnRosetta2() {
        try {
            ByteString stdOut;
            Process sysctl = Runtime.getRuntime().exec("sysctl -in sysctl.proc_translated");
            try (InputStream in = sysctl.getInputStream();){
                stdOut = ByteString.readFrom((InputStream)in);
            }
            if (sysctl.exitValue() == 0 && stdOut.toStringUtf8().equals("1\n")) {
                return true;
            }
        }
        catch (Exception e) {
            log.info("Unable to check for rosetta", (Throwable)e);
        }
        return false;
    }

    @Generated
    private ConnectionFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

