/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.util;

import de.larsgrefer.sass.embedded.util.ColorValidator;
import de.larsgrefer.sass.embedded.util.CssColorSpecUtil;
import javax.annotation.Nonnull;
import lombok.Generated;
import sass.embedded_protocol.EmbeddedSass;

@Nonnull
public final class ColorUtil {
    public static final EmbeddedSass.Value.RgbColor white = ColorUtil.rgba(255, 255, 255, 1.0);
    public static final EmbeddedSass.Value.RgbColor black = ColorUtil.rgba(0, 0, 0, 1.0);

    public static EmbeddedSass.Value.RgbColor toRgbColor(EmbeddedSass.Value.HwbColorOrBuilder hwbColor) {
        ColorValidator.assertValid(hwbColor);
        double[] rgb = CssColorSpecUtil.hwbToRgb(hwbColor.getHue(), hwbColor.getWhiteness(), hwbColor.getBlackness());
        return EmbeddedSass.Value.RgbColor.newBuilder().setRed((int)Math.round(rgb[0] * 255.0)).setGreen((int)Math.round(rgb[1] * 255.0)).setBlue((int)Math.round(rgb[2] * 255.0)).setAlpha(hwbColor.getAlpha()).build();
    }

    public static EmbeddedSass.Value.RgbColor toRgbColor(EmbeddedSass.Value.HslColorOrBuilder hslColor) {
        ColorValidator.assertValid(hslColor);
        double[] rgb = CssColorSpecUtil.hslToRgb((int)hslColor.getHue(), hslColor.getSaturation(), hslColor.getLightness());
        return EmbeddedSass.Value.RgbColor.newBuilder().setRed((int)Math.round(rgb[0] * 255.0)).setGreen((int)Math.round(rgb[1] * 255.0)).setBlue((int)Math.round(rgb[2] * 255.0)).setAlpha(hslColor.getAlpha()).build();
    }

    public static EmbeddedSass.Value.HslColor toHslColor(EmbeddedSass.Value.HwbColorOrBuilder hwbColor) {
        ColorValidator.assertValid(hwbColor);
        return ColorUtil.toHslColor((EmbeddedSass.Value.RgbColorOrBuilder)ColorUtil.toRgbColor(hwbColor));
    }

    public static EmbeddedSass.Value.HslColor toHslColor(EmbeddedSass.Value.RgbColorOrBuilder rgbColor) {
        ColorValidator.assertValid(rgbColor);
        double red = (double)rgbColor.getRed() / 255.0;
        double green = (double)rgbColor.getGreen() / 255.0;
        double blue = (double)rgbColor.getBlue() / 255.0;
        double[] hsl = CssColorSpecUtil.rgbToHsl(red, green, blue);
        return EmbeddedSass.Value.HslColor.newBuilder().setHue(hsl[0]).setSaturation(hsl[1]).setLightness(hsl[2]).setAlpha(rgbColor.getAlpha()).build();
    }

    public static EmbeddedSass.Value.HwbColor toHwbColor(EmbeddedSass.Value.HslColorOrBuilder hslColor) {
        ColorValidator.assertValid(hslColor);
        return ColorUtil.toHwbColor((EmbeddedSass.Value.RgbColorOrBuilder)ColorUtil.toRgbColor(hslColor));
    }

    public static EmbeddedSass.Value.HwbColor toHwbColor(EmbeddedSass.Value.RgbColorOrBuilder rgbColor) {
        ColorValidator.assertValid(rgbColor);
        double red = (double)rgbColor.getRed() / 255.0;
        double green = (double)rgbColor.getGreen() / 255.0;
        double blue = (double)rgbColor.getBlue() / 255.0;
        double[] hwb = CssColorSpecUtil.rgbToHwb(red, green, blue);
        return EmbeddedSass.Value.HwbColor.newBuilder().setHue(hwb[0]).setWhiteness(hwb[1]).setBlackness(hwb[2]).setAlpha(rgbColor.getAlpha()).build();
    }

    public static EmbeddedSass.Value.RgbColor rgb(int rgb) {
        return ColorUtil.rgba(rgb, 1.0);
    }

    public static EmbeddedSass.Value.RgbColor rgba(int rgb, double alpha) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb >> 0 & 0xFF;
        return ColorUtil.rgba(r, g, b, alpha);
    }

    public static EmbeddedSass.Value.RgbColor rgba(int red, int green, int blue, double alpha) {
        return EmbeddedSass.Value.RgbColor.newBuilder().setRed(red).setGreen(green).setBlue(blue).setAlpha(alpha).build();
    }

    @Generated
    private ColorUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

