/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.spring;

import com.google.protobuf.ByteString;
import de.larsgrefer.sass.embedded.util.SyntaxUtil;
import java.io.IOException;
import java.io.InputStream;
import lombok.Generated;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import sass.embedded_protocol.EmbeddedSass;

public final class SassResourceUtil {
    public static EmbeddedSass.InboundMessage.CompileRequest.StringInput toStringInput(Resource resource) throws IOException {
        Assert.notNull((Object)resource, (String)"resource must not be null");
        Assert.notNull((Object)resource.getFilename(), (String)"resource must have a filename");
        return SassResourceUtil.toStringInput(resource, SyntaxUtil.guessSyntax(resource.getFilename()));
    }

    public static EmbeddedSass.InboundMessage.CompileRequest.StringInput toStringInput(Resource resource, EmbeddedSass.Syntax syntax) throws IOException {
        Assert.notNull((Object)resource, (String)"resource must not be null");
        Assert.notNull((Object)syntax, (String)"syntax must not be null");
        ByteString byteString = SassResourceUtil.getByteString(resource);
        return EmbeddedSass.InboundMessage.CompileRequest.StringInput.newBuilder().setSourceBytes(byteString).setSyntax(syntax).build();
    }

    public static ByteString getByteString(Resource resource) throws IOException {
        if (resource instanceof ByteArrayResource) {
            return ByteString.copyFrom((byte[])((ByteArrayResource)resource).getByteArray());
        }
        try (InputStream in = resource.getInputStream();){
            ByteString byteString = ByteString.readFrom((InputStream)in);
            return byteString;
        }
    }

    @Generated
    private SassResourceUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

