/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.functions;

import de.larsgrefer.sass.embedded.util.ColorUtil;
import java.util.Locale;
import lombok.Generated;
import sass.embedded_protocol.EmbeddedSass;

public final class SassColor {
    public static EmbeddedSass.Value.RgbColor adjustHue(EmbeddedSass.Value.RgbColorOrBuilder color, double hue) {
        EmbeddedSass.Value.HslColor hslColor = ColorUtil.toHslColor(color);
        return ColorUtil.toRgbColor((EmbeddedSass.Value.HslColorOrBuilder)SassColor.adjustHue(hslColor, hue));
    }

    public static EmbeddedSass.Value.HslColor adjustHue(EmbeddedSass.Value.HslColor color, double hue) {
        double newHue = color.getHue() + hue;
        return color.toBuilder().setHue(SassColor.normalizeHue(newHue)).build();
    }

    public static EmbeddedSass.Value.HwbColor adjustHue(EmbeddedSass.Value.HwbColor color, double hue) {
        double newHue = color.getHue() + hue;
        return color.toBuilder().setHue(SassColor.normalizeHue(newHue)).build();
    }

    public static double alpha(EmbeddedSass.Value.RgbColorOrBuilder color) {
        return color.getAlpha();
    }

    public static double alpha(EmbeddedSass.Value.HslColorOrBuilder color) {
        return color.getAlpha();
    }

    public static double alpha(EmbeddedSass.Value.HwbColorOrBuilder color) {
        return color.getAlpha();
    }

    public static double blackness(EmbeddedSass.Value.RgbColorOrBuilder color) {
        return SassColor.blackness((EmbeddedSass.Value.HwbColorOrBuilder)ColorUtil.toHwbColor(color));
    }

    public static double blackness(EmbeddedSass.Value.HslColorOrBuilder color) {
        return SassColor.blackness((EmbeddedSass.Value.HwbColorOrBuilder)ColorUtil.toHwbColor(color));
    }

    public static double blackness(EmbeddedSass.Value.HwbColorOrBuilder color) {
        return color.getBlackness();
    }

    public static int blue(EmbeddedSass.Value.RgbColorOrBuilder color) {
        return color.getBlue();
    }

    public static int blue(EmbeddedSass.Value.HslColorOrBuilder color) {
        return SassColor.blue((EmbeddedSass.Value.RgbColorOrBuilder)ColorUtil.toRgbColor(color));
    }

    public static int blue(EmbeddedSass.Value.HwbColorOrBuilder color) {
        return SassColor.blue((EmbeddedSass.Value.RgbColorOrBuilder)ColorUtil.toRgbColor(color));
    }

    public static EmbeddedSass.Value.RgbColor complement(EmbeddedSass.Value.RgbColorOrBuilder color) {
        return SassColor.adjustHue(color, 180.0);
    }

    public static EmbeddedSass.Value.HslColor complement(EmbeddedSass.Value.HslColor color) {
        return SassColor.adjustHue(color, 180.0);
    }

    public static EmbeddedSass.Value.HwbColor complement(EmbeddedSass.Value.HwbColor color) {
        return SassColor.adjustHue(color, 180.0);
    }

    public static EmbeddedSass.Value.RgbColor darken(EmbeddedSass.Value.RgbColorOrBuilder color, double amount) {
        return ColorUtil.toRgbColor((EmbeddedSass.Value.HslColorOrBuilder)SassColor.darken(ColorUtil.toHslColor(color), amount));
    }

    public static EmbeddedSass.Value.HslColor darken(EmbeddedSass.Value.HslColor color, double amount) {
        double newLightness = color.getLightness() - amount;
        return color.toBuilder().setLightness(SassColor.normalize100(newLightness)).build();
    }

    public static EmbeddedSass.Value.HwbColor darken(EmbeddedSass.Value.HwbColorOrBuilder color, double amount) {
        return ColorUtil.toHwbColor((EmbeddedSass.Value.HslColorOrBuilder)SassColor.darken(ColorUtil.toHslColor(color), amount));
    }

    public static EmbeddedSass.Value.RgbColor desaturate(EmbeddedSass.Value.RgbColorOrBuilder color, double amount) {
        return ColorUtil.toRgbColor((EmbeddedSass.Value.HslColorOrBuilder)SassColor.desaturate(ColorUtil.toHslColor(color), amount));
    }

    public static EmbeddedSass.Value.HslColor desaturate(EmbeddedSass.Value.HslColor color, double amount) {
        double newSaturation = color.getSaturation() - amount;
        return color.toBuilder().setSaturation(SassColor.normalize100(newSaturation)).build();
    }

    public static EmbeddedSass.Value.HwbColor desaturate(EmbeddedSass.Value.HwbColorOrBuilder color, double amount) {
        return ColorUtil.toHwbColor((EmbeddedSass.Value.HslColorOrBuilder)SassColor.desaturate(ColorUtil.toHslColor(color), amount));
    }

    public static EmbeddedSass.Value.RgbColor grayscale(EmbeddedSass.Value.RgbColorOrBuilder color) {
        return ColorUtil.toRgbColor((EmbeddedSass.Value.HslColorOrBuilder)SassColor.grayscale(ColorUtil.toHslColor(color)));
    }

    public static EmbeddedSass.Value.HslColor grayscale(EmbeddedSass.Value.HslColor color) {
        return color.toBuilder().setSaturation(0.0).build();
    }

    public static EmbeddedSass.Value.HwbColor grayscale(EmbeddedSass.Value.HwbColorOrBuilder color) {
        return ColorUtil.toHwbColor((EmbeddedSass.Value.HslColorOrBuilder)SassColor.grayscale(ColorUtil.toHslColor(color)));
    }

    public static int green(EmbeddedSass.Value.RgbColorOrBuilder color) {
        return color.getGreen();
    }

    public static int green(EmbeddedSass.Value.HslColorOrBuilder color) {
        return SassColor.green((EmbeddedSass.Value.RgbColorOrBuilder)ColorUtil.toRgbColor(color));
    }

    public static int green(EmbeddedSass.Value.HwbColorOrBuilder color) {
        return SassColor.green((EmbeddedSass.Value.RgbColorOrBuilder)ColorUtil.toRgbColor(color));
    }

    public static double hue(EmbeddedSass.Value.RgbColorOrBuilder color) {
        return SassColor.hue((EmbeddedSass.Value.HslColorOrBuilder)ColorUtil.toHslColor(color));
    }

    public static double hue(EmbeddedSass.Value.HslColorOrBuilder color) {
        return color.getHue();
    }

    public static double hue(EmbeddedSass.Value.HwbColorOrBuilder color) {
        return color.getHue();
    }

    public static EmbeddedSass.Value.HwbColor hwb(double hue, double whiteness, double blackness) {
        return SassColor.hwb(hue, whiteness, blackness, 1.0);
    }

    public static EmbeddedSass.Value.HwbColor hwb(double hue, double whiteness, double blackness, double alpha) {
        return EmbeddedSass.Value.HwbColor.newBuilder().setHue(hue).setWhiteness(whiteness).setBlackness(blackness).setAlpha(alpha).build();
    }

    public static EmbeddedSass.Value.String ieHexStr(EmbeddedSass.Value.RgbColor rgbColor) {
        int a = (int)Math.round(rgbColor.getAlpha() * 255.0);
        int value = (a & 0xFF) << 24 | (rgbColor.getRed() & 0xFF) << 16 | (rgbColor.getGreen() & 0xFF) << 8 | (rgbColor.getBlue() & 0xFF) << 0;
        return EmbeddedSass.Value.String.newBuilder().setText("#" + Integer.toHexString(value).toUpperCase(Locale.ROOT)).setQuoted(false).build();
    }

    public static EmbeddedSass.Value.String ieHexStr(EmbeddedSass.Value.HslColor color) {
        return SassColor.ieHexStr(ColorUtil.toRgbColor((EmbeddedSass.Value.HslColorOrBuilder)color));
    }

    public static EmbeddedSass.Value.String ieHexStr(EmbeddedSass.Value.HwbColor color) {
        return SassColor.ieHexStr(ColorUtil.toRgbColor((EmbeddedSass.Value.HwbColorOrBuilder)color));
    }

    public static EmbeddedSass.Value.RgbColor invert(EmbeddedSass.Value.RgbColor color) {
        return SassColor.invert(color, 1.0);
    }

    public static EmbeddedSass.Value.HslColor invert(EmbeddedSass.Value.HslColor color) {
        return SassColor.invert(color, 1.0);
    }

    public static EmbeddedSass.Value.HwbColor invert(EmbeddedSass.Value.HwbColor color) {
        return SassColor.invert(color, 1.0);
    }

    public static EmbeddedSass.Value.RgbColor invert(EmbeddedSass.Value.RgbColor color, double weight) {
        if (weight < 0.0 || weight > 1.0) {
            throw new IllegalArgumentException("weight must be between 0 and 1");
        }
        EmbeddedSass.Value.RgbColor inverse = color.toBuilder().setRed(255 - color.getRed()).setGreen(255 - color.getGreen()).setBlue(255 - color.getBlue()).build();
        return SassColor.mix(inverse, color, weight);
    }

    public static EmbeddedSass.Value.HslColor invert(EmbeddedSass.Value.HslColor color, double weight) {
        return ColorUtil.toHslColor((EmbeddedSass.Value.RgbColorOrBuilder)SassColor.invert(ColorUtil.toRgbColor((EmbeddedSass.Value.HslColorOrBuilder)color), weight));
    }

    public static EmbeddedSass.Value.HwbColor invert(EmbeddedSass.Value.HwbColor color, double weight) {
        return ColorUtil.toHwbColor((EmbeddedSass.Value.RgbColorOrBuilder)SassColor.invert(ColorUtil.toRgbColor((EmbeddedSass.Value.HwbColorOrBuilder)color), weight));
    }

    public static EmbeddedSass.Value.RgbColor lighten(EmbeddedSass.Value.RgbColor color, double amount) {
        return ColorUtil.toRgbColor((EmbeddedSass.Value.HslColorOrBuilder)SassColor.lighten(ColorUtil.toHslColor((EmbeddedSass.Value.RgbColorOrBuilder)color), amount));
    }

    public static EmbeddedSass.Value.HslColor lighten(EmbeddedSass.Value.HslColor color, double amount) {
        if (amount < 0.0 || amount > 100.0) {
            throw new IllegalArgumentException("amount");
        }
        return color.toBuilder().setLightness(SassColor.normalize100(color.getLightness() + amount)).build();
    }

    public static EmbeddedSass.Value.HwbColor lighten(EmbeddedSass.Value.HwbColor color, double amount) {
        return ColorUtil.toHwbColor((EmbeddedSass.Value.HslColorOrBuilder)SassColor.lighten(ColorUtil.toHslColor((EmbeddedSass.Value.HwbColorOrBuilder)color), amount));
    }

    public static double lightness(EmbeddedSass.Value.RgbColor color) {
        return SassColor.lightness(ColorUtil.toHslColor((EmbeddedSass.Value.RgbColorOrBuilder)color));
    }

    public static double lightness(EmbeddedSass.Value.HslColor color) {
        return color.getLightness();
    }

    public static double lightness(EmbeddedSass.Value.HwbColor color) {
        return SassColor.lightness(ColorUtil.toHslColor((EmbeddedSass.Value.HwbColorOrBuilder)color));
    }

    public static EmbeddedSass.Value.RgbColor mix(EmbeddedSass.Value.RgbColor color1, EmbeddedSass.Value.RgbColor color2) {
        return SassColor.mix(color1, color2, 0.5);
    }

    public static EmbeddedSass.Value.HslColor mix(EmbeddedSass.Value.HslColor color1, EmbeddedSass.Value.HslColor color2) {
        return SassColor.mix(color1, color2, 0.5);
    }

    public static EmbeddedSass.Value.HwbColor mix(EmbeddedSass.Value.HwbColor color1, EmbeddedSass.Value.HwbColor color2) {
        return SassColor.mix(color1, color2, 0.5);
    }

    public static EmbeddedSass.Value.RgbColor mix(EmbeddedSass.Value.RgbColor color1, EmbeddedSass.Value.RgbColor color2, double weight) {
        if (weight <= 0.0) {
            return color2;
        }
        if (weight > 1.0) {
            return color1;
        }
        double normalizedWeight = weight * 2.0 - 1.0;
        double alphaDistance = color1.getAlpha() - color2.getAlpha();
        double combinedWeight1 = normalizedWeight * alphaDistance == -1.0 ? normalizedWeight : (normalizedWeight + alphaDistance) / (1.0 + normalizedWeight * alphaDistance);
        double weight1 = (combinedWeight1 + 1.0) / 2.0;
        double weight2 = 1.0 - weight1;
        int r = (int)Math.round((double)color1.getRed() * weight1 + (double)color2.getRed() * weight2);
        int g = (int)Math.round((double)color1.getGreen() * weight1 + (double)color2.getGreen() * weight2);
        int b = (int)Math.round((double)color1.getBlue() * weight1 + (double)color2.getBlue() * weight2);
        double a = color1.getAlpha() * weight + color2.getAlpha() * (1.0 - weight);
        return EmbeddedSass.Value.RgbColor.newBuilder().setRed(r).setGreen(g).setBlue(b).setAlpha(a).build();
    }

    public static EmbeddedSass.Value.HslColor mix(EmbeddedSass.Value.HslColor color1, EmbeddedSass.Value.HslColor color2, double weight) {
        EmbeddedSass.Value.RgbColor mix = SassColor.mix(ColorUtil.toRgbColor((EmbeddedSass.Value.HslColorOrBuilder)color1), ColorUtil.toRgbColor((EmbeddedSass.Value.HslColorOrBuilder)color2), weight);
        return ColorUtil.toHslColor((EmbeddedSass.Value.RgbColorOrBuilder)mix);
    }

    public static EmbeddedSass.Value.HwbColor mix(EmbeddedSass.Value.HwbColor color1, EmbeddedSass.Value.HwbColor color2, double weight) {
        EmbeddedSass.Value.RgbColor mix = SassColor.mix(ColorUtil.toRgbColor((EmbeddedSass.Value.HwbColorOrBuilder)color1), ColorUtil.toRgbColor((EmbeddedSass.Value.HwbColorOrBuilder)color2), weight);
        return ColorUtil.toHwbColor((EmbeddedSass.Value.RgbColorOrBuilder)mix);
    }

    public static EmbeddedSass.Value.RgbColor opacify(EmbeddedSass.Value.RgbColor color, double amount) {
        if (amount < 0.0 || amount > 1.0) {
            throw new IllegalArgumentException("amount");
        }
        return color.toBuilder().setAlpha(SassColor.normalize1(color.getAlpha() + amount)).build();
    }

    public static EmbeddedSass.Value.HslColor opacify(EmbeddedSass.Value.HslColor color, double amount) {
        if (amount < 0.0 || amount > 1.0) {
            throw new IllegalArgumentException("amount");
        }
        return color.toBuilder().setAlpha(SassColor.normalize1(color.getAlpha() + amount)).build();
    }

    public static EmbeddedSass.Value.HwbColor opacify(EmbeddedSass.Value.HwbColor color, double amount) {
        if (amount < 0.0 || amount > 1.0) {
            throw new IllegalArgumentException("amount");
        }
        return color.toBuilder().setAlpha(SassColor.normalize1(color.getAlpha() + amount)).build();
    }

    public static int red(EmbeddedSass.Value.RgbColor color) {
        return color.getRed();
    }

    public static int red(EmbeddedSass.Value.HslColor color) {
        return SassColor.red(ColorUtil.toRgbColor((EmbeddedSass.Value.HslColorOrBuilder)color));
    }

    public static int red(EmbeddedSass.Value.HwbColor color) {
        return SassColor.red(ColorUtil.toRgbColor((EmbeddedSass.Value.HwbColorOrBuilder)color));
    }

    public static EmbeddedSass.Value.RgbColor saturate(EmbeddedSass.Value.RgbColor color, double amount) {
        return ColorUtil.toRgbColor((EmbeddedSass.Value.HslColorOrBuilder)SassColor.saturate(ColorUtil.toHslColor((EmbeddedSass.Value.RgbColorOrBuilder)color), amount));
    }

    public static EmbeddedSass.Value.HslColor saturate(EmbeddedSass.Value.HslColor color, double amount) {
        if (amount < 0.0 || amount > 100.0) {
            throw new IllegalArgumentException("amount");
        }
        return color.toBuilder().setSaturation(SassColor.normalize100(color.getSaturation() + amount)).build();
    }

    public static EmbeddedSass.Value.HwbColor saturate(EmbeddedSass.Value.HwbColor color, double amount) {
        return ColorUtil.toHwbColor((EmbeddedSass.Value.HslColorOrBuilder)SassColor.saturate(ColorUtil.toHslColor((EmbeddedSass.Value.HwbColorOrBuilder)color), amount));
    }

    public static double saturation(EmbeddedSass.Value.RgbColor color) {
        return SassColor.saturation(ColorUtil.toHslColor((EmbeddedSass.Value.RgbColorOrBuilder)color));
    }

    public static double saturation(EmbeddedSass.Value.HslColor color) {
        return color.getSaturation();
    }

    public static double saturation(EmbeddedSass.Value.HwbColor color) {
        return SassColor.saturation(ColorUtil.toHslColor((EmbeddedSass.Value.HwbColorOrBuilder)color));
    }

    public static EmbeddedSass.Value.RgbColor transparentize(EmbeddedSass.Value.RgbColor color, double amount) {
        if (amount < 0.0 || amount > 1.0) {
            throw new IllegalArgumentException("amount");
        }
        return color.toBuilder().setAlpha(SassColor.normalize1(color.getAlpha() - amount)).build();
    }

    public static EmbeddedSass.Value.HslColor transparentize(EmbeddedSass.Value.HslColor color, double amount) {
        if (amount < 0.0 || amount > 1.0) {
            throw new IllegalArgumentException("amount");
        }
        return color.toBuilder().setAlpha(SassColor.normalize1(color.getAlpha() - amount)).build();
    }

    public static EmbeddedSass.Value.HwbColor transparentize(EmbeddedSass.Value.HwbColor color, double amount) {
        if (amount < 0.0 || amount > 1.0) {
            throw new IllegalArgumentException("amount");
        }
        return color.toBuilder().setAlpha(SassColor.normalize1(color.getAlpha() - amount)).build();
    }

    public static double whiteness(EmbeddedSass.Value.RgbColor color) {
        return SassColor.whiteness(ColorUtil.toHwbColor((EmbeddedSass.Value.RgbColorOrBuilder)color));
    }

    public static double whiteness(EmbeddedSass.Value.HslColor color) {
        return SassColor.whiteness(ColorUtil.toHwbColor((EmbeddedSass.Value.HslColorOrBuilder)color));
    }

    public static double whiteness(EmbeddedSass.Value.HwbColor color) {
        return color.getWhiteness();
    }

    static double normalizeHue(double hue) {
        if ((hue %= 360.0) < 0.0) {
            hue += 360.0;
        }
        return hue;
    }

    static double normalize1(double number) {
        if (number < 0.0) {
            return 0.0;
        }
        if (number > 1.0) {
            return 1.0;
        }
        return number;
    }

    static double normalize100(double number) {
        if (number < 0.0) {
            return 0.0;
        }
        if (number > 100.0) {
            return 100.0;
        }
        return number;
    }

    @Generated
    private SassColor() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

