/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.functions;

import de.larsgrefer.sass.embedded.util.ColorUtil;
import de.larsgrefer.sass.embedded.util.ProtocolUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import sass.embedded_protocol.EmbeddedSass;

final class ConversionService {
    @Nonnull
    static EmbeddedSass.Value toSassValue(@Nullable Object object) {
        if (object == null) {
            return ProtocolUtil.value(EmbeddedSass.SingletonValue.NULL);
        }
        if (object instanceof Boolean) {
            return ProtocolUtil.value((Boolean)object != false ? EmbeddedSass.SingletonValue.TRUE : EmbeddedSass.SingletonValue.FALSE);
        }
        if (object instanceof CharSequence) {
            EmbeddedSass.Value.String sassString = EmbeddedSass.Value.String.newBuilder().setQuoted(true).setText(object.toString()).build();
            return ProtocolUtil.value(sassString);
        }
        if (object instanceof Number) {
            EmbeddedSass.Value.Number sassNumber = EmbeddedSass.Value.Number.newBuilder().setValue(((Number)object).doubleValue()).build();
            return ProtocolUtil.value(sassNumber);
        }
        if (object instanceof Collection) {
            List<EmbeddedSass.Value> sassValues = ((Collection)object).stream().map(ConversionService::toSassValue).collect(Collectors.toList());
            return ProtocolUtil.value(ProtocolUtil.list(sassValues));
        }
        if (object instanceof Map) {
            List<EmbeddedSass.Value.Map.Entry> sassEntries = ((Map)object).entrySet().stream().map(entry -> EmbeddedSass.Value.Map.Entry.newBuilder().setKey(ConversionService.toSassValue(entry.getKey())).setValue(ConversionService.toSassValue(entry.getValue())).build()).collect(Collectors.toList());
            return ProtocolUtil.value(ProtocolUtil.map(sassEntries));
        }
        if (object instanceof EmbeddedSass.Value) {
            return (EmbeddedSass.Value)object;
        }
        if (object instanceof EmbeddedSass.Value.String) {
            return ProtocolUtil.value((EmbeddedSass.Value.String)object);
        }
        if (object instanceof EmbeddedSass.Value.Number) {
            return ProtocolUtil.value((EmbeddedSass.Value.Number)object);
        }
        if (object instanceof EmbeddedSass.Value.RgbColor) {
            return ProtocolUtil.value((EmbeddedSass.Value.RgbColor)object);
        }
        if (object instanceof EmbeddedSass.Value.HslColor) {
            return ProtocolUtil.value((EmbeddedSass.Value.HslColor)object);
        }
        if (object instanceof EmbeddedSass.Value.List) {
            return ProtocolUtil.value((EmbeddedSass.Value.List)object);
        }
        if (object instanceof EmbeddedSass.Value.Map) {
            return ProtocolUtil.value((EmbeddedSass.Value.Map)object);
        }
        if (object instanceof EmbeddedSass.SingletonValue) {
            return ProtocolUtil.value((EmbeddedSass.SingletonValue)object);
        }
        if (object instanceof EmbeddedSass.Value.CompilerFunction) {
            return ProtocolUtil.value((EmbeddedSass.Value.CompilerFunction)object);
        }
        if (object instanceof EmbeddedSass.Value.HostFunction) {
            return ProtocolUtil.value((EmbeddedSass.Value.HostFunction)object);
        }
        if (object instanceof EmbeddedSass.Value.ArgumentList) {
            return ProtocolUtil.value((EmbeddedSass.Value.ArgumentList)object);
        }
        if (object instanceof EmbeddedSass.Value.HwbColor) {
            return ProtocolUtil.value((EmbeddedSass.Value.HwbColor)object);
        }
        if (object instanceof EmbeddedSass.Value.Calculation) {
            return ProtocolUtil.value((EmbeddedSass.Value.Calculation)object);
        }
        throw new RuntimeException("Cant convert to Sass value");
    }

    @Nullable
    static <T> T toJavaValue(@NonNull EmbeddedSass.Value value, Class<T> targetType, Type parameterizedType) {
        if (value == null) {
            throw new IllegalArgumentException("value is marked non-null but is null");
        }
        if (targetType.equals(EmbeddedSass.Value.class)) {
            return (T)value;
        }
        switch (value.getValueCase()) {
            case STRING: {
                EmbeddedSass.Value.String sassString = value.getString();
                if (targetType.isAssignableFrom(EmbeddedSass.Value.String.class)) {
                    return (T)sassString;
                }
                if (targetType.isAssignableFrom(String.class)) {
                    return (T)sassString.getText();
                }
                throw new IllegalArgumentException("Cant convert sass String to " + targetType);
            }
            case NUMBER: {
                EmbeddedSass.Value.Number sassNumber = value.getNumber();
                double javaNumber = sassNumber.getValue();
                if (targetType.isAssignableFrom(EmbeddedSass.Value.Number.class)) {
                    return (T)sassNumber;
                }
                if (targetType.isAssignableFrom(Double.class) || targetType.isAssignableFrom(Double.TYPE)) {
                    return (T)Double.valueOf(javaNumber);
                }
                if (targetType.isAssignableFrom(Float.class) || targetType.isAssignableFrom(Float.TYPE)) {
                    return (T)Float.valueOf((float)javaNumber);
                }
                if (targetType.isAssignableFrom(Long.class) || targetType.isAssignableFrom(Long.TYPE)) {
                    return (T)Long.valueOf((long)javaNumber);
                }
                if (targetType.isAssignableFrom(Integer.class) || targetType.isAssignableFrom(Integer.TYPE)) {
                    return (T)Integer.valueOf((int)javaNumber);
                }
                if (targetType.isAssignableFrom(Short.class) || targetType.isAssignableFrom(Short.TYPE)) {
                    return (T)Short.valueOf((short)javaNumber);
                }
                if (targetType.isAssignableFrom(Byte.class) || targetType.isAssignableFrom(Byte.TYPE)) {
                    return (T)Byte.valueOf((byte)javaNumber);
                }
                if (targetType.isAssignableFrom(BigInteger.class)) {
                    return (T)BigInteger.valueOf((long)javaNumber);
                }
                if (targetType.isAssignableFrom(BigDecimal.class)) {
                    return (T)BigDecimal.valueOf(javaNumber);
                }
                if (targetType.isAssignableFrom(String.class)) {
                    return (T)Double.toString(javaNumber);
                }
                throw new IllegalArgumentException("Cant convert sass Number to " + targetType);
            }
            case RGB_COLOR: {
                EmbeddedSass.Value.RgbColor rgbColor = value.getRgbColor();
                if (targetType.isAssignableFrom(EmbeddedSass.Value.RgbColor.class)) {
                    return (T)rgbColor;
                }
                if (targetType.isAssignableFrom(EmbeddedSass.Value.HslColor.class)) {
                    return (T)ColorUtil.toHslColor((EmbeddedSass.Value.RgbColorOrBuilder)rgbColor);
                }
                if (targetType.isAssignableFrom(EmbeddedSass.Value.HwbColor.class)) {
                    return (T)ColorUtil.toHwbColor((EmbeddedSass.Value.RgbColorOrBuilder)rgbColor);
                }
                throw new IllegalArgumentException("Cant convert sass RgbColor to " + targetType);
            }
            case HSL_COLOR: {
                EmbeddedSass.Value.HslColor hslColor = value.getHslColor();
                if (targetType.isAssignableFrom(EmbeddedSass.Value.RgbColor.class)) {
                    return (T)ColorUtil.toRgbColor((EmbeddedSass.Value.HslColorOrBuilder)hslColor);
                }
                if (targetType.isAssignableFrom(EmbeddedSass.Value.HslColor.class)) {
                    return (T)hslColor;
                }
                if (targetType.isAssignableFrom(EmbeddedSass.Value.HwbColor.class)) {
                    return (T)ColorUtil.toHwbColor((EmbeddedSass.Value.HslColorOrBuilder)hslColor);
                }
                throw new IllegalArgumentException("Cant convert sass HslColor to " + targetType);
            }
            case HWB_COLOR: {
                EmbeddedSass.Value.HwbColor hwbColor = value.getHwbColor();
                if (targetType.isAssignableFrom(EmbeddedSass.Value.RgbColor.class)) {
                    return (T)ColorUtil.toRgbColor((EmbeddedSass.Value.HwbColorOrBuilder)hwbColor);
                }
                if (targetType.isAssignableFrom(EmbeddedSass.Value.HslColor.class)) {
                    return (T)ColorUtil.toHslColor((EmbeddedSass.Value.HwbColorOrBuilder)hwbColor);
                }
                if (targetType.isAssignableFrom(EmbeddedSass.Value.HwbColor.class)) {
                    return (T)hwbColor;
                }
                throw new IllegalArgumentException("Cant convert sass HwbColor to " + targetType);
            }
            case LIST: {
                EmbeddedSass.Value.List sassList = value.getList();
                if (targetType.isAssignableFrom(EmbeddedSass.Value.List.class)) {
                    return (T)sassList;
                }
                if (targetType.isAssignableFrom(List.class)) {
                    Type elementType = ((ParameterizedType)parameterizedType).getActualTypeArguments()[0];
                    Class elementClass = elementType instanceof Class ? (Class)elementType : (Class)((ParameterizedType)elementType).getRawType();
                    List collect = sassList.getContentsList().stream().map(elementValue -> ConversionService.toJavaValue(elementValue, elementClass, elementType)).collect(Collectors.toList());
                    return (T)Collections.unmodifiableList(collect);
                }
                throw new IllegalArgumentException("Cant convert sass List to " + targetType);
            }
            case MAP: {
                EmbeddedSass.Value.Map sassMap = value.getMap();
                if (targetType.isAssignableFrom(EmbeddedSass.Value.Map.class)) {
                    return (T)sassMap;
                }
                if (targetType.isAssignableFrom(Map.class)) {
                    Type keyType = ((ParameterizedType)parameterizedType).getActualTypeArguments()[0];
                    Type valueType = ((ParameterizedType)parameterizedType).getActualTypeArguments()[1];
                    Class keyClass = keyType instanceof Class ? (Class)keyType : (Class)((ParameterizedType)keyType).getRawType();
                    Class valueClass = valueType instanceof Class ? (Class)valueType : (Class)((ParameterizedType)valueType).getRawType();
                    Map<Object, Object> collect = sassMap.getEntriesList().stream().collect(Collectors.toMap(sassEntry -> ConversionService.toJavaValue(sassEntry.getKey(), keyClass, keyType), sassEntry -> ConversionService.toJavaValue(sassEntry.getValue(), valueClass, valueType)));
                    return (T)Collections.unmodifiableMap(collect);
                }
                throw new IllegalArgumentException("Cant convert sass Map to " + targetType);
            }
            case SINGLETON: {
                EmbeddedSass.SingletonValue singleton = value.getSingleton();
                switch (value.getSingleton()) {
                    case TRUE: 
                    case FALSE: {
                        Boolean boolValue = singleton == EmbeddedSass.SingletonValue.TRUE;
                        if (targetType.equals(Boolean.class) || targetType.equals(Boolean.TYPE)) {
                            return (T)boolValue;
                        }
                        if (targetType.equals(String.class)) {
                            return (T)Boolean.toString(boolValue);
                        }
                        throw new IllegalArgumentException("Cant convert sass boolean to " + targetType);
                    }
                    case NULL: {
                        if (targetType.equals(EmbeddedSass.SingletonValue.class)) {
                            return (T)EmbeddedSass.SingletonValue.NULL;
                        }
                        return null;
                    }
                    case UNRECOGNIZED: {
                        throw new IllegalArgumentException("Unknown sass singleton: " + value.getSingleton());
                    }
                }
                throw new IllegalStateException("Unknown sass singleton: " + value.getSingleton());
            }
            case CALCULATION: {
                EmbeddedSass.Value.Calculation calculation = value.getCalculation();
                if (targetType.isAssignableFrom(EmbeddedSass.Value.Calculation.class)) {
                    return (T)calculation;
                }
                throw new IllegalArgumentException("Cant convert sass Calculation to " + targetType);
            }
            case COMPILER_FUNCTION: {
                EmbeddedSass.Value.CompilerFunction compilerFunction = value.getCompilerFunction();
                if (targetType.isAssignableFrom(EmbeddedSass.Value.CompilerFunction.class)) {
                    return (T)compilerFunction;
                }
                throw new IllegalArgumentException("Cant convert sass CompilerFunction to " + targetType);
            }
            case HOST_FUNCTION: {
                EmbeddedSass.Value.HostFunction hostFunction = value.getHostFunction();
                if (targetType.isAssignableFrom(EmbeddedSass.Value.HostFunction.class)) {
                    return (T)hostFunction;
                }
                throw new IllegalArgumentException("Cant convert sass HostFunction to " + targetType);
            }
            case VALUE_NOT_SET: {
                return null;
            }
        }
        throw new IllegalStateException("Unknown value: " + value.getValueCase());
    }

    @Generated
    private ConversionService() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

