/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.spring;

import de.larsgrefer.sass.embedded.SassCompiler;
import de.larsgrefer.sass.embedded.spring.CompiledResource;
import de.larsgrefer.sass.embedded.spring.SassResourceUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import lombok.Generated;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.resource.ResourceTransformer;
import org.springframework.web.servlet.resource.ResourceTransformerChain;
import sass.embedded_protocol.EmbeddedSass;

public class SassResourceTransformer
implements ResourceTransformer {
    private final SassCompiler sassCompiler;
    private EmbeddedSass.OutputStyle outputStyle;

    public Resource transform(HttpServletRequest request, Resource resource, ResourceTransformerChain transformerChain) throws IOException {
        if ((resource = transformerChain.transform(request, resource)) instanceof CompiledResource && ((CompiledResource)resource).getOutputStyle() == this.outputStyle) {
            return resource;
        }
        String filename = resource.getFilename();
        if (!"css".equals(StringUtils.getFilenameExtension((String)filename))) {
            return resource;
        }
        EmbeddedSass.InboundMessage.CompileRequest.StringInput stringInput = SassResourceUtil.toStringInput(resource, EmbeddedSass.Syntax.CSS);
        try {
            EmbeddedSass.OutboundMessage.CompileResponse.CompileSuccess compileSuccess = this.sassCompiler.compileString(stringInput, this.outputStyle);
            return new CompiledResource(resource, compileSuccess, resource.getFilename(), this.outputStyle);
        }
        catch (Exception e) {
            return resource;
        }
    }

    @Generated
    public SassResourceTransformer(SassCompiler sassCompiler, EmbeddedSass.OutputStyle outputStyle) {
        this.sassCompiler = sassCompiler;
        this.outputStyle = outputStyle;
    }

    @Generated
    public SassResourceTransformer(SassCompiler sassCompiler) {
        this.sassCompiler = sassCompiler;
    }

    @Generated
    public EmbeddedSass.OutputStyle getOutputStyle() {
        return this.outputStyle;
    }

    @Generated
    public void setOutputStyle(EmbeddedSass.OutputStyle outputStyle) {
        this.outputStyle = outputStyle;
    }
}

