/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.functions;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import sass.embedded_protocol.EmbeddedSass;

public abstract class HostFunction {
    private static final Random hostFunctionIds = new Random();
    private final int id = Math.abs(hostFunctionIds.nextInt());
    private final String name;
    private final List<Argument> arguments;
    private final String signature;

    protected HostFunction(String name, List<Argument> arguments) {
        this.name = name;
        this.arguments = Collections.unmodifiableList(arguments);
        this.signature = this.prepareSignature();
    }

    @Nonnull
    public abstract EmbeddedSass.Value invoke(List<EmbeddedSass.Value> var1) throws Throwable;

    private String prepareSignature() {
        String functionName = this.getName();
        return functionName + this.getArguments().stream().map(Argument::getSassSignature).collect(Collectors.joining(", ", "(", ")"));
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<Argument> getArguments() {
        return this.arguments;
    }

    @Generated
    public String getSignature() {
        return this.signature;
    }

    public static final class Argument {
        private final String name;
        @Nullable
        private final String defaultValue;

        public String getSassSignature() {
            String signature = "$" + this.name;
            if (this.defaultValue != null) {
                signature = signature + ": " + this.defaultValue;
            }
            return signature;
        }

        @Generated
        public Argument(String name, @Nullable String defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Nullable
        @Generated
        public String getDefaultValue() {
            return this.defaultValue;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Argument)) {
                return false;
            }
            Argument other = (Argument)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$defaultValue = this.getDefaultValue();
            String other$defaultValue = other.getDefaultValue();
            return !(this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $defaultValue = this.getDefaultValue();
            result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "HostFunction.Argument(name=" + this.getName() + ", defaultValue=" + this.getDefaultValue() + ")";
        }

        @Generated
        public Argument withName(String name) {
            return this.name == name ? this : new Argument(name, this.defaultValue);
        }

        @Generated
        public Argument withDefaultValue(@Nullable String defaultValue) {
            return this.defaultValue == defaultValue ? this : new Argument(this.name, defaultValue);
        }
    }
}

