/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.spring;

import de.larsgrefer.sass.embedded.SassCompilationFailedException;
import de.larsgrefer.sass.embedded.SassCompiler;
import de.larsgrefer.sass.embedded.spring.CompiledResource;
import de.larsgrefer.sass.embedded.spring.SassResourceUtil;
import de.larsgrefer.sass.embedded.spring.SourceMapResource;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.resource.AbstractResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolverChain;
import sass.embedded_protocol.EmbeddedSass;

public class SassResourceResolver
extends AbstractResourceResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SassResourceResolver.class);
    private final SassCompiler sassCompiler;
    private EmbeddedSass.OutputStyle outputStyle = EmbeddedSass.OutputStyle.COMPRESSED;

    protected Resource resolveResourceInternal(HttpServletRequest request, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        Resource resource = chain.resolveResource(request, requestPath, locations);
        if (resource != null && resource.exists()) {
            return resource;
        }
        String filename = StringUtils.getFilename((String)requestPath);
        if (filename.endsWith(".css") || filename.endsWith(".css.map") && this.sassCompiler.isGenerateSourceMaps()) {
            boolean sourcemap = filename.endsWith(".css.map");
            String basePath = requestPath.substring(0, requestPath.length() - (sourcemap ? 8 : 4));
            for (String extension : Arrays.asList(".scss", ".sass")) {
                String scssPath = basePath + extension;
                Resource scssResource = chain.resolveResource(request, scssPath, locations);
                if (scssResource == null || !scssResource.exists()) continue;
                try {
                    EmbeddedSass.InboundMessage.CompileRequest.StringInput si = SassResourceUtil.toStringInput(scssResource);
                    EmbeddedSass.OutboundMessage.CompileResponse.CompileSuccess compileSuccess = this.sassCompiler.compileString(si, this.outputStyle);
                    if (sourcemap) {
                        return new SourceMapResource(scssResource, compileSuccess, filename, this.outputStyle);
                    }
                    return new CompiledResource(scssResource, compileSuccess, filename, this.outputStyle);
                }
                catch (SassCompilationFailedException | IOException e) {
                    log.info(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }

    protected String resolveUrlPathInternal(String resourcePath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return chain.resolveUrlPath(resourcePath, locations);
    }

    @Generated
    public SassResourceResolver(SassCompiler sassCompiler) {
        this.sassCompiler = sassCompiler;
    }

    @Generated
    public SassResourceResolver(SassCompiler sassCompiler, EmbeddedSass.OutputStyle outputStyle) {
        this.sassCompiler = sassCompiler;
        this.outputStyle = outputStyle;
    }

    @Generated
    public void setOutputStyle(EmbeddedSass.OutputStyle outputStyle) {
        this.outputStyle = outputStyle;
    }
}

