/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.util;

import java.io.File;
import java.net.URL;
import lombok.Generated;
import lombok.NonNull;
import sass.embedded_protocol.EmbeddedSass;

public final class SyntaxUtil {
    public static EmbeddedSass.Syntax guessSyntax(@NonNull URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url is marked non-null but is null");
        }
        return SyntaxUtil.guessSyntax(url.getPath());
    }

    public static EmbeddedSass.Syntax guessSyntax(@NonNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("file is marked non-null but is null");
        }
        return SyntaxUtil.guessSyntax(file.getName());
    }

    public static EmbeddedSass.Syntax guessSyntax(@NonNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("path is marked non-null but is null");
        }
        String lowerPath = path.toLowerCase();
        if (lowerPath.endsWith(".css")) {
            return EmbeddedSass.Syntax.CSS;
        }
        if (lowerPath.endsWith(".scss")) {
            return EmbeddedSass.Syntax.SCSS;
        }
        if (lowerPath.endsWith(".sass")) {
            return EmbeddedSass.Syntax.INDENTED;
        }
        return EmbeddedSass.Syntax.UNRECOGNIZED;
    }

    @Generated
    private SyntaxUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

