/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.util;

import de.larsgrefer.sass.embedded.util.ColorValidator;
import java.awt.Color;
import javax.annotation.Nonnull;
import lombok.Generated;
import sass.embedded_protocol.EmbeddedSass;

@Nonnull
public final class ColorUtil {
    public static Color toJavaColor(EmbeddedSass.Value.HwbColorOrBuilder hwbColor) {
        ColorValidator.assertValid(hwbColor);
        float white = (float)(hwbColor.getWhiteness() / 100.0);
        float black = (float)(hwbColor.getBlackness() / 100.0);
        double[] rgb = ColorUtil.hslToRgb(hwbColor.getHue(), 1.0, 0.5);
        int i = 0;
        while (i < 3) {
            int n = i;
            rgb[n] = rgb[n] * (double)(1.0f - white - black);
            int n2 = i++;
            rgb[n2] = rgb[n2] + (double)white;
        }
        return new Color((float)rgb[0], (float)rgb[1], (float)rgb[2], (float)hwbColor.getAlpha());
    }

    public static Color toJavaColor(EmbeddedSass.Value.HslColorOrBuilder hslColor) {
        ColorValidator.assertValid(hslColor);
        double[] rgb = ColorUtil.hslToRgb(hslColor.getHue(), hslColor.getSaturation(), hslColor.getLightness());
        return new Color((float)rgb[0], (float)rgb[1], (float)rgb[2], (float)hslColor.getAlpha());
    }

    public static Color toJavaColor(EmbeddedSass.Value.RgbColorOrBuilder rgbColor) {
        ColorValidator.assertValid(rgbColor);
        return new Color(rgbColor.getRed(), rgbColor.getGreen(), rgbColor.getBlue(), (int)(rgbColor.getAlpha() * 255.0));
    }

    public static EmbeddedSass.Value.RgbColor toRgbColor(EmbeddedSass.Value.HwbColorOrBuilder hwbColor) {
        ColorValidator.assertValid(hwbColor);
        return ColorUtil.toRgbColor(ColorUtil.toJavaColor(hwbColor));
    }

    public static EmbeddedSass.Value.RgbColor toRgbColor(EmbeddedSass.Value.HslColorOrBuilder hslColor) {
        ColorValidator.assertValid(hslColor);
        return ColorUtil.toRgbColor(ColorUtil.toJavaColor(hslColor));
    }

    public static EmbeddedSass.Value.RgbColor toRgbColor(Color color) {
        return EmbeddedSass.Value.RgbColor.newBuilder().setRed(color.getRed()).setGreen(color.getGreen()).setBlue(color.getBlue()).setAlpha((double)color.getAlpha() / 255.0).build();
    }

    public static EmbeddedSass.Value.HwbColor toHwbColor(EmbeddedSass.Value.HslColorOrBuilder hslColor) {
        ColorValidator.assertValid(hslColor);
        return ColorUtil.toHwbColor((EmbeddedSass.Value.RgbColorOrBuilder)ColorUtil.toRgbColor(hslColor));
    }

    public static EmbeddedSass.Value.HwbColor toHwbColor(EmbeddedSass.Value.RgbColorOrBuilder rgbColor) {
        ColorValidator.assertValid(rgbColor);
        double[] hwb = ColorUtil.rgbToHwb(rgbColor.getRed(), rgbColor.getGreen(), rgbColor.getBlue());
        return EmbeddedSass.Value.HwbColor.newBuilder().setHue(hwb[0]).setWhiteness(hwb[1]).setBlackness(hwb[2]).setAlpha(rgbColor.getAlpha()).build();
    }

    private static double[] hslToRgb(double hue, double sat, double light) {
        double t2 = light <= 0.5 ? light * (sat + 1.0) : light + sat - light * sat;
        double t1 = light * 2.0 - t2;
        double r = ColorUtil.hueToRgb(t1, t2, (hue *= 6.0) + 2.0);
        double g = ColorUtil.hueToRgb(t1, t2, hue);
        double b = ColorUtil.hueToRgb(t1, t2, hue - 2.0);
        return new double[]{r, g, b};
    }

    private static double hueToRgb(double t1, double t2, double hue) {
        if (hue < 0.0) {
            hue += 6.0;
        }
        if (hue >= 6.0) {
            hue -= 6.0;
        }
        if (hue < 1.0) {
            return (t2 - t1) * hue + t1;
        }
        if (hue < 3.0) {
            return t2;
        }
        if (hue < 4.0) {
            return (t2 - t1) * (4.0 - hue) + t1;
        }
        return t1;
    }

    private static double[] rgbToHwb(int red, int green, int blue) {
        float[] hsl = Color.RGBtoHSB(red, green, blue, null);
        double white = ColorUtil.min(red, green, blue) / 255.0;
        double black = 1.0 - ColorUtil.max(red, green, blue) / 255.0;
        return new double[]{hsl[0], white * 100.0, black * 100.0};
    }

    private static double min(double ... vals) {
        double min = vals[0];
        for (double val : vals) {
            min = Math.min(min, val);
        }
        return min;
    }

    private static double max(double ... vals) {
        double max = vals[0];
        for (double val : vals) {
            max = Math.max(max, val);
        }
        return max;
    }

    @Generated
    private ColorUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

