/*
 * Decompiled with CFR 0.152.
 */
package de.larsgrefer.sass.embedded.functions;

import de.larsgrefer.sass.embedded.functions.BiFunctionHostFunction;
import de.larsgrefer.sass.embedded.functions.CallableHostFunction;
import de.larsgrefer.sass.embedded.functions.FunctionHostFunction;
import de.larsgrefer.sass.embedded.functions.HostFunction;
import de.larsgrefer.sass.embedded.functions.ReflectiveHostFunction;
import de.larsgrefer.sass.embedded.functions.SassFunction;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public final class HostFunctionFactory {
    public static <T> List<HostFunction> allSassFunctions(@Nonnull T object) {
        return HostFunctionFactory.allSassFunctions(object.getClass(), object);
    }

    public static List<HostFunction> allSassFunctions(@Nonnull Class<?> clazz) {
        return HostFunctionFactory.allSassFunctions(clazz, null);
    }

    public static <T> List<HostFunction> allSassFunctions(@Nonnull Class<T> clazz, @Nullable T object) {
        Method[] methods;
        ArrayList<HostFunction> result = new ArrayList<HostFunction>();
        for (Method method : methods = clazz.getMethods()) {
            if (!method.isAnnotationPresent(SassFunction.class)) continue;
            result.add(HostFunctionFactory.ofMethod(method, object));
        }
        return result;
    }

    public static HostFunction ofMethod(Method method) {
        return HostFunctionFactory.ofMethod(method, null);
    }

    public static HostFunction ofMethod(@Nonnull Method method, @Nullable Object targetObject) {
        return new ReflectiveHostFunction(method, targetObject);
    }

    public static HostFunction ofLambda(String name, Callable<?> lambda) {
        return new CallableHostFunction(name, lambda);
    }

    public static <T> HostFunction ofLambda(String name, Class<T> argType, Function<T, ?> lambda) {
        return new FunctionHostFunction<T>(name, argType, lambda);
    }

    public static <T, U> HostFunction ofLambda(String name, Class<T> arg0Type, Class<U> arg1Type, BiFunction<T, U, ?> lambda) {
        return new BiFunctionHostFunction<T, U>(name, arg0Type, arg1Type, lambda);
    }

    @Generated
    private HostFunctionFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

